/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.web;

import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.utils.IssuerUtils;
import com.ibm.ws.security.oauth20.api.OAuth20EnhancedTokenCache;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.openidconnect.server.internal.HashUtils;
import com.ibm.ws.security.openidconnect.server.internal.JwtUtils;
import com.ibm.ws.security.openidconnect.token.IDTokenValidationFailedException;
import com.ibm.ws.security.openidconnect.token.JWT;
import com.ibm.ws.security.openidconnect.token.JWTPayload;
import com.ibm.ws.security.openidconnect.token.JsonTokenUtil;
import com.ibm.ws.security.openidconnect.web.OidcEndpointServices;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcRpInitiatedLogoutTokenAndRequestData {
    private static TraceComponent tc = Tr.register(OidcRpInitiatedLogoutTokenAndRequestData.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    private final HttpServletRequest request;
    private final OidcEndpointServices endpointServices;
    private final OAuth20Provider oauth20Provider;
    private final OidcServerConfig oidcServerConfig;
    private Principal userPrincipal = null;
    private String userPrincipalName = null;
    private String idTokenHintParameter = null;
    private String postLogoutRedirectUriParameter = null;
    private String subjectFromIdToken = null;
    private String clientId = null;
    private String state = null;
    private OAuth20Token cachedIdToken = null;
    private boolean isDataValidForLogout = false;
    static final long serialVersionUID = -2109873434348182230L;

    public OidcRpInitiatedLogoutTokenAndRequestData(HttpServletRequest request, OidcEndpointServices endpointServices, OAuth20Provider oauth20Provider, OidcServerConfig oidcServerConfig) {
        this.request = request;
        this.endpointServices = endpointServices;
        this.oauth20Provider = oauth20Provider;
        this.oidcServerConfig = oidcServerConfig;
    }

    public void populate() {
        this.isDataValidForLogout = true;
        this.initializeUserPrincipalData();
        this.initializeValuesFromRequestParameters();
        this.cachedIdToken = this.getCachedIdToken(this.idTokenHintParameter);
        this.subjectFromIdToken = this.cachedIdToken == null ? null : this.cachedIdToken.getUsername();
        String string = this.clientId = this.cachedIdToken == null ? this.clientId : this.cachedIdToken.getClientId();
        if (this.idTokenHintParameter != null && this.cachedIdToken == null && this.isDataValidForLogout) {
            this.parseAndPopulateDataFromIdTokenHint();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("login username : " + this.userPrincipalName + " IDToken username : " + this.subjectFromIdToken), (Object[])new Object[0]);
        }
        if (this.userPrincipalName != null && this.subjectFromIdToken != null && !this.userPrincipalName.equals(this.subjectFromIdToken)) {
            Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_USERNAME_MISMATCH_ERR", (Object[])new Object[]{this.userPrincipalName, this.subjectFromIdToken});
            this.isDataValidForLogout = false;
        }
    }

    void initializeUserPrincipalData() {
        this.userPrincipal = this.request.getUserPrincipal();
        this.userPrincipalName = this.userPrincipal == null ? null : this.userPrincipal.getName();
    }

    void initializeValuesFromRequestParameters() {
        this.idTokenHintParameter = this.request.getParameter("id_token_hint");
        if (this.idTokenHintParameter != null && this.idTokenHintParameter.isEmpty()) {
            this.idTokenHintParameter = null;
        }
        this.postLogoutRedirectUriParameter = this.request.getParameter("post_logout_redirect_uri");
        if (this.postLogoutRedirectUriParameter != null && this.postLogoutRedirectUriParameter.isEmpty()) {
            this.postLogoutRedirectUriParameter = null;
        }
        this.clientId = this.request.getParameter("client_id");
        if (this.clientId != null && this.clientId.isEmpty()) {
            this.clientId = null;
        }
        this.state = this.request.getParameter("state");
        if (this.state != null && this.state.isEmpty()) {
            this.state = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("id_token_hint : " + this.idTokenHintParameter + ", post_logout_redirect_uri : " + this.postLogoutRedirectUriParameter + ", client_id : " + this.clientId + ", state : " + this.state), (Object[])new Object[0]);
        }
    }

    OAuth20Token getCachedIdToken(String idTokenString) {
        OAuth20EnhancedTokenCache tokenCache;
        OAuth20Token cachedIdToken = null;
        if (idTokenString != null && (tokenCache = this.oauth20Provider.getTokenCache()) != null) {
            String hash = HashUtils.digest(idTokenString);
            if (hash != null) {
                cachedIdToken = tokenCache.get(hash);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("idToken : " + cachedIdToken), (Object[])new Object[0]);
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_IDTOKEN_VERIFY_ERR", (Object[])new Object[]{"IDTokenValidatonFailedException"});
                this.isDataValidForLogout = false;
            }
        }
        return cachedIdToken;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={IDTokenValidationFailedException.class})
    void parseAndPopulateDataFromIdTokenHint() {
        try {
            this.parseAndValidateIdTokenHint();
        }
        catch (IDTokenValidationFailedException ivfe) {
            Throwable cause = ivfe.getCause();
            if (cause != null && cause instanceof IllegalStateException) {
                try {
                    JWTPayload payload = JsonTokenUtil.getPayload((String)this.idTokenHintParameter);
                    if (payload != null) {
                        this.subjectFromIdToken = JsonTokenUtil.getSub((JWTPayload)payload);
                        this.clientId = this.getVerifiedClientId(payload);
                    }
                }
                catch (Exception payload) {
                    void e;
                    FFDCFilter.processException((Throwable)payload, (String)"com.ibm.ws.security.openidconnect.web.OidcRpInitiatedLogoutTokenAndRequestData", (String)"150", (Object)this, (Object[])new Object[0]);
                    Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_IDTOKEN_VERIFY_ERR", (Object[])new Object[]{e.getMessage()});
                    this.isDataValidForLogout = false;
                }
            }
            Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_IDTOKEN_VERIFY_ERR", (Object[])new Object[]{ivfe.getMessage()});
            this.isDataValidForLogout = false;
        }
        catch (Exception ivfe) {
            void e;
            FFDCFilter.processException((Throwable)ivfe, (String)"com.ibm.ws.security.openidconnect.web.OidcRpInitiatedLogoutTokenAndRequestData", (String)"158", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_IDTOKEN_VERIFY_ERR", (Object[])new Object[]{e.getMessage()});
            this.isDataValidForLogout = false;
        }
    }

    void parseAndValidateIdTokenHint() throws Exception {
        JWT jwt = JwtUtils.createJwt(this.idTokenHintParameter, this.oauth20Provider, this.oidcServerConfig);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JWT : " + jwt), (Object[])new Object[0]);
        }
        if (jwt.verifySignatureOnly()) {
            this.verifyIdTokenHintIssuer(jwt);
            this.subjectFromIdToken = JsonTokenUtil.getSub((JWTPayload)jwt.getPayload());
            this.clientId = this.getVerifiedClientId(jwt.getPayload());
        } else {
            Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_IDTOKEN_VERIFY_ERR", (Object[])new Object[]{"IDTokenValidatonFailedException"});
            this.isDataValidForLogout = false;
        }
    }

    String getVerifiedClientId(JWTPayload payload) throws IDTokenValidationFailedException {
        String clientIdFromPayload = JsonTokenUtil.getAud((JWTPayload)payload);
        if (this.clientId != null && !this.clientId.equals(clientIdFromPayload)) {
            throw IDTokenValidationFailedException.format((TraceComponent)tc, (String)"ID_TOKEN_HINT_CLIENT_ID_DOES_NOT_MATCH_REQUEST_PARAMETER", (Object[])new Object[]{clientIdFromPayload, this.clientId});
        }
        return clientIdFromPayload;
    }

    void verifyIdTokenHintIssuer(JWT jwt) throws IDTokenValidationFailedException {
        String iss = JsonTokenUtil.getIss((JWTPayload)jwt.getPayload());
        String issuerIdentifier = this.oidcServerConfig.getIssuerIdentifier();
        if (issuerIdentifier == null || issuerIdentifier.isEmpty()) {
            issuerIdentifier = IssuerUtils.getCalculatedIssuerIdFromRequest((HttpServletRequest)this.request);
        }
        if (!issuerIdentifier.equals(iss)) {
            throw IDTokenValidationFailedException.format((TraceComponent)tc, (String)"ID_TOKEN_ISSUER_NOT_THIS_OP", (Object[])new Object[]{iss, issuerIdentifier, this.oidcServerConfig.getProviderId()});
        }
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public String getUserPrincipalName() {
        return this.userPrincipalName;
    }

    public String getIdTokenHintParameter() {
        return this.idTokenHintParameter;
    }

    public String getPostLogoutRedirectUriParameter() {
        return this.postLogoutRedirectUriParameter;
    }

    public String getSubjectFromIdToken() {
        return this.subjectFromIdToken;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getState() {
        return this.state;
    }

    public OAuth20Token getCachedIdToken() {
        return this.cachedIdToken;
    }

    public boolean isDataValidForLogout() {
        return this.isDataValidForLogout;
    }
}

