/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.sip.IBMSipSession;
import com.ibm.ws.sip.container.events.ContextEstablisher;
import com.ibm.ws.sip.container.events.EventsDispatcher;
import com.ibm.ws.sip.container.failover.ReplicatableImpl;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.container.proxy.SipProxyInfo;
import com.ibm.ws.sip.container.servlets.EmptyEnumeration;
import com.ibm.ws.sip.container.servlets.LstNotificationType;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipSessionAttributeListener;
import javax.servlet.sip.SipSessionBindingEvent;
import javax.servlet.sip.SipSessionEvent;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.UAMode;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;

public class SipSessionImplementation
extends ReplicatableImpl
implements IBMSipSession {
    private static final transient long serialVersionUID = -4671996658675281828L;
    private static final transient LogMgr c_logger = Log.get(SipSessionImplementation.class);
    protected long m_creationTime;
    protected HashSet<String> m_attributes;
    protected long m_lastAccessedTime;
    protected TransactionUserWrapper _transactionUser;
    protected transient boolean _createdNotificationWasSent = false;
    protected String _sipSessionId;
    protected transient boolean _isDuringInvalidation = false;
    protected String _b2bLinkedSessionId = null;
    protected SipSessionImplementation _b2bLinkedSession;
    protected transient boolean _isDirty = false;
    protected boolean m_invalidateWhenReady = false;
    private transient String m_sessionCallID = null;
    private transient SipAppDesc m_appDesc = null;

    SipSessionImplementation(TransactionUserWrapper tUser) {
        this._transactionUser = tUser;
        this.init();
    }

    SipSessionImplementation(TransactionUserWrapper tUser, SipSessionImplementation originalSipSession) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "SipSessionImplementation", " Create derived SipSession for base = " + originalSipSession.getId());
        }
        this._transactionUser = tUser;
        this.init();
        this.createdDerivedAttributes(originalSipSession);
    }

    public TransactionUserWrapper getTransactionUser() {
        return this._transactionUser;
    }

    private boolean belongToJSR289Application() {
        if (this.m_appDesc != null) {
            return this.m_appDesc.isJSR289Application();
        }
        return false;
    }

    protected void init() {
        String defaultHandler = ThreadLocalStorage.getSipServletName();
        try {
            this.setHandler(defaultHandler);
        }
        catch (ServletException servletException) {
            // empty catch block
        }
        this.setSharedId(this._transactionUser.getId());
        this.m_lastAccessedTime = this.m_creationTime = System.currentTimeMillis();
        this.m_appDesc = this._transactionUser.getSipServletDesc().getSipApp();
        if (this.m_appDesc.isJSR289Application()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "SipSessionImplementation", "this is 289 app - m_invalidateWhenReady is true");
            }
            this.m_invalidateWhenReady = true;
        }
        this.m_sessionCallID = this._transactionUser.getCallId();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "SipSessionImplementation", "New SipSession id = " + this.getId());
        }
        this._transactionUser.logToContext(257, this.getId());
        this.updatePerformanceAboutNewSession();
    }

    @Override
    public SipServletRequest createRequest(String method) {
        if (this._isDuringInvalidation) {
            throw new IllegalStateException("This session is already invalidated");
        }
        SipServletRequest req = this.getInternalTuWrapper().createRequest(method);
        return req;
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        return this.getInternalTuWrapper().getApplicationSession(true);
    }

    public SipApplicationSession getApplicationSession(boolean create) {
        return this.getInternalTuWrapper().getApplicationSession(create);
    }

    @Override
    public synchronized Object getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.checkIsSessionValid();
        Object rValue = null;
        if (null != this.m_attributes) {
            rValue = SessionRepository.getInstance().getSipSessAttr(this, name);
        }
        return rValue;
    }

    private void checkIsSessionValid() throws IllegalStateException {
        if (this.getInternalTuWrapper() != null) {
            this.getInternalTuWrapper().ensureTUActive();
        }
    }

    @Override
    public synchronized Enumeration getAttributeNames() {
        Enumeration e2;
        this.checkIsSessionValid();
        if (this.m_attributes != null) {
            Vector<String> v = new Vector<String>(this.m_attributes);
            e2 = v.elements();
        } else {
            e2 = EmptyEnumeration.getInstance();
        }
        return e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeAttribute(String name) {
        this.checkIsSessionValid();
        if (this._isDuringInvalidation) {
            return;
        }
        if (null == this.m_attributes || this.m_attributes.isEmpty()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "removeAttribute", "No attributes to remove.");
            }
            return;
        }
        HashSet<String> hashSet = this.m_attributes;
        synchronized (hashSet) {
            boolean removeSucceeded = this.m_attributes.remove(name);
            if (!removeSucceeded) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "removeAttribute", "Failed to remove attribute:" + name);
                }
                return;
            }
        }
        EventsDispatcher.SipSessionAttributeBounding(this, name, this.m_appDesc, false);
        Object obj = null;
        if (!this._isDuringInvalidation) {
            obj = SessionRepository.getInstance().removeAttribute(this, name);
        }
        this.sendAttrNotification(name, LstNotificationType.SESSION_ATTRIBUTE_REMOVED);
    }

    private synchronized void createdDerivedAttributes(SipSessionImplementation origSipSession) {
        this.checkIsSessionValid();
        Enumeration attrNames = origSipSession.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            Object value = origSipSession.getAttribute(attrName);
            if (attrName == null || value == null) {
                if (!c_logger.isTraceDebugEnabled()) continue;
                c_logger.traceDebug(this, "createdDerivedAttributes", "null value was detected for attribute:" + attrName);
                continue;
            }
            if (this.m_attributes == null) {
                this.m_attributes = new LinkedHashSet<String>(2);
            }
            SessionRepository.getInstance().putSSAttr(this, attrName, value);
            this.m_attributes.add(attrName);
            this._isDirty = true;
        }
    }

    @Override
    public synchronized void setAttribute(String name, Object attribute) {
        Object prev = this.changeAttribute(name, attribute);
        this._isDirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object changeAttribute(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name of attribute is null");
        }
        this.checkIsSessionValid();
        if (this.m_appDesc != null && this.m_appDesc.isDistributed() && !(value instanceof Serializable)) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "changeAttribute", "Attribute must implement Serializable ... attrName = " + name + this);
            }
            throw new IllegalArgumentException("Attribute not Serializable: Attribute name=" + name + ", Attribute=" + value);
        }
        if (null == this.m_attributes) {
            this.m_attributes = new LinkedHashSet<String>(2);
        }
        Object prev = null;
        HashSet<String> hashSet = this.m_attributes;
        synchronized (hashSet) {
            prev = SessionRepository.getInstance().putSSAttr(this, name, value);
            this.m_attributes.add(name);
        }
        EventsDispatcher.SipSessionAttributeBounding(this, name, this.m_appDesc, true);
        if (prev == null) {
            this.sendAttrNotification(name, LstNotificationType.SESSION_ATTRIBUTE_ADDED);
        } else {
            this.sendAttrNotification(name, LstNotificationType.SESSION_ATTRIBUTE_REPLACED);
        }
        return prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends EventListener> void sendEvent(Collection<T> listeners, Object evt, LstNotificationType attrNotifyType) {
        Iterator<T> iter = listeners.iterator();
        ContextEstablisher contextEstablisher = this.m_appDesc.getContextEstablisher();
        ClassLoader currentThreaClassLoader = null;
        try {
            if (contextEstablisher != null) {
                currentThreaClassLoader = contextEstablisher.getThreadCurrentClassLoader();
                contextEstablisher.establishContext();
            }
            while (iter.hasNext()) {
                try {
                    switch (attrNotifyType) {
                        case SESSION_ATTRIBUTE_ADDED: {
                            ((SipSessionAttributeListener)iter.next()).attributeAdded((SipSessionBindingEvent)evt);
                            break;
                        }
                        case SESSION_ATTRIBUTE_REPLACED: {
                            ((SipSessionAttributeListener)iter.next()).attributeReplaced((SipSessionBindingEvent)evt);
                            break;
                        }
                        case SESSION_ATTRIBUTE_REMOVED: {
                            ((SipSessionAttributeListener)iter.next()).attributeRemoved((SipSessionBindingEvent)evt);
                            break;
                        }
                        case SESSION_CREATED: {
                            ((SipSessionListener)iter.next()).sessionCreated((SipSessionEvent)evt);
                            break;
                        }
                        case SESSION_DESTROYED: {
                            ((SipSessionListener)iter.next()).sessionDestroyed((SipSessionEvent)evt);
                            break;
                        }
                        case SESSION_READY_TO_INVALIDATE: {
                            ((SipSessionListener)iter.next()).sessionReadyToInvalidate((SipSessionEvent)evt);
                            break;
                        }
                    }
                }
                catch (Exception e2) {
                    if (!c_logger.isTraceDebugEnabled()) continue;
                    c_logger.traceDebug(this, "sendSessionReadyToInvalidateEvt", "Exception  = " + e2.getMessage());
                }
            }
        }
        finally {
            if (contextEstablisher != null) {
                contextEstablisher.removeContext(currentThreaClassLoader);
            }
        }
    }

    public void sendAttrNotification(String attrName, LstNotificationType type) {
        if (c_logger.isTraceEntryExitEnabled()) {
            StringBuffer buff = new StringBuffer(attrName);
            buff.append((Object)type);
            c_logger.traceEntryExit((Object)this, "sendAttributeAddedNotify", buff.toString());
        }
        if (this.m_appDesc != null) {
            Collection<SipSessionAttributeListener> listeners = this.m_appDesc.getSessionAttributesListeners();
            if (!listeners.isEmpty()) {
                SipSessionBindingEvent evt = new SipSessionBindingEvent(this, attrName);
                this.sendEvent(listeners, evt, type);
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "sendAttributeAddedNotify", "Unable to send notification, SIP app Descriptor not available");
        }
    }

    @Override
    public String getCallId() {
        if (this.m_appDesc != null && !this.m_appDesc.isJSR289Application() && !this.getInternalTuWrapper().isTUDialog()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getLocalParty", "This SipSession is not a dialog - callId will be null");
            }
            return null;
        }
        return this.m_sessionCallID;
    }

    @Override
    public long getCreationTime() {
        this.checkIsSessionValid();
        return this.m_creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        return this.m_lastAccessedTime;
    }

    @Override
    public Address getLocalParty() {
        if (!this.m_appDesc.isJSR289Application() && this._transactionUser != null && !this.getInternalTuWrapper().isTUDialog()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getLocalParty", "This SipSession is not a dialog - localParty will be null");
            }
            return null;
        }
        return this.getInternalTuWrapper().getLocalParty();
    }

    @Override
    public Address getRemoteParty() {
        if (this._transactionUser != null && !this.m_appDesc.isJSR289Application() && !this.getInternalTuWrapper().isTUDialog()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getLocalParty", "This SipSession is not a dialog - repmoteParty will be null");
            }
            return null;
        }
        return this.getInternalTuWrapper().getRemoteParty();
    }

    @Override
    public void invalidate() {
        if (!this.isValid()) {
            throw new IllegalStateException("Can not be called on invalidated SipSession");
        }
        this.checkIsSessionValid();
        this.getInternalTuWrapper().invalidateTU(true, true);
    }

    public boolean hasOngoingTransaction() {
        return this.getInternalTuWrapper().hasOngoingTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateSipSession() {
        block11: {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)this, "invalidateSipSession", (Object)this.getId());
            }
            this.getLinkedSession();
            if (this._isDuringInvalidation) {
                return;
            }
            this._isDuringInvalidation = true;
            try {
                this.sendSessionNotification(LstNotificationType.SESSION_DESTROYED);
                if (this.m_attributes == null || this.m_attributes.isEmpty()) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "invalidateSipSession", "No attributes");
                    }
                    break block11;
                }
                HashSet<String> hashSet = this.m_attributes;
                synchronized (hashSet) {
                    EventsDispatcher.SipSessionAllAttributeUnbounding(this, this.m_appDesc);
                }
            }
            finally {
                this.removeFromStorage();
                this.updatePerformanceAboutInvalidatedSession();
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceExit((Object)this, "invalidateSipSession", this.getId());
                }
            }
        }
    }

    public void updatePerformanceAboutNewSession() {
        PerformanceMgr perfMgr = PerformanceMgr.getInstance();
        if (perfMgr != null && null != this.m_appDesc) {
            perfMgr.sipSessionCreated(this.m_appDesc.getApplicationName(), this.m_appDesc.getAppIndexForPmi());
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "updatePerformance", "Unable to update PerfManager SIP app descriptor not available");
        }
    }

    public void updatePerformanceAboutInvalidatedSession() {
        PerformanceMgr perfMgr = PerformanceMgr.getInstance();
        if (perfMgr != null && null != this.m_appDesc) {
            perfMgr.sipSessionDestroyed(this.m_appDesc.getApplicationName(), this.m_appDesc.getAppIndexForPmi());
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "updatePerformanceAboutInvalidatedSession", "Unable to update PerfManager SIP app descriptor not available");
        }
    }

    public void sendDerivedSipSessionCreatedNotification() {
        if (!this._createdNotificationWasSent) {
            this.sendSessionNotification(LstNotificationType.SESSION_CREATED);
            this._createdNotificationWasSent = true;
        }
    }

    public void sendSessionNotification(LstNotificationType type) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntryExit((Object)this, "sendSessionNotification", (Object)type);
        }
        if (this.m_appDesc != null) {
            Collection<SipSessionListener> listeners = this.m_appDesc.getSessionListeners();
            if (!listeners.isEmpty()) {
                SipSessionEvent evt = new SipSessionEvent(this);
                this.sendEvent(listeners, evt, type);
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "sendSessionNotification", "Unable to send notification, SIP app Descriptor not available");
        }
    }

    public void notifyOnActivationOrPassivation(boolean activation) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "notifyOnAppSessionActivationOrPassivation", activation, this._sipSessionId);
        }
        if (this.m_appDesc == null) {
            this.m_appDesc = this.getInternalTuWrapper().getSipServletDesc().getSipApp();
        }
        if (this.m_sessionCallID == null) {
            this.m_sessionCallID = this.getInternalTuWrapper().getInternalCallId();
        }
        if (null != this.m_appDesc) {
            if (activation) {
                EventsDispatcher.SipSessionActivated(this, this.m_appDesc);
                this.updatePerformanceAboutNewSession();
            } else {
                EventsDispatcher.SipSessionWillPassivate(this, this.m_appDesc);
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("Unable to send Session Activate notification, ");
            buff.append("SIP app descriptor not available");
            buff.append("sessionId = ");
            buff.append(this.getId());
            c_logger.traceDebug(this, "sendSessionActivateNotification", buff.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHandler(String name) throws ServletException {
        if (!this.isValid() && this.belongToJSR289Application()) {
            throw new IllegalStateException("Can not setInvalidateWhenReady on invalid session");
        }
        Object object = this.getInternalTuWrapper().getSynchronizer();
        synchronized (object) {
            this.getInternalTuWrapper().setHandler(name);
        }
    }

    public void setLastAccessedTime() {
        this.m_lastAccessedTime = System.currentTimeMillis();
        this._isDirty = true;
    }

    public void setAppLastAccessedTime() {
        SipApplicationSessionImpl sipApp = this.getInternalTuWrapper().getAppSessionForInternalUse();
        if (sipApp != null) {
            sipApp.setLastAccessedTime();
        }
    }

    @Override
    public void store() {
        SessionRepository.getInstance().put(this);
    }

    public void setTransactionUser(TransactionUserWrapper transactionUser) {
        this._transactionUser = transactionUser;
    }

    @Override
    public String getId() {
        return this.getSharedId();
    }

    @Override
    public void removeFromStorage() {
        SessionRepository.getInstance().removeSipSession(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAttributes() {
        if (this.m_attributes != null && !this.m_attributes.isEmpty()) {
            HashSet<String> hashSet = this.m_attributes;
            synchronized (hashSet) {
                for (String attrName : this.m_attributes) {
                    SessionRepository.getInstance().removeAttribute(this, attrName);
                }
                this.m_attributes.clear();
            }
        }
    }

    public void notifyOnActivation() {
        this.notifyOnActivationOrPassivation(true);
    }

    public String getApplicationSessionId() {
        return this.getInternalTuWrapper().getApplicationId();
    }

    @Override
    public SipSession getRelatedSipSession() {
        return this.getInternalTuWrapper().getRelatedSipSession();
    }

    @Override
    public boolean isValid() {
        return this.getInternalTuWrapper().isValid();
    }

    @Override
    public SipApplicationRoutingRegion getRegion() {
        return this.getInternalTuWrapper().getRegion();
    }

    @Override
    public void setOutboundInterface(InetSocketAddress address) throws NullPointerException, IllegalStateException, IllegalArgumentException {
        if (address == null) {
            throw new NullPointerException();
        }
        this.checkIsSessionValid();
        if (SipProxyInfo.getInstance().getIndexOfIface(address, "udp") < 0 && SipProxyInfo.getInstance().getIndexOfIface(address, "tcp") < 0 && SipProxyInfo.getInstance().getIndexOfIface(address, "tls") < 0) {
            throw new IllegalArgumentException("address:" + address + " is not an allowed outbound interface.");
        }
        this.getInternalTuWrapper().setOutboundInterface(address);
    }

    @Override
    public void setOutboundInterface(InetAddress address) throws IllegalStateException, IllegalArgumentException, NullPointerException {
        if (address == null) {
            throw new NullPointerException();
        }
        this.checkIsSessionValid();
        if (SipProxyInfo.getInstance().getIndexOfIface(address, "udp") < 0 && SipProxyInfo.getInstance().getIndexOfIface(address, "tcp") < 0 && SipProxyInfo.getInstance().getIndexOfIface(address, "tls") < 0) {
            throw new IllegalArgumentException("address:" + address + " is not an allowed outbound interface.");
        }
        this.getInternalTuWrapper().setOutboundInterface(address);
    }

    public List<SipServletMessage> getPendingMessages(UAMode mode) {
        return this.getInternalTuWrapper().getPendingMessages(mode);
    }

    public void linkSipSession(SipSessionImplementation session) throws IllegalStateException {
        if (this.getInternalTuWrapper().isProxying()) {
            throw new IllegalStateException("the application has already retrieved a proxy");
        }
        this._b2bLinkedSession = session;
        this._b2bLinkedSessionId = session.getId();
        this.getInternalTuWrapper().setB2buaMode();
    }

    public void linkSipSessionAfterFailover(SipSessionImplementation session) {
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("Current session = ");
            buff.append(this.getId());
            buff.append(" Link session = ");
            buff.append(session.getId());
            c_logger.traceDebug(this, "linkSipSessionAfterFailover", buff.toString());
        }
        this._b2bLinkedSession = session;
        this._b2bLinkedSessionId = session.getId();
    }

    public void unlinkSipSession() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(SipSessionImplementation.class.getName(), "unlinkSipSession");
        }
        this._b2bLinkedSession = null;
        this._b2bLinkedSessionId = null;
    }

    public SipSessionImplementation getLinkedSession() {
        return this._b2bLinkedSession;
    }

    public boolean isFailedResponseSent() {
        return this.getInternalTuWrapper().isFailedResponseSent();
    }

    public boolean isTerminated() {
        return this.getInternalTuWrapper().isTerminated();
    }

    @Override
    public SipSession.State getState() {
        if (!this.isValid()) {
            throw new IllegalStateException("Can not return state of invalid session");
        }
        return this.getInternalTuWrapper().getState();
    }

    @Override
    public URI getSubscriberURI() {
        return this.getInternalTuWrapper().getSubscriberUri();
    }

    public boolean isDoingInvalidation() {
        return this._isDuringInvalidation;
    }

    @Override
    public boolean getInvalidateWhenReady() throws IllegalStateException {
        if (!this.isValid()) {
            throw new IllegalStateException("Can not be called on invalidated SipSession");
        }
        return this.m_invalidateWhenReady;
    }

    @Override
    public ServletContext getServletContext() {
        if (this.m_appDesc != null) {
            return this.m_appDesc.getContextEstablisher().getServletContext();
        }
        return null;
    }

    @Override
    public boolean isReadyToInvalidate() throws IllegalStateException {
        if (!this.isValid()) {
            throw new IllegalStateException("The method is called on invalid session");
        }
        return this.getInternalTuWrapper().isReadyToInvalidate();
    }

    public void readyToInvalidate() {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this.getId(), this.isValid()};
            c_logger.traceEntry((Object)this, " readyToInvalidate", params);
        }
        SipApplicationSessionImpl appSession = null;
        if (this.isValid()) {
            if (this.getInvalidateWhenReady()) {
                this.sendSessionReadyToInvalidateEvt();
                if (this.getInvalidateWhenReady()) {
                    appSession = (SipApplicationSessionImpl)this.getApplicationSession();
                    try {
                        this.invalidate();
                    }
                    catch (IllegalStateException e2) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "readyToInvalidate", "SipApplication session was already invalidated");
                        }
                    }
                } else if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "readyToInvalidate", "getInvalidateWhenReady() is false - invalidate later");
                }
                if (appSession == null) {
                    appSession = (SipApplicationSessionImpl)this.getApplicationSession();
                }
                if (appSession != null && appSession.getInvalidateWhenReady() && appSession.isReadyToInvalidate()) {
                    appSession.readyToInvalidate();
                }
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "readyToInvalidate", "Session has already been invalidated. Just ignore.");
        }
    }

    private void sendSessionReadyToInvalidateEvt() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntryExit((Object)this, "sendSessionReadyToInvalidateEvt", this.getId());
        }
        if (this.m_appDesc != null) {
            Collection<SipSessionListener> listeners = this.m_appDesc.getSessionListeners();
            if (!listeners.isEmpty()) {
                SipSessionEvent evt = new SipSessionEvent(this);
                this.sendEvent(listeners, evt, LstNotificationType.SESSION_READY_TO_INVALIDATE);
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "sendSessionNotification", "Unable to send notification, SIP app Descriptor not available");
        }
    }

    @Override
    public void setInvalidateWhenReady(boolean invalidateWhenReady) throws IllegalStateException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this.getId(), invalidateWhenReady};
            c_logger.traceEntry((Object)this, " setInvalidateWhenReady", params);
        }
        if (!this.isValid()) {
            throw new IllegalStateException("Can not setInvalidateWhenReady on invalid session");
        }
        this.m_invalidateWhenReady = invalidateWhenReady;
    }

    public TransactionUserWrapper getInternalTuWrapper() {
        return this._transactionUser;
    }

    public boolean isContainsAttr(String key) {
        return this.m_attributes.contains(key);
    }
}

