/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.jpa.management.AbstractJPAComponent;
import com.ibm.ws.jpa.management.JPAEMPool;
import com.ibm.ws.jpa.management.JPATxEntityManager;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.transaction.Synchronization;

public class JPAPooledEntityManager
extends JPATxEntityManager
implements Synchronization {
    private static final long serialVersionUID = -8964944545640945682L;
    private static final TraceComponent tc = Tr.register(JPAPooledEntityManager.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private final EntityManager ivEm;
    private boolean ivEnlisted = false;

    JPAPooledEntityManager(JPAEMPool pool, EntityManager em, AbstractJPAComponent jpaComponent, boolean txIsUnsynchronized) {
        super(pool, jpaComponent, txIsUnsynchronized);
        this.ivEm = em;
    }

    @Override
    EntityManager getEMInvocationInfo(boolean requireTx, LockModeType mode) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEMInvocationInfo : " + requireTx + " : " + (mode == null ? "null" : mode)), (Object[])new Object[0]);
        }
        if (requireTx || mode != null && !LockModeType.NONE.equals((Object)mode)) {
            throw new UnsupportedOperationException("This entity manager cannot perform operations that require a transactional context");
        }
        if (!this.ivEnlisted) {
            UOWCoordinator uowCoord = this.ivAbstractJPAComponent.getUOWCurrent().getUOWCoord();
            if (uowCoord.isGlobal()) {
                this.registerEmInvocation(uowCoord, this);
            } else {
                LocalTransactionCoordinator ltCoord = (LocalTransactionCoordinator)uowCoord;
                ltCoord.enlistSynchronization((Synchronization)this);
            }
            this.ivEnlisted = true;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEMInvocationInfo : " + this.ivEm));
        }
        return this.ivEm;
    }

    @Override
    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.close();\n" + this.toString()), (Object[])new Object[0]);
        }
        if (!this.ivEnlisted) {
            this.closeTxEntityManager(this.ivEm, true);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writeObject : " + this), (Object[])new Object[0]);
        }
        throw new NotSerializableException("This entity manager is not serializable");
    }

    public void afterCompletion(int status) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("afterCompletion : " + status + " : " + this), (Object[])new Object[0]);
        }
        this.closeTxEntityManager(this.ivEm, true);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"afterCompletion");
        }
    }

    public void beforeCompletion() {
    }
}

