/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins.jose4j;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.utils.JwtData;
import com.ibm.ws.security.jwt.utils.JwtDataConfig;
import com.ibm.ws.security.oauth20.plugins.jose4j.JWTTokenException;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import java.security.Key;
import java.security.KeyStoreException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JWTData {
    private static TraceComponent tc = Tr.register(JWTData.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    public static final String TYPE_ID_TOKEN = "ID Token";
    public static final String TYPE_JWT_TOKEN = "Json Web Token";
    boolean bIdToken = false;
    boolean bJwtToken = false;
    private Key _signingKey = null;
    private String _keyId = null;
    OidcServerConfig oidcServerConfig = null;
    String tokenType = "ID Token";
    String typHeader = null;
    String signatureAlgorithm = null;
    JWTTokenException noKeyException = null;
    JwtData wrappedJwtData;
    static final long serialVersionUID = -8718669547279188880L;

    /*
     * WARNING - void declaration
     */
    public JWTData(@Sensitive String sharedKey, OidcServerConfig oidcServerConfig, String tokenType) {
        this.oidcServerConfig = oidcServerConfig;
        this.tokenType = tokenType;
        this.signatureAlgorithm = oidcServerConfig.getSignatureAlgorithm();
        this.bIdToken = TYPE_ID_TOKEN.equals(tokenType);
        this.bJwtToken = TYPE_JWT_TOKEN.equals(tokenType);
        try {
            JwtDataConfig config = new JwtDataConfig(this.signatureAlgorithm, oidcServerConfig.getJSONWebKey(), sharedKey, null, oidcServerConfig.getKeyAliasName(), oidcServerConfig.getKeyStoreRef(), tokenType, oidcServerConfig.isJwkEnabled());
            this.wrappedJwtData = new JwtData(config);
            this._signingKey = this.wrappedJwtData.getSigningKey();
            this._keyId = this.wrappedJwtData.getKeyID();
        }
        catch (Exception config) {
            void e;
            Object[] objectArray = new Object[3];
            objectArray[0] = "<sensitive java.lang.String>";
            objectArray[1] = oidcServerConfig;
            objectArray[2] = tokenType;
            FFDCFilter.processException((Throwable)config, (String)"com.ibm.ws.security.oauth20.plugins.jose4j.JWTData", (String)"58", (Object)this, (Object[])objectArray);
            this.recordException((Exception)e);
        }
    }

    private void recordException(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Exception obtaining the signing key: " + e), (Object[])new Object[0]);
        }
        String extraMsg = "";
        if (e instanceof KeyStoreException) {
            extraMsg = " " + Tr.formatMessage((TraceComponent)tc, (String)"CHECK_KEYSTORE_REF", (Object[])new Object[0]);
        }
        Object[] objs = new Object[]{this.signatureAlgorithm, e.getLocalizedMessage() + extraMsg};
        this.noKeyException = JWTTokenException.newInstance(false, "JWT_BAD_SIGNING_KEY", objs);
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Sensitive
    public JWTData(Key key, String id) {
        this._signingKey = key;
        this._keyId = id;
    }

    @Sensitive
    public Key getSigningKey() {
        return this._signingKey;
    }

    public String getKeyID() {
        return this._keyId;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getTypHeader() {
        return this.typHeader;
    }

    public void setTypHeader(String typ) {
        this.typHeader = typ;
    }

    public JWTTokenException getNoKeyException() {
        if (this.noKeyException != null) {
            return this.noKeyException;
        }
        return new JWTTokenException("No signing key found");
    }

    public boolean isJwt() {
        return this.bJwtToken;
    }
}

