/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra;

import io.narayana.lra.ResponseHolder;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.FutureRequestExecutionService;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.HttpRequestFutureTask;
import org.apache.http.protocol.HttpContext;

public class LRAHttpClient {
    public static final long PARTICIPANT_TIMEOUT = 2L;
    private static LRAHttpClient client = new LRAHttpClient();
    private FutureRequestExecutionService futureRequestExecutionService;

    private LRAHttpClient() {
        CloseableHttpClient httpClient = HttpClientBuilder.create().setMaxConnPerRoute(5).build();
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        this.futureRequestExecutionService = new FutureRequestExecutionService((HttpClient)httpClient, executorService);
    }

    public static LRAHttpClient getClient() {
        return client;
    }

    ResponseHolder request(HttpRequestBase httpMethod, long timelimit, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        HttpRequestFutureTask<ResponseHolder> futureTask = this.submitFutureTask(httpMethod);
        return (ResponseHolder)futureTask.get(timelimit, unit);
    }

    public ResponseHolder request(HttpRequestBase httpMethod) throws IOException {
        return this.submitTask(httpMethod);
    }

    private ResponseHolder submitTask(HttpRequestBase httpMethod) throws IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpMethod);
        return new ResponseHolder(httpMethod, (HttpResponse)httpResponse);
    }

    private HttpRequestFutureTask<ResponseHolder> submitFutureTask(HttpRequestBase httpMethod) {
        ResponseHandler responseHandler = httpResponse -> new ResponseHolder(httpMethod, httpResponse);
        return this.futureRequestExecutionService.execute((HttpUriRequest)httpMethod, (HttpContext)HttpClientContext.create(), responseHandler);
    }
}

