/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.signature;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.wss4j.policy.SP11Constants;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.model.AbstractBinding;
import org.apache.wss4j.policy.model.AlgorithmSuite;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SignatureAlgorithms {
    private static final TraceComponent tc = Tr.register(SignatureAlgorithms.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    static final String rsa_sha1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    static final String rsa_sha256 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    static final String rsa_sha384 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
    static final String rsa_sha512 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    static final String hmac_sha1 = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    static final String hmac_sha256 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
    static final String hmac_sha384 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
    static final String hmac_sha512 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
    static Map<String, String> RSA_MAP = new HashMap<String, String>();
    static boolean fipsEnabled = CryptoUtils.isFips140_3EnabledWithBetaGuard();
    static Map<String, String> HMAC_MAP;
    static final long serialVersionUID = -8033353690250098686L;

    public static void setAlgorithm(SoapMessage message, String method) {
        if (message == null || method == null || method.isEmpty()) {
            return;
        }
        String algorithm = method.toLowerCase();
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        AlgorithmSuite algorithmSuite = SignatureAlgorithms.getAlgorithmSuite(aim);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"AlgorithmSuite ", (Object[])new Object[]{algorithmSuite, method});
        }
        if (algorithmSuite != null) {
            if (RSA_MAP.containsKey(algorithm)) {
                algorithmSuite.getAlgorithmSuiteType().setAsymmetricSignature(RSA_MAP.get(algorithm));
            }
            if (HMAC_MAP.containsKey(algorithm)) {
                algorithmSuite.getAlgorithmSuiteType().setSymmetricSignature(HMAC_MAP.get(algorithm));
            }
        }
    }

    public static AbstractBinding getAbstractBinding(AssertionInfoMap aim, String binding) {
        Collection<AssertionInfo> ais = null;
        AbstractBinding absBinding = null;
        if ("transport".equals(binding)) {
            ais = SignatureAlgorithms.getMatchingAssertionInfo(aim, SP12Constants.TRANSPORT_BINDING);
            if (ais == null) {
                ais = SignatureAlgorithms.getMatchingAssertionInfo(aim, SP11Constants.TRANSPORT_BINDING);
            }
        } else if ("asymmetric".equals(binding)) {
            ais = SignatureAlgorithms.getMatchingAssertionInfo(aim, SP12Constants.ASYMMETRIC_BINDING);
            if (ais == null) {
                ais = SignatureAlgorithms.getMatchingAssertionInfo(aim, SP11Constants.ASYMMETRIC_BINDING);
            }
        } else if ("symmetric".equals(binding) && (ais = SignatureAlgorithms.getMatchingAssertionInfo(aim, SP12Constants.SYMMETRIC_BINDING)) == null) {
            ais = SignatureAlgorithms.getMatchingAssertionInfo(aim, SP11Constants.SYMMETRIC_BINDING);
        }
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                absBinding = (AbstractBinding)ai.getAssertion();
            }
        }
        return absBinding;
    }

    public static Collection<AssertionInfo> getMatchingAssertionInfo(AssertionInfoMap aim, QName qname) {
        return (Collection)aim.get((Object)qname);
    }

    public static AlgorithmSuite getAlgorithmSuite(AssertionInfoMap aim) {
        AbstractBinding binding = null;
        binding = SignatureAlgorithms.getAbstractBinding(aim, "transport");
        if (binding == null && (binding = SignatureAlgorithms.getAbstractBinding(aim, "asymmetric")) == null) {
            binding = SignatureAlgorithms.getAbstractBinding(aim, "symmetric");
        }
        if (binding != null) {
            return binding.getAlgorithmSuite();
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        if (!fipsEnabled) {
            RSA_MAP.put("SHA1".toLowerCase(), rsa_sha1);
        }
        RSA_MAP.put("SHA256".toLowerCase(), rsa_sha256);
        RSA_MAP.put("SHA384".toLowerCase(), rsa_sha384);
        RSA_MAP.put("SHA512".toLowerCase(), rsa_sha512);
        HMAC_MAP = new HashMap<String, String>();
        if (!fipsEnabled) {
            HMAC_MAP.put("SHA1".toLowerCase(), hmac_sha1);
        }
        HMAC_MAP.put("SHA256".toLowerCase(), hmac_sha256);
        HMAC_MAP.put("SHA384".toLowerCase(), hmac_sha384);
        HMAC_MAP.put("SHA512".toLowerCase(), hmac_sha512);
    }
}

