/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.inputsource;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.webcontainer.util.DocumentRootUtils;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class JspInputSourceContainerImpl
implements JspInputSource {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.inputsource.JspInputSourceImpl";
    protected Container container;
    protected Entry inputSourceEntry;
    protected URL contextURL;
    protected URL absoluteURL;
    protected String relativeURL;
    protected URLStreamHandler urlStreamHandler;
    protected long lastModified;
    protected Document document;
    protected DocumentRootUtils dru;
    static final long serialVersionUID = 5304023444082793866L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspInputSourceContainerImpl(Container container, String relativeURL, URLStreamHandler urlStreamHandler, DocumentRootUtils dru) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "<init>", new Object[]{container, relativeURL, urlStreamHandler, dru});
        }
        this.container = null;
        this.inputSourceEntry = null;
        this.contextURL = null;
        this.absoluteURL = null;
        this.relativeURL = null;
        this.urlStreamHandler = null;
        this.lastModified = 0L;
        this.document = null;
        this.dru = null;
        this.container = container;
        this.relativeURL = relativeURL;
        this.urlStreamHandler = urlStreamHandler;
        this.inputSourceEntry = container.getEntry(relativeURL);
        this.dru = dru;
        if (this.inputSourceEntry != null) {
            this.lastModified = this.inputSourceEntry.getLastModified();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public URL getAbsoluteURL() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getAbsoluteURL", new Object[0]);
        }
        URL uRL = this.absoluteURL;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            uRL = uRL;
            logger.exiting("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getAbsoluteURL", uRL);
        }
        return uRL;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public URL getContextURL() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getContextURL", new Object[0]);
        }
        URL uRL = this.contextURL;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            uRL = uRL;
            logger.exiting("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getContextURL", uRL);
        }
        return uRL;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Document getDocument() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getDocument", new Object[0]);
        }
        Document document = this.document;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            document = document;
            logger.exiting("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getDocument", document);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public InputStream getInputStream() throws IOException {
        block12: {
            InputStream inputStream;
            block13: {
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    logger.entering("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getInputStream", new Object[0]);
                }
                if (this.inputSourceEntry != null) {
                    InputStream inputStream2;
                    block11: {
                        this.lastModified = this.inputSourceEntry.getLastModified();
                        try {
                            inputStream2 = (InputStream)this.inputSourceEntry.adapt(InputStream.class);
                            if (logger == null || !logger.isLoggable(Level.FINER)) break block11;
                        }
                        catch (UnableToAdaptException ex) {
                            throw new IllegalStateException(ex);
                        }
                        inputStream2 = inputStream2;
                        logger.exiting("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getInputStream", inputStream2);
                    }
                    return inputStream2;
                }
                try {
                    if (this.dru == null) break block12;
                    DocumentRootUtils documentRootUtils = this.dru;
                    synchronized (documentRootUtils) {
                        this.dru.handleDocumentRoots(this.relativeURL);
                        InputStream is = this.dru.getInputStream();
                        this.lastModified = this.dru.getLastModified();
                        inputStream = is;
                        if (logger == null || !logger.isLoggable(Level.FINER)) break block13;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    break block12;
                }
                catch (IOException iOException) {
                    // empty catch block
                    break block12;
                }
                inputStream = inputStream;
                logger.exiting("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getInputStream", inputStream);
            }
            return inputStream;
        }
        InputStream inputStream = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            inputStream = inputStream;
            logger.exiting("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getInputStream", inputStream);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getLastModified() {
        block13: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getLastModified", new Object[0]);
            }
            if (this.inputSourceEntry == null && this.dru != null) {
                try {
                    DocumentRootUtils documentRootUtils = this.dru;
                    synchronized (documentRootUtils) {
                        this.dru.handleDocumentRoots(this.relativeURL);
                        this.lastModified = this.dru.getLastModified();
                        break block13;
                    }
                }
                catch (FileNotFoundException e) {
                    long l = 0L;
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        l = l;
                        logger.exiting("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getLastModified", l);
                    }
                    return l;
                }
                catch (IOException e) {
                    long l = 0L;
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        l = l;
                        logger.exiting("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getLastModified", l);
                    }
                    return l;
                }
            }
            if (this.inputSourceEntry != null) {
                long l = this.inputSourceEntry.getLastModified();
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    l = l;
                    logger.exiting("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getLastModified", l);
                }
                return l;
            }
        }
        long l = this.lastModified;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getLastModified", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getRelativeURL() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getRelativeURL", new Object[0]);
        }
        String string = this.relativeURL;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getRelativeURL", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isXmlDocument() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "isXmlDocument", new Object[0]);
        }
        boolean bl = this.document != null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "isXmlDocument", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Container getContainer() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getContainer", new Object[0]);
        }
        Container container = this.container;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            container = container;
            logger.exiting("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getContainer", container);
        }
        return container;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Entry getInputSourceEntry() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getInputSourceEntry", new Object[0]);
        }
        Entry entry = this.inputSourceEntry;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            entry = entry;
            logger.exiting("com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl", "getInputSourceEntry", entry);
        }
        return entry;
    }
}

