/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.nio.client.AbstractClientExchangeHandler;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.protocol.Pipelined;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@Pipelined
class PipeliningClientExchangeHandlerImpl<T>
extends AbstractClientExchangeHandler {
    private final HttpHost target;
    private final Queue<HttpAsyncRequestProducer> requestProducerQueue;
    private final Queue<HttpAsyncResponseConsumer<T>> responseConsumerQueue;
    private final Queue<HttpRequest> requestQueue;
    private final Queue<T> resultQueue;
    private final HttpClientContext localContext;
    private final BasicFuture<List<T>> resultFuture;
    private final HttpProcessor httpProcessor;
    private final AtomicReference<HttpAsyncRequestProducer> requestProducerRef;
    private final AtomicReference<HttpAsyncResponseConsumer<T>> responseConsumerRef;

    public PipeliningClientExchangeHandlerImpl(Log log, HttpHost target, List<? extends HttpAsyncRequestProducer> requestProducers, List<? extends HttpAsyncResponseConsumer<T>> responseConsumers, HttpClientContext localContext, BasicFuture<List<T>> resultFuture, NHttpClientConnectionManager connmgr, HttpProcessor httpProcessor, ConnectionReuseStrategy connReuseStrategy, ConnectionKeepAliveStrategy keepaliveStrategy) {
        super(log, localContext, connmgr, connReuseStrategy, keepaliveStrategy);
        Args.notNull((Object)target, (String)"HTTP target");
        Args.notEmpty(requestProducers, (String)"Request producer list");
        Args.notEmpty(responseConsumers, (String)"Response consumer list");
        Args.check((requestProducers.size() == responseConsumers.size() ? 1 : 0) != 0, (String)"Number of request producers does not match that of response consumers");
        this.target = target;
        this.requestProducerQueue = new ConcurrentLinkedQueue<HttpAsyncRequestProducer>(requestProducers);
        this.responseConsumerQueue = new ConcurrentLinkedQueue<HttpAsyncResponseConsumer<T>>(responseConsumers);
        this.requestQueue = new ConcurrentLinkedQueue();
        this.resultQueue = new ConcurrentLinkedQueue();
        this.localContext = localContext;
        this.resultFuture = resultFuture;
        this.httpProcessor = httpProcessor;
        this.requestProducerRef = new AtomicReference<Object>(null);
        this.responseConsumerRef = new AtomicReference<Object>(null);
    }

    private void closeProducer(HttpAsyncRequestProducer requestProducer) {
        if (requestProducer != null) {
            try {
                requestProducer.close();
            }
            catch (IOException ex) {
                this.log.debug((Object)"I/O error closing request producer", (Throwable)ex);
            }
        }
    }

    private void closeConsumer(HttpAsyncResponseConsumer<?> responseConsumer) {
        if (responseConsumer != null) {
            try {
                responseConsumer.close();
            }
            catch (IOException ex) {
                this.log.debug((Object)"I/O error closing response consumer", (Throwable)ex);
            }
        }
    }

    void releaseResources() {
        this.closeProducer((HttpAsyncRequestProducer)this.requestProducerRef.getAndSet(null));
        this.closeConsumer((HttpAsyncResponseConsumer)this.responseConsumerRef.getAndSet(null));
        while (!this.requestProducerQueue.isEmpty()) {
            this.closeProducer((HttpAsyncRequestProducer)this.requestProducerQueue.remove());
        }
        while (!this.responseConsumerQueue.isEmpty()) {
            this.closeConsumer((HttpAsyncResponseConsumer)this.responseConsumerQueue.remove());
        }
        this.requestQueue.clear();
        this.resultQueue.clear();
    }

    void executionFailed(Exception ex) {
        HttpAsyncResponseConsumer responseConsumer;
        HttpAsyncRequestProducer requestProducer = (HttpAsyncRequestProducer)this.requestProducerRef.get();
        if (requestProducer != null) {
            requestProducer.failed(ex);
        }
        if ((responseConsumer = (HttpAsyncResponseConsumer)this.responseConsumerRef.get()) != null) {
            responseConsumer.failed(ex);
        }
        for (HttpAsyncResponseConsumer cancellable : this.responseConsumerQueue) {
            cancellable.cancel();
        }
    }

    boolean executionCancelled() {
        HttpAsyncResponseConsumer responseConsumer = (HttpAsyncResponseConsumer)this.responseConsumerRef.get();
        boolean cancelled = responseConsumer != null && responseConsumer.cancel();
        this.resultFuture.cancel();
        return cancelled;
    }

    public void start() throws HttpException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] start execution"));
        }
        HttpRoute route = new HttpRoute(this.target);
        this.setRoute(route);
        this.localContext.setAttribute("http.target_host", (Object)this.target);
        this.localContext.setAttribute("http.route", (Object)route);
        this.requestConnection();
    }

    public HttpRequest generateRequest() throws IOException, HttpException {
        this.verifytRoute();
        if (!this.isRouteEstablished()) {
            this.onRouteToTarget();
            this.onRouteComplete();
        }
        NHttpClientConnection localConn = this.getConnection();
        this.localContext.setAttribute("http.connection", (Object)localConn);
        Asserts.check((this.requestProducerRef.get() == null ? 1 : 0) != 0, (String)"Inconsistent state: currentRequest producer is not null");
        HttpAsyncRequestProducer requestProducer = (HttpAsyncRequestProducer)this.requestProducerQueue.poll();
        if (requestProducer == null) {
            return null;
        }
        this.requestProducerRef.set(requestProducer);
        HttpRequest original = requestProducer.generateRequest();
        HttpRequestWrapper currentRequest = HttpRequestWrapper.wrap((HttpRequest)original);
        RequestConfig config = this.localContext.getRequestConfig();
        if (config.getSocketTimeout() > 0) {
            localConn.setSocketTimeout(config.getSocketTimeout());
        }
        this.httpProcessor.process((HttpRequest)currentRequest, (HttpContext)this.localContext);
        this.requestQueue.add(currentRequest);
        this.setCurrentRequest(currentRequest);
        return currentRequest;
    }

    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        HttpAsyncRequestProducer requestProducer;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] produce content"));
        }
        Asserts.check(((requestProducer = (HttpAsyncRequestProducer)this.requestProducerRef.get()) != null ? 1 : 0) != 0, (String)"Inconsistent state: request producer is null");
        requestProducer.produceContent(encoder, ioctrl);
        if (encoder.isCompleted()) {
            requestProducer.resetRequest();
        }
    }

    public void requestCompleted() {
        HttpAsyncRequestProducer requestProducer;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] Request completed"));
        }
        Asserts.check(((requestProducer = (HttpAsyncRequestProducer)this.requestProducerRef.getAndSet(null)) != null ? 1 : 0) != 0, (String)"Inconsistent state: request producer is null");
        requestProducer.requestCompleted((HttpContext)this.localContext);
        try {
            requestProducer.close();
        }
        catch (IOException ioex) {
            this.log.debug((Object)ioex.getMessage(), (Throwable)ioex);
        }
    }

    public void responseReceived(HttpResponse response) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] Response received " + response.getStatusLine()));
        }
        Asserts.check((this.responseConsumerRef.get() == null ? 1 : 0) != 0, (String)"Inconsistent state: response consumer is not null");
        HttpAsyncResponseConsumer responseConsumer = (HttpAsyncResponseConsumer)this.responseConsumerQueue.poll();
        Asserts.check((responseConsumer != null ? 1 : 0) != 0, (String)"Inconsistent state: response consumer queue is empty");
        this.responseConsumerRef.set(responseConsumer);
        HttpRequest request = (HttpRequest)this.requestQueue.poll();
        Asserts.check((request != null ? 1 : 0) != 0, (String)"Inconsistent state: request queue is empty");
        this.localContext.setAttribute("http.request", (Object)request);
        this.localContext.setAttribute("http.response", (Object)response);
        this.httpProcessor.process(response, (HttpContext)this.localContext);
        responseConsumer.responseReceived(response);
        this.setCurrentResponse(response);
    }

    public void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        HttpAsyncResponseConsumer responseConsumer;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] Consume content"));
        }
        Asserts.check(((responseConsumer = (HttpAsyncResponseConsumer)this.responseConsumerRef.get()) != null ? 1 : 0) != 0, (String)"Inconsistent state: response consumer is null");
        responseConsumer.consumeContent(decoder, ioctrl);
    }

    public void responseCompleted() throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] Response processed"));
        }
        boolean keepAlive = this.manageConnectionPersistence();
        HttpAsyncResponseConsumer responseConsumer = this.responseConsumerRef.getAndSet(null);
        Asserts.check((responseConsumer != null ? 1 : 0) != 0, (String)"Inconsistent state: response consumer is null");
        try {
            responseConsumer.responseCompleted((HttpContext)this.localContext);
            Object result = responseConsumer.getResult();
            Exception ex = responseConsumer.getException();
            try {
                responseConsumer.close();
            }
            catch (IOException ioex) {
                this.log.debug((Object)ioex.getMessage(), (Throwable)ioex);
            }
            if (result != null) {
                this.resultQueue.add(result);
            } else {
                this.failed(ex);
            }
            if (!this.resultFuture.isDone() && this.responseConsumerQueue.isEmpty()) {
                this.resultFuture.completed(new ArrayList(this.resultQueue));
                this.resultQueue.clear();
            }
            if (this.resultFuture.isDone()) {
                this.close();
            } else if (!keepAlive) {
                this.failed((Exception)new ConnectionClosedException("Connection closed"));
            } else {
                NHttpClientConnection localConn = this.getConnection();
                if (localConn != null) {
                    localConn.requestOutput();
                } else {
                    this.requestConnection();
                }
            }
        }
        catch (RuntimeException ex) {
            this.failed((Exception)ex);
            throw ex;
        }
    }

    public void inputTerminated() {
        this.failed((Exception)new ConnectionClosedException("Connection closed"));
    }

    public void abortConnection() {
        this.discardConnection();
    }
}

