/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.Service;
import com.arjuna.ats.internal.arjuna.recovery.Connection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class Connection
extends Thread {
    private final Socket _server_socket;
    private final Service _service;
    private final Callback _callback;

    public Connection(Socket server_socket, Service service) {
        this(server_socket, service, null);
    }

    public Connection(Socket server_socket, Service service, Callback callback) {
        super("Server.Connection:" + server_socket.getInetAddress().getHostAddress() + ":" + server_socket.getPort());
        this._server_socket = server_socket;
        try {
            this._server_socket.setSoTimeout(0);
        }
        catch (SocketException ex) {
            tsLogger.i18NLogger.warn_recovery_Connection_2();
        }
        this._service = service;
        this._callback = callback;
    }

    @Override
    public void run() {
        try {
            InputStream is = this._server_socket.getInputStream();
            OutputStream os = this._server_socket.getOutputStream();
            this._service.doWork(is, os);
        }
        catch (IOException ioe) {
            tsLogger.i18NLogger.warn_recovery_Connection_1(ioe);
        }
        finally {
            if (this._callback != null) {
                this._callback.run();
            }
        }
    }
}

