/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.RecordList;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.tools.osb.mbean.ActionBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ActionBeanMBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ActionBeanWrapperInterface;
import com.arjuna.ats.arjuna.tools.osb.mbean.LogRecordWrapper;
import com.arjuna.ats.arjuna.tools.osb.mbean.OSEntryBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreItemMBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ParticipantStatus;
import com.arjuna.ats.arjuna.tools.osb.mbean.StateManagerWrapper;
import com.arjuna.ats.arjuna.tools.osb.mbean.UidWrapper;
import com.arjuna.ats.arjuna.tools.osb.util.JMXServer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanException;

@Deprecated
public class ActionBean
extends OSEntryBean
implements ActionBeanMBean {
    private StateManagerWrapper sminfo;
    private Collection<LogRecordWrapper> participants = new ArrayList();
    protected ActionBeanWrapperInterface ra;
    protected List<UidWrapper> recuids = new ArrayList();
    private static final ThreadLocal<String> classname = new ThreadLocal();

    public ActionBean(UidWrapper w) {
        super(w);
        boolean isJTS;
        boolean bl = isJTS = JMXServer.isJTS() && w.getType().contains("ArjunaTransactionImple");
        if (isJTS) {
            try {
                UidWrapper.setRecordWrapperTypeName((String)w.getType());
                Class<?> cl = Class.forName(w.getClassName());
                Constructor<?> constructor = cl.getConstructor(ActionBean.class, UidWrapper.class);
                this.ra = (ActionBeanWrapperInterface)constructor.newInstance(this, w);
                this.ra.activate();
            }
            catch (Exception e) {
                if (tsLogger.logger.isTraceEnabled()) {
                    tsLogger.logger.trace((Object)("Error constructing " + JMXServer.AJT_WRAPPER_TYPE + ": " + e));
                }
                this.ra = this.createWrapper(w, true);
            }
        } else {
            this.ra = this.createWrapper(w, true);
        }
        this.sminfo = new StateManagerWrapper(StoreManager.getRecoveryStore(), this.getUid(), this.getType());
        for (ParticipantStatus lt : ParticipantStatus.values()) {
            this.findParticipants(this.recuids, this.ra.getRecords(lt), lt);
        }
    }

    protected ActionBeanWrapperInterface createWrapper(UidWrapper w, boolean activate) {
        GenericAtomicActionWrapper action = new GenericAtomicActionWrapper(w.getClassName(), w);
        if (activate) {
            action.activate();
        }
        return action;
    }

    public StringBuilder toString(String prefix, StringBuilder sb) {
        this.ra.toString(prefix, sb);
        prefix = prefix + '\t';
        sb.append('\n').append(prefix).append(this.sminfo.getCreationTime());
        sb.append('\n').append(prefix).append(this.sminfo.getAgeInSeconds());
        for (LogRecordWrapper p : this.participants) {
            p.toString(prefix, sb);
        }
        return sb;
    }

    public Uid getUid(AbstractRecord rec) {
        return this.ra.getUid(rec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String remove() throws MBeanException {
        Object w;
        Iterator i = this.participants.iterator();
        int removeCount = 0;
        int participantCount = this.participants.size();
        while (i.hasNext()) {
            w = (LogRecordWrapper)i.next();
            w.remove(false);
            if (w.isRemoved()) {
                ++removeCount;
            }
            i.remove();
        }
        try {
            if (removeCount == participantCount) {
                if (!StoreManager.getRecoveryStore().remove_committed(this.getUid(), this.getType())) {
                    w = "Attempt to remove transaction failed";
                    return w;
                }
                this._uidWrapper.unregister();
            }
            w = "Transaction successfully removed";
            return w;
        }
        catch (ObjectStoreException e) {
            String string = "Unable to remove transaction: " + e.getMessage();
            return string;
        }
        finally {
            this._uidWrapper.probe();
        }
    }

    private void findParticipants(List<UidWrapper> recuids, RecordList list, ParticipantStatus listType) {
        if (list != null) {
            AbstractRecord rec = list.peekFront();
            while (rec != null) {
                LogRecordWrapper lw;
                int i;
                int n = i = recuids == null ? -1 : recuids.indexOf(new UidWrapper(this.ra.getUid(rec)));
                if (i != -1) {
                    OSEntryBean p = recuids.get(i).getMBean();
                    if (p instanceof LogRecordWrapper) {
                        lw = (LogRecordWrapper)p;
                        lw.init(this, rec, listType);
                    } else {
                        if (tsLogger.logger.isTraceEnabled()) {
                            tsLogger.logger.trace((Object)"participant record is not a LogRecordWrapper");
                        }
                        lw = this.createParticipant(rec, listType, recuids.get(i));
                    }
                } else {
                    lw = this.createParticipant(rec, listType);
                }
                lw.activate();
                this.participants.add(lw);
                rec = list.peekNext(rec);
            }
        }
    }

    protected LogRecordWrapper createParticipant(AbstractRecord rec, ParticipantStatus listType) {
        return new LogRecordWrapper(this, rec, listType);
    }

    protected LogRecordWrapper createParticipant(AbstractRecord rec, ParticipantStatus listType, UidWrapper wrapper) {
        return new LogRecordWrapper(this, rec, listType, wrapper);
    }

    public LogRecordWrapper getParticipant(AbstractRecord rec) {
        for (LogRecordWrapper w : this.participants) {
            if (!w.getRecord().equals(rec)) continue;
            return w;
        }
        return null;
    }

    public void register() {
        super.register();
        for (LogRecordWrapper p : this.participants) {
            JMXServer.getAgent().registerMBean(p.getName(), (ObjStoreItemMBean)p);
        }
    }

    public void unregister() {
        for (LogRecordWrapper p : this.participants) {
            JMXServer.getAgent().unregisterMBean(p.getName());
        }
        super.unregister();
    }

    public long getAgeInSeconds() {
        return this.sminfo.getAgeInSeconds();
    }

    public String getCreationTime() {
        return this.sminfo.getCreationTime();
    }

    public boolean isParticipant() {
        return false;
    }

    public boolean setStatus(LogRecordWrapper logrec, ParticipantStatus newStatus) {
        ParticipantStatus lt = logrec.getListType();
        AbstractRecord targRecord = logrec.getRecord();
        RecordList oldList = this.ra.getRecords(lt);
        RecordList newList = this.ra.getRecords(newStatus);
        if (oldList.remove(targRecord) && newList.insert(targRecord)) {
            if (lt.equals((Object)ParticipantStatus.HEURISTIC)) {
                switch (1.$SwitchMap$com$arjuna$ats$arjuna$tools$osb$mbean$ParticipantStatus[newStatus.ordinal()]) {
                    case 1: {
                        this.ra.clearHeuristicDecision(8);
                        break;
                    }
                    case 2: {
                        this.ra.clearHeuristicDecision(9);
                        break;
                    }
                    case 3: {
                        this.ra.clearHeuristicDecision(0);
                        targRecord.clearHeuristicDecision();
                        break;
                    }
                    case 4: {
                        this.ra.clearHeuristicDecision(2);
                        break;
                    }
                }
            }
            this.ra.doUpdateState();
            return true;
        }
        return false;
    }

    public Collection<LogRecordWrapper> getParticipants() {
        return Collections.unmodifiableCollection(this.participants);
    }

    public void remove(LogRecordWrapper logRecordWrapper) {
        this.ra.remove(logRecordWrapper);
    }
}

