/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.sib.admin.mxbean.MessagingSubscription;
import com.ibm.ws.sib.admin.mxbean.QueuedMessage;
import com.ibm.ws.sib.admin.mxbean.QueuedMessageDetail;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.runtime.SIMPLocalSubscriptionControllable;
import com.ibm.ws.sib.processor.runtime.SIMPQueuedMessageControllable;
import java.util.Locale;

public class SIBMBeanResultFactory {
    public static QueuedMessage createSIBQueuedMessage(SIMPQueuedMessageControllable qmc) {
        String id = null;
        int jsApproximateLength = 0;
        String name = null;
        String state = null;
        String transactionId = null;
        String type = null;
        String busSystemMessageId = null;
        id = qmc.getId();
        name = qmc.getName();
        state = null;
        transactionId = null;
        try {
            if (qmc.getState() != null) {
                state = qmc.getState().toString();
            }
            transactionId = qmc.getTransactionId();
        }
        catch (SIMPException sIMPException) {
            // empty catch block
        }
        try {
            JsMessage jsMessage = qmc.getJsMessage();
            jsApproximateLength = jsMessage.getApproximateLength();
            busSystemMessageId = jsMessage.getSystemMessageId();
            type = jsMessage.getJsMessageType().toString();
        }
        catch (SIMPControllableNotFoundException sIMPControllableNotFoundException) {
        }
        catch (SIMPException sIMPException) {
            // empty catch block
        }
        return new QueuedMessage(id, name, jsApproximateLength, state, transactionId, type, busSystemMessageId);
    }

    public static QueuedMessageDetail createSIBQueuedMessageDetail(SIMPQueuedMessageControllable qmc, Locale locale) {
        String type = null;
        boolean fullyValid = true;
        boolean valid = false;
        String busDiscriminator = null;
        Integer busPriority = null;
        String busReliability = null;
        Long busTimeToLive = null;
        String busReplyDiscriminator = null;
        Integer busReplyPriority = null;
        String busReplyReliability = null;
        Long busReplyTimeToLive = null;
        String busSystemMessageId = null;
        Long busExceptionTimestamp = null;
        String busExceptionMessage = null;
        String busExceptionProblemSubscription = null;
        String busExceptionProblemDestination = null;
        String jsMessageType = null;
        int jsApproximateLength = -1;
        Long jsTimestamp = null;
        Long jsMessageWaitTime = null;
        Long jsCurrentMEArrivalTimestamp = null;
        Integer jsRedeliveredCount = null;
        String jsSecurityUserid = null;
        String jsProducerType = null;
        byte[] jsApiMessageIdAsBytes = null;
        byte[] jsCorrelationIdAsBytes = null;
        String apiMessageId = null;
        String apiCorrelationId = null;
        String apiUserid = null;
        String apiFormat = null;
        String jmsDeliveryMode = null;
        Long jmsExpiration = null;
        String jmsDestination = null;
        String jmsReplyTo = null;
        Boolean jmsRedelivered = null;
        String jmsType = null;
        int jmsXDeliveryCount = -1;
        String jmsXAppId = null;
        String id = null;
        String name = null;
        String state = null;
        long timestamp = 0L;
        String transactionId = null;
        JsMessage jsMessage = null;
        try {
            jsMessage = qmc.getJsMessage();
            valid = true;
        }
        catch (SIMPControllableNotFoundException e) {
            fullyValid = false;
        }
        catch (SIMPException e) {
            fullyValid = false;
        }
        id = qmc.getId();
        if ("-1".equals(id)) {
            fullyValid = false;
        }
        name = qmc.getName();
        try {
            if (qmc.getState() != null) {
                state = qmc.getState().toString();
            }
            transactionId = qmc.getTransactionId();
        }
        catch (SIMPException e) {
            fullyValid = false;
        }
        busDiscriminator = jsMessage.getDiscriminator();
        busPriority = jsMessage.getPriority();
        busReliability = jsMessage.getReliability().toString();
        busTimeToLive = jsMessage.getTimeToLive();
        busReplyDiscriminator = jsMessage.getReplyDiscriminator();
        busReplyPriority = jsMessage.getReplyPriority();
        Reliability replyReliability = jsMessage.getReplyReliability();
        if (replyReliability != null) {
            busReplyReliability = replyReliability.toString();
        }
        busReplyTimeToLive = jsMessage.getReplyTimeToLive();
        busSystemMessageId = jsMessage.getSystemMessageId();
        Integer exceptionReason = jsMessage.getExceptionReason();
        if (exceptionReason != null) {
            busExceptionTimestamp = jsMessage.getExceptionTimestamp();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            busExceptionMessage = TraceNLS.getFormattedMessage((String)"com.ibm.websphere.sib.CWSIKMessages", (String)("DELIVERY_ERROR_SIRC_" + exceptionReason), (Locale)locale, (Object[])jsMessage.getExceptionInserts(), (String)"Exception Message");
            busExceptionProblemSubscription = jsMessage.getExceptionProblemSubscription();
            busExceptionProblemDestination = jsMessage.getExceptionProblemDestination();
        }
        jsMessageType = jsMessage.getJsMessageType().toString();
        jsApproximateLength = jsMessage.getApproximateLength();
        jsTimestamp = jsMessage.getTimestamp();
        jsMessageWaitTime = jsMessage.getMessageWaitTime();
        jsCurrentMEArrivalTimestamp = jsMessage.getCurrentMEArrivalTimestamp();
        jsRedeliveredCount = jsMessage.getRedeliveredCount();
        jsSecurityUserid = jsMessage.getSecurityUserid();
        jsProducerType = jsMessage.getProducerType().toString();
        jsApiMessageIdAsBytes = jsMessage.getApiMessageIdAsBytes();
        jsCorrelationIdAsBytes = jsMessage.getCorrelationIdAsBytes();
        if (jsMessage instanceof JsApiMessage) {
            JsApiMessage jsApiMessage = (JsApiMessage)jsMessage;
            apiMessageId = jsApiMessage.getApiMessageId();
            apiCorrelationId = jsApiMessage.getCorrelationId();
            apiUserid = jsApiMessage.getUserid();
            apiFormat = jsApiMessage.getFormat();
        }
        if (jsMessage instanceof JsJmsMessage) {
            JsJmsMessage jsJmsMessage = (JsJmsMessage)jsMessage;
            jmsDeliveryMode = jsJmsMessage.getJmsDeliveryMode().toString();
            jmsExpiration = jsJmsMessage.getJmsExpiration();
            type = "JMS";
            jmsRedelivered = jsJmsMessage.getJmsRedelivered();
            jmsType = jsJmsMessage.getJmsType();
            jmsXDeliveryCount = jsJmsMessage.getJmsxDeliveryCount();
            jmsXAppId = jsJmsMessage.getJmsxAppId();
        }
        return new QueuedMessageDetail(id, name, state, timestamp, transactionId, type, busDiscriminator, busPriority, busReliability, busTimeToLive, busReplyDiscriminator, busReplyPriority, busReplyReliability, busReplyTimeToLive, busSystemMessageId, busExceptionTimestamp, busExceptionMessage, busExceptionProblemSubscription, busExceptionProblemDestination, jsMessageType, jsApproximateLength, jsTimestamp, jsMessageWaitTime, jsCurrentMEArrivalTimestamp, jsRedeliveredCount, jsSecurityUserid, jsProducerType, jsApiMessageIdAsBytes, jsCorrelationIdAsBytes, apiMessageId, apiCorrelationId, apiUserid, apiFormat, jmsDeliveryMode, jmsExpiration, jmsDestination, jmsReplyTo, jmsRedelivered, jmsType, jmsXDeliveryCount, jmsXAppId, fullyValid, valid);
    }

    public static MessagingSubscription createSIBSubscription(SIMPLocalSubscriptionControllable ls) {
        long depth = 0L;
        String id = null;
        int maxMsgs = 0;
        String name = null;
        String selector = null;
        String subscriberId = null;
        String[] topics = null;
        depth = ls.getNumberOfQueuedMessages();
        id = ls.getId();
        name = ls.getName();
        selector = ls.getSelector();
        subscriberId = ls.getSubscriberID();
        topics = ls.getTopics();
        return new MessagingSubscription(depth, id, maxMsgs, name, selector, subscriberId, topics);
    }
}

