/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.websphere.messaging.mbean.QueueMBean;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIDataGraphSchemaNotFoundException;
import com.ibm.websphere.sib.exception.SIMessageException;
import com.ibm.ws.sib.admin.Controllable;
import com.ibm.ws.sib.admin.internal.JsBusImpl;
import com.ibm.ws.sib.admin.internal.JsMessagingEngineImpl;
import com.ibm.ws.sib.admin.internal.SIBMBeanResultFactory;
import com.ibm.ws.sib.admin.mxbean.QueuedMessage;
import com.ibm.ws.sib.admin.mxbean.QueuedMessageDetail;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.JsJmsBytesMessage;
import com.ibm.ws.sib.mfp.JsJmsMapMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsObjectMessage;
import com.ibm.ws.sib.mfp.JsJmsStreamMessage;
import com.ibm.ws.sib.mfp.JsJmsTextMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageType;
import com.ibm.ws.sib.mfp.ObjectFailedToSerializeException;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.runtime.SIMPLocalQueuePointControllable;
import com.ibm.ws.sib.processor.runtime.SIMPQueuedMessageControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteMessageControllable;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;

public class JsQueue
implements QueueMBean,
Controllable {
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.internal.JsQueue";
    private static final TraceComponent tc = SibTr.register(JsQueue.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private static String MBEAN_TYPE = "WEMQueue";
    private String _name = null;
    private SIMPLocalQueuePointControllable _c = null;
    private JsMessagingEngineImpl _me = null;
    Properties props = new Properties();

    public JsQueue(JsMessagingEngineImpl me, Controllable c) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.internal.JsQueue().<init>");
        }
        this._c = (SIMPLocalQueuePointControllable)c;
        this._name = c.getName();
        this._me = me;
        this.props.setProperty(((JsBusImpl)me.getBus()).getMBeanType(), ((JsBusImpl)me.getBus()).getName());
        this.props.setProperty(me.getMBeanType(), me.getName());
        this.props.setProperty("Name", this._c.getName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.internal.JsQueue().<init>");
        }
    }

    public String getUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUuid");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUuid", (Object)this._c.getUuid());
        }
        return this._c.getUuid();
    }

    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)this._name);
        }
        return this._name;
    }

    @Override
    public String getIdentifier() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getIdentifier");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getIdentifier", (Object)this._name);
        }
        return this._name;
    }

    @Override
    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)this._c.getId());
        }
        return this._c.getId();
    }

    @Override
    public String getState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getState", (Object)this._c.getMessageHandler().getState());
        }
        return this._c.getMessageHandler().getState();
    }

    @Override
    public long getDepth() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDepth");
        }
        long depth = this._c.getNumberOfQueuedMessages();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Long l = new Long(depth);
            SibTr.exit((TraceComponent)tc, (String)"getDepth", (Object)l);
        }
        return depth;
    }

    @Override
    public long getMaxQueueDepth() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHighMessageThreshold");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Long l = new Long(this._c.getDestinationHighMsgs());
            SibTr.exit((TraceComponent)tc, (String)"getHighMessageThreshold", (Object)l);
        }
        return this._c.getDestinationHighMsgs();
    }

    @Override
    public boolean isSendAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSendAllowed");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean b = new Boolean(this._c.isSendAllowed());
            SibTr.exit((TraceComponent)tc, (String)"isSendAllowed", (Object)b);
        }
        return this._c.isSendAllowed();
    }

    @Override
    public QueuedMessage[] listQueuedMessages() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"listQueuedMessages");
        }
        ArrayList<SIMPQueuedMessageControllable> list = new ArrayList<SIMPQueuedMessageControllable>();
        Object iter = this._c.getQueuedMessageIterator();
        while (iter != null && iter.hasNext()) {
            SIMPQueuedMessageControllable o = (SIMPQueuedMessageControllable)iter.next();
            list.add(o);
        }
        ArrayList<QueuedMessage> resultList = new ArrayList<QueuedMessage>();
        iter = list.iterator();
        boolean i = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            QueuedMessage qm = SIBMBeanResultFactory.createSIBQueuedMessage((SIMPQueuedMessageControllable)o);
            resultList.add(qm);
        }
        QueuedMessage[] retValue = resultList.toArray(new QueuedMessage[0]);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"listQueuedMessages", (Object)retValue);
        }
        return retValue;
    }

    @Override
    public QueuedMessage getQueuedMessage(String messageId) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuedMessage", (Object)messageId);
        }
        if (messageId == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessage", null);
            }
            return null;
        }
        QueuedMessage retValue = null;
        try {
            QueuedMessage qm;
            SIMPQueuedMessageControllable qmc = this._c.getQueuedMessageByID(messageId);
            retValue = qm = SIBMBeanResultFactory.createSIBQueuedMessage(qmc);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessage", (Object)retValue);
            }
            return retValue;
        }
        catch (SIMPControllableNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Message no longer on queue point", (Object)messageId);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessage", null);
            }
            return null;
        }
        catch (SIMPException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public QueuedMessageDetail getQueuedMessageDetail(String messageId) throws Exception {
        return this.getQueuedMessageDetail(messageId, null);
    }

    public QueuedMessageDetail getQueuedMessageDetail(String messageId, Locale locale) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuedMessageDetail", (Object)new Object[]{messageId, locale});
        }
        if (messageId == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageDetail", null);
            }
            return null;
        }
        QueuedMessageDetail retValue = null;
        try {
            QueuedMessageDetail qmd;
            SIMPQueuedMessageControllable qmc = this._c.getQueuedMessageByID(messageId);
            retValue = qmd = SIBMBeanResultFactory.createSIBQueuedMessageDetail(qmc, locale);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageDetail", (Object)retValue);
            }
            return retValue;
        }
        catch (SIMPControllableNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Message no longer on queue point", (Object)messageId);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageDetail", null);
            }
            return null;
        }
        catch (SIMPException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageDetail", (Object)((Object)e));
            }
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public byte[] getMessageData(String messageId, Integer size) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageData", (Object)new Object[]{messageId, size});
        }
        if (messageId == null || size == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMessageData", null);
            }
            return null;
        }
        byte[] retValue = null;
        SIMPQueuedMessageControllable qmc = null;
        try {
            qmc = this._c.getQueuedMessageByID(messageId);
        }
        catch (SIMPControllableNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Message no longer on queue point", (Object)messageId);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMessageData", null);
            }
            return null;
        }
        catch (SIMPException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            throw new Exception(e.getMessage());
        }
        retValue = this.getMessageData(qmc, size);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageData", (Object)retValue);
        }
        return retValue;
    }

    @Override
    public void deleteQueuedMessage(String messageId, Boolean moveMessage) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteQueuedMessage", (Object)new Object[]{messageId, moveMessage});
        }
        if (messageId == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteQueuedMessage");
            }
            return;
        }
        boolean discard = true;
        if (moveMessage == null || moveMessage.booleanValue()) {
            discard = false;
        }
        try {
            SIMPQueuedMessageControllable qmc = this._c.getQueuedMessageByID(messageId);
            if (qmc != null) {
                qmc.moveMessage(discard);
            }
        }
        catch (SIMPControllableNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Message no longer on queue point", (Object)messageId);
            }
        }
        catch (SIMPRuntimeOperationFailedException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteQueuedMessage", (Object)"SIBRuntimeOperationFailedException");
            }
            throw new Exception(e.getMessage());
        }
        catch (SIMPException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            throw new Exception(e.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteQueuedMessage");
        }
    }

    @Override
    public void deleteAllQueuedMessages(Boolean moveMessage) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteAllQueuedMessages", (Object)new Object[]{moveMessage});
        }
        boolean discard = true;
        if (moveMessage == null || moveMessage.booleanValue()) {
            discard = false;
        }
        try {
            this._c.moveMessages(discard);
        }
        catch (SIMPException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            throw new Exception(e.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteAllQueuedMessages");
        }
    }

    @Override
    public QueuedMessage[] getQueuedMessages(Integer fromIndexInteger, Integer toIndexInteger, Integer totalMessagesPerpageInteger) throws Exception {
        int fromIndex = fromIndexInteger;
        int toIndex = toIndexInteger;
        int totalMessagesPerpage = totalMessagesPerpageInteger;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)("getQueuedMessages  fromIndex=" + fromIndex + " toIndex= " + toIndex + " totalMsgs= " + totalMessagesPerpage));
        }
        ArrayList<SIMPQueuedMessageControllable> list = new ArrayList<SIMPQueuedMessageControllable>();
        Object iter = this._c.getQueuedMessageIterator(fromIndex, toIndex, totalMessagesPerpage);
        while (iter != null && iter.hasNext()) {
            SIMPQueuedMessageControllable o = (SIMPQueuedMessageControllable)iter.next();
            list.add(o);
        }
        ArrayList<QueuedMessage> resultList = new ArrayList<QueuedMessage>();
        iter = list.iterator();
        boolean i = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            QueuedMessage qm = SIBMBeanResultFactory.createSIBQueuedMessage((SIMPQueuedMessageControllable)o);
            resultList.add(qm);
        }
        QueuedMessage[] retValue = resultList.toArray(new QueuedMessage[0]);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)("getQueuedMessagesfromIndex=" + fromIndex + " toIndex= " + toIndex + " totalMsgs= " + totalMessagesPerpage), (Object)retValue);
        }
        return retValue;
    }

    public Properties getProperties() {
        return (Properties)this.props.clone();
    }

    private byte[] getData(byte[] in, Integer size) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getData", (Object)new Object[]{in, size});
        }
        byte[] tmp = null;
        if (in != null) {
            int len = 1024;
            if (size > 0) {
                len = size;
            }
            if (len > in.length) {
                len = in.length;
            }
            tmp = new byte[len];
            System.arraycopy(in, 0, tmp, 0, len);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getData", tmp);
        }
        return tmp;
    }

    public byte[] getMessageData(SIMPQueuedMessageControllable qmc, Integer size) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageData", (Object)size.toString());
        }
        byte[] data = null;
        if (qmc != null) {
            try {
                JsMessage jm = qmc.getJsMessage();
                data = this.getMessageData(jm, size);
            }
            catch (SIMPException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getMessageData", (Object)((Object)e));
                }
                throw new Exception(e.getMessage());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageData");
        }
        return data;
    }

    public byte[] getMessageData(SIMPRemoteMessageControllable rmc, Integer size) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageData", (Object)size.toString());
        }
        byte[] data = null;
        if (rmc != null) {
            try {
                JsMessage jm = rmc.getJsMessage();
                data = this.getMessageData(jm, size);
            }
            catch (SIMPException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getMessageData", (Object)((Object)e));
                }
                throw new Exception(e.getMessage());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageData");
        }
        return data;
    }

    private byte[] getMessageData(JsMessage jm, Integer size) throws IncorrectMessageTypeException, SIDataGraphSchemaNotFoundException, SIMessageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageData", (Object)new Object[]{jm, size});
        }
        byte[] data = null;
        MessageType mt = jm.getJsMessageType();
        if (mt == MessageType.JMS) {
            JsJmsMessage m = jm.makeInboundJmsMessage();
            if (m instanceof JsJmsTextMessage) {
                JsJmsTextMessage msg = (JsJmsTextMessage)m;
                String text = null;
                try {
                    text = msg.getText();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (text != null) {
                    data = this.getData(text.getBytes(), size);
                }
            } else if (m instanceof JsJmsBytesMessage) {
                JsJmsBytesMessage msg = (JsJmsBytesMessage)m;
                data = this.getData(msg.getBytes(), size);
            } else if (m instanceof JsJmsObjectMessage) {
                JsJmsObjectMessage msg = (JsJmsObjectMessage)m;
                try {
                    data = this.getData(msg.getSerializedObject(), size);
                }
                catch (ObjectFailedToSerializeException ofse) {
                    data = null;
                }
            } else if (m instanceof JsJmsMapMessage) {
                JsJmsMapMessage msg = (JsJmsMapMessage)m;
                try {
                    data = this.getData(msg.getUserFriendlyBytes(), size);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else if (m instanceof JsJmsStreamMessage) {
                JsJmsStreamMessage msg = (JsJmsStreamMessage)m;
                try {
                    data = this.getData(msg.getUserFriendlyBytes(), size);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageData", data);
        }
        return data;
    }

    public String getConfigId() {
        return null;
    }

    public String getRemoteEngineUuid() {
        return null;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: com/ibm/ws/sib/admin/internal/JsQueue.java");
        }
    }
}

