/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logstash.collector.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.collector.ClientPool;
import com.ibm.ws.collector.Collector;
import com.ibm.ws.collector.Target;
import com.ibm.ws.collector.TaskManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.logging.collector.CollectorJsonUtils;
import com.ibm.ws.logging.data.AccessLogConfig;
import com.ibm.ws.logstash.collector.LogstashRuntimeVersion;
import com.ibm.ws.logstash.collector.internal.LogstashClientPool;
import com.ibm.ws.lumberjack.LumberjackEvent;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collector.manager.Handler;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.logstash.collector.internal.LogstashCollector", service={Handler.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class LogstashCollector
extends Collector {
    private static final TraceComponent tc = Tr.register(LogstashCollector.class, (String)"logstashCollector", (String)"com.ibm.ws.logstash.collector.internal.resources.LoggingMessages");
    public static final String COMPONENT_NAME = "com.ibm.ws.logstash.collector.internal.LogstashCollector";
    private static final String SERVER_HOST_NAME_KEY = "sourceHostName";
    private static final String SERVER_NAME_KEY = "sourceServerName";
    private static final String SERVER_DEFAULT_HOST_NAME_KEY = "sourceDefaultHostName";
    private static final String VAR_DEFAULTHOSTNAME = "${defaultHostName}";
    private static final String VAR_WLPSERVERNAME = "${wlp.server.name}";
    private static final String VAR_WLPUSERDIR = "${wlp.user.dir}";
    private static final String ENV_VAR_CONTAINERHOST = "${env.CONTAINER_HOST}";
    private static final String ENV_VAR_CONTAINERNAME = "${env.CONTAINER_NAME}";
    private static final int POOL_SIZE = 4;
    private static final String SSL_SUPPORT_SERVICE = "sslSupportService";
    private static final String LOGSTASH_VERSION_SERVICE = "logstashVersionService";
    private static final String VARIABLE_REGISTRY_SERVICE = "variableRegistryService";
    private final AtomicServiceReference<SSLSupport> sslSupportServiceRef = new AtomicServiceReference("sslSupportService");
    private final AtomicServiceReference<LogstashRuntimeVersion> logstashVersionServiceRef = new AtomicServiceReference("logstashVersionService");
    private final AtomicServiceReference<VariableRegistry> variableRegistryServiceRef = new AtomicServiceReference("variableRegistryService");
    protected String serverName = "";
    protected String serverUserDir = "";
    protected String serverHostName = "";
    private TaskManager taskMgr = null;
    private String logstashVersion;
    private String jsonAccessLogFields;
    static final long serialVersionUID = 5244714339882948757L;

    @Reference(name="executorService", service=ExecutorService.class)
    protected void setExecutorService(ServiceReference<ExecutorService> executorService) {
        this.executorServiceRef.setReference(executorService);
    }

    protected void unsetExecutorService(ServiceReference<ExecutorService> executorService) {
        this.executorServiceRef.unsetReference(executorService);
    }

    @Reference(name="sslSupportService", service=SSLSupport.class)
    protected void setSslSupportService(ServiceReference<SSLSupport> sslSupport) {
        this.sslSupportServiceRef.setReference(sslSupport);
    }

    protected void updatedSslSupportService(ServiceReference<SSLSupport> sslSupport) {
        this.sslSupportServiceRef.setReference(sslSupport);
        if (this.taskMgr != null) {
            this.taskMgr.updateConfig();
        }
    }

    protected void unsetSslSupportService(ServiceReference<SSLSupport> sslSupport) {
        this.sslSupportServiceRef.unsetReference(sslSupport);
    }

    @Reference(name="logstashVersionService", service=LogstashRuntimeVersion.class)
    protected void setLogstashVersionService(ServiceReference<LogstashRuntimeVersion> logstashRuntimeVersion) {
        this.logstashVersionServiceRef.setReference(logstashRuntimeVersion);
    }

    protected void unsetLogstashVersionService(ServiceReference<LogstashRuntimeVersion> logstashRuntimeVersion) {
        this.logstashVersionServiceRef.unsetReference(logstashRuntimeVersion);
    }

    @Reference(name="variableRegistryService", service=VariableRegistry.class)
    protected void setVariableRegistryService(ServiceReference<VariableRegistry> variableRegistry) {
        this.variableRegistryServiceRef.setReference(variableRegistry);
    }

    protected void unsetVariableRegistryService(ServiceReference<VariableRegistry> variableRegistry) {
        this.variableRegistryServiceRef.unsetReference(variableRegistry);
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> configuration) {
        super.activate(cc, configuration);
        this.sslSupportServiceRef.activate(cc);
        this.logstashVersionServiceRef.activate(cc);
        this.variableRegistryServiceRef.activate(cc);
        this.setLogstashVersion();
        this.setJsonAccessLogFields(configuration);
        this.setServerInfo(configuration);
        this.setConfigInfo(configuration);
        this.validateSources(configuration);
        if (this.taskMgr != null) {
            this.taskMgr.updateConfig();
            ((ExecutorService)this.executorServiceRef.getService()).submit((Runnable)this.taskMgr);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc, int reason) {
        this.taskMgr.close();
        super.deactivate(cc, reason);
        this.sslSupportServiceRef.deactivate(cc);
        this.logstashVersionServiceRef.deactivate(cc);
        this.variableRegistryServiceRef.deactivate(cc);
    }

    @Modified
    protected void modified(Map<String, Object> configuration) {
        super.modified(configuration);
        this.setServerInfo(configuration);
        this.setConfigInfo(configuration);
        this.validateSources(configuration);
        this.setJsonAccessLogFields(configuration);
        if (this.taskMgr != null) {
            this.taskMgr.updateConfig();
        }
    }

    private void validateSources(Map<String, Object> config) {
        String[] sourceList;
        if (config.containsKey("source") && (sourceList = (String[])config.get("source")) != null) {
            for (String source : sourceList) {
                if (!this.getSourceName(source.trim()).isEmpty()) continue;
                Tr.warning((TraceComponent)tc, (String)"LOGSTASH_SOURCE_UNKNOWN", (Object[])new Object[]{source});
            }
        }
    }

    private void setLogstashVersion() {
        this.logstashVersion = ((LogstashRuntimeVersion)this.logstashVersionServiceRef.getService()).getVersion().toString();
    }

    private void setConfigInfo(Map<String, Object> config) {
        this.taskMgr.setConfigInfo(config);
    }

    private void setJsonAccessLogFields(Map<String, Object> configuration) {
        AccessLogConfig.jsonAccessLogFieldsLogstashConfig = this.jsonAccessLogFields = (String)configuration.get("jsonAccessLogFields");
    }

    private void setServerInfo(Map<String, Object> configuration) {
        String serverName = (String)configuration.get(SERVER_NAME_KEY);
        String serverHostName = (String)configuration.get(SERVER_HOST_NAME_KEY);
        String serverDefaultHostName = (String)configuration.get(SERVER_DEFAULT_HOST_NAME_KEY);
        String serverUserDir = ((VariableRegistry)this.variableRegistryServiceRef.getService()).resolveString(VAR_WLPUSERDIR);
        if (serverName.trim().isEmpty()) {
            serverName = ((VariableRegistry)this.variableRegistryServiceRef.getService()).resolveString(ENV_VAR_CONTAINERNAME);
            if (ENV_VAR_CONTAINERNAME.equals(serverName)) {
                serverName = ((VariableRegistry)this.variableRegistryServiceRef.getService()).resolveString(VAR_WLPSERVERNAME);
            }
            if (VAR_WLPSERVERNAME.equals(serverName)) {
                serverName = "";
            }
        }
        this.serverName = serverName;
        if (VAR_WLPUSERDIR.equals(serverUserDir)) {
            serverUserDir = "";
        }
        this.serverUserDir = serverUserDir;
        if (serverHostName.trim().isEmpty()) {
            serverHostName = ((VariableRegistry)this.variableRegistryServiceRef.getService()).resolveString(ENV_VAR_CONTAINERHOST);
            if (ENV_VAR_CONTAINERHOST.equals(serverHostName)) {
                serverHostName = serverDefaultHostName;
            }
            if (VAR_DEFAULTHOSTNAME.equals(serverHostName) || serverHostName.equals("localhost")) {
                try {
                    serverHostName = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
                        static final long serialVersionUID = 1613432855109678047L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public String run() throws UnknownHostException {
                            return InetAddress.getLocalHost().getCanonicalHostName();
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.logstash.collector.internal.LogstashCollector$1", 1.class, (String)"logstashCollector", (String)"com.ibm.ws.logstash.collector.internal.resources.LoggingMessages");
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)COMPONENT_NAME, (String)"245", (Object)((Object)this), (Object[])new Object[]{configuration});
                    serverHostName = "";
                }
            }
        }
        this.serverHostName = serverHostName;
    }

    public String getHandlerName() {
        return COMPONENT_NAME;
    }

    public Object formatEvent(String source, String location, Object event, String[] tags, int maxFieldLength) {
        String eventType = CollectorJsonUtils.getEventType((String)source, (String)location);
        String jsonStr = CollectorJsonUtils.jsonifyEvent((Object)event, (String)eventType, (String)this.serverName, (String)this.serverUserDir, (String)this.serverHostName, (String)this.logstashVersion, (String[])tags, (int)maxFieldLength);
        LumberjackEvent lumberjackEvent = null;
        if (!jsonStr.isEmpty()) {
            lumberjackEvent = new LumberjackEvent();
            lumberjackEvent.add(new LumberjackEvent.Entry((Object)"line", (Object)jsonStr));
            lumberjackEvent.add(new LumberjackEvent.Entry((Object)"type", (Object)eventType));
        }
        return lumberjackEvent;
    }

    public Target getTarget() {
        if (this.taskMgr == null) {
            this.taskMgr = new TaskManager(this.sslSupportServiceRef, this.executorServiceRef, 4){
                static final long serialVersionUID = -6777334882861954126L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public ClientPool createClientPool(String sslConfig, SSLSupport sslSupport, int numClients) throws SSLException {
                    return new LogstashClientPool(sslConfig, sslSupport, numClients);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.logstash.collector.internal.LogstashCollector$2", 2.class, (String)"logstashCollector", (String)"com.ibm.ws.logstash.collector.internal.resources.LoggingMessages");
                }
            };
        }
        return this.taskMgr;
    }
}

