/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data;

public record Limit(int maxResults, long startAt) {
    public Limit {
        if (startAt < 1L) {
            throw new IllegalArgumentException("startAt: " + startAt);
        }
        if (maxResults < 1) {
            throw new IllegalArgumentException("maxResults: " + maxResults);
        }
    }

    public static Limit of(int maxResults) {
        return new Limit(maxResults, 1L);
    }

    public static Limit range(long startAt, long endAt) {
        if (startAt > endAt) {
            throw new IllegalArgumentException("startAt: " + startAt + ", endAt: " + endAt);
        }
        if (Integer.MAX_VALUE <= endAt - startAt) {
            throw new IllegalArgumentException("startAt: " + startAt + ", endAt: " + endAt + ", maxResults > 2147483647");
        }
        return new Limit(1 + (int)(endAt - startAt), startAt);
    }
}

