/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.joblog;

import com.ibm.jbatch.container.ws.WSRemotablePartitionExecution;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RemotePartitionLog {
    private final WSRemotablePartitionExecution remotePartition;
    private List<File> jobLogFiles;
    private final File partitionLogRootDir;
    static final long serialVersionUID = 1733948631284743544L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public RemotePartitionLog(WSRemotablePartitionExecution partition) {
        this.remotePartition = partition;
        this.partitionLogRootDir = new File(partition.getLogpath());
    }

    public WSRemotablePartitionExecution getRemotePartition() {
        return this.remotePartition;
    }

    public List<File> getJobLogFiles() {
        return this.jobLogFiles;
    }

    public File getPartitionLogRootDir() {
        return this.partitionLogRootDir;
    }

    public File getPartByRelativePath(String relativePath) {
        relativePath = RemotePartitionLog.normalizePath(relativePath);
        for (File jobLogFile : this.jobLogFiles) {
            if (!RemotePartitionLog.normalizePath(this.getRelativePath(jobLogFile)).equals(relativePath)) continue;
            return jobLogFile;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected String getRelativePath(File jobLogFile) {
        try {
            return RemotePartitionLog.stripPrefix(jobLogFile.getCanonicalPath(), this.getPartitionLogRootDir().getCanonicalPath() + File.separator);
        }
        catch (IOException iOException) {
            void ioe;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.jbatch.joblog.RemotePartitionLog", (String)"96", (Object)this, (Object[])new Object[]{jobLogFile});
            throw new RuntimeException((Throwable)ioe);
        }
    }

    protected static String stripPrefix(String str, String prefix) {
        return str.startsWith(prefix) ? str.substring(prefix.length()) : str;
    }

    protected static String normalizePath(String path) {
        return path != null ? path.replaceAll("\\\\", "/") : path;
    }

    public List<String> getRelativePaths() {
        ArrayList<String> retMe = new ArrayList<String>();
        for (File jobLogFile : this.getJobLogFiles()) {
            retMe.add(this.getRelativePath(jobLogFile));
        }
        return retMe;
    }

    public boolean purge() {
        return this.deleteFileRecursive(this.partitionLogRootDir);
    }

    private boolean deleteFileRecursive(final File file) {
        boolean success = true;
        boolean isThere = true;
        boolean isDir = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = -4368815392849248793L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return file.isDirectory();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.RemotePartitionLog$1", 1.class, null, null);
            }
        });
        if (!isDir) {
            isThere = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = 1487146445698522275L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return file.exists();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.RemotePartitionLog$2", 2.class, null, null);
                }
            });
        }
        if (isDir) {
            File[] children;
            for (File f : children = AccessController.doPrivileged(new PrivilegedAction<File[]>(){
                static final long serialVersionUID = -7403501497709587654L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public File[] run() {
                    return file.listFiles();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.RemotePartitionLog$3", 3.class, null, null);
                }
            })) {
                success = success && this.deleteFileRecursive(f);
            }
        }
        if (success && isThere) {
            success = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = -4481966455434816575L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return file.delete();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.RemotePartitionLog$4", 4.class, null, null);
                }
            });
        }
        return success;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.RemotePartitionLog", RemotePartitionLog.class, null, null);
    }
}

