/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.api;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class ErrorOr<T> {
    private final T value;
    private final List<GraphQlClientError> errors;

    public static <T> ErrorOr<T> of(T value) {
        return new ErrorOr<T>(Objects.requireNonNull(value), null);
    }

    public static <T> ErrorOr<T> ofErrors(List<GraphQlClientError> errors) {
        return new ErrorOr<Object>(null, Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(errors))));
    }

    private ErrorOr(T value, List<GraphQlClientError> errors) {
        this.value = value;
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorOr that = (ErrorOr)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.errors, that.errors);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.errors);
    }

    public String toString() {
        return "ErrorOr(" + (this.isPresent() ? "value=" + this.value : "errors=" + this.errors) + ")";
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isError() {
        return !this.isPresent();
    }

    public T get() {
        if (this.isError()) {
            throw new NoSuchElementException("No value present, but " + this.errors);
        }
        return this.value;
    }

    public List<GraphQlClientError> getErrors() {
        if (this.isPresent()) {
            throw new NoSuchElementException("No error present, but value " + this.value);
        }
        return this.errors;
    }
}

