/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.transport.client;

import com.ibm.ws.repository.common.enums.FilterableAttribute;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.common.enums.Visibility;
import com.ibm.ws.repository.transport.client.RepositoryReadableClient;
import com.ibm.ws.repository.transport.exceptions.RequestFailureException;
import com.ibm.ws.repository.transport.model.AppliesToFilterInfo;
import com.ibm.ws.repository.transport.model.Asset;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractRepositoryClient
implements RepositoryReadableClient {
    @Override
    public Collection<Asset> getAssets(Collection<ResourceType> types, Collection<String> productIds, Visibility visibility, Collection<String> productVersions) throws IOException, RequestFailureException {
        return this.getFilteredAssets(types, productIds, visibility, productVersions, false);
    }

    @Override
    public Collection<Asset> getAssetsWithUnboundedMaxVersion(Collection<ResourceType> types, Collection<String> rightProductIds, Visibility visibility) throws IOException, RequestFailureException {
        return this.getFilteredAssets(types, rightProductIds, visibility, null, true);
    }

    @Override
    public Collection<Asset> getAssets(ResourceType type) throws IOException, RequestFailureException {
        Set<ResourceType> types = type == null ? null : Collections.singleton(type);
        return this.getFilteredAssets(types, null, null, null, false);
    }

    @Override
    public Collection<Asset> getFilteredAssets(Map<FilterableAttribute, Collection<String>> filters) throws IOException, RequestFailureException {
        if (filters == null || this.allFiltersAreEmpty(filters)) {
            return this.getAllAssets();
        }
        Collection<Asset> allAssets = this.getAllAssets();
        ArrayList<Asset> filtered = new ArrayList<Asset>();
        block0: for (Asset asset : allAssets) {
            block1: for (Map.Entry<FilterableAttribute, Collection<String>> entry : filters.entrySet()) {
                FilterableAttribute attrib = entry.getKey();
                Collection<String> values = entry.getValue();
                Collection<String> assetValues = this.getValues(attrib, asset);
                if (values == null || values.size() == 0) continue;
                for (String filterValue : values) {
                    if (!assetValues.contains(filterValue)) continue;
                    continue block1;
                }
                continue block0;
            }
            filtered.add(asset);
        }
        return filtered;
    }

    @Override
    public List<Asset> findAssets(String searchString, Collection<ResourceType> types) throws IOException, RequestFailureException {
        Collection<Asset> assets = this.getAssets(types, null, null, null);
        ArrayList<Asset> foundAssets = new ArrayList<Asset>();
        for (Asset ass : assets) {
            if (!(ass.getName() != null && ass.getName().contains(searchString) || ass.getDescription() != null && ass.getDescription().contains(searchString)) && (ass.getShortDescription() == null || !ass.getShortDescription().contains(searchString))) continue;
            foundAssets.add(ass);
        }
        return foundAssets;
    }

    protected Collection<Asset> getFilteredAssets(Collection<ResourceType> types, Collection<String> productIds, Visibility visibility, Collection<String> productVersions, boolean unboundedMaxVersion) throws IOException, RequestFailureException {
        HashMap<FilterableAttribute, Collection<String>> filters = new HashMap<FilterableAttribute, Collection<String>>();
        if (types != null && !types.isEmpty()) {
            HashSet<String> typeValues = new HashSet<String>();
            for (ResourceType type : types) {
                typeValues.add(type.getValue());
            }
            filters.put(FilterableAttribute.TYPE, typeValues);
        }
        filters.put(FilterableAttribute.PRODUCT_ID, productIds);
        if (visibility != null) {
            filters.put(FilterableAttribute.VISIBILITY, Collections.singleton(visibility.toString()));
        }
        filters.put(FilterableAttribute.PRODUCT_MIN_VERSION, productVersions);
        if (unboundedMaxVersion) {
            filters.put(FilterableAttribute.PRODUCT_HAS_MAX_VERSION, Collections.singleton(Boolean.FALSE.toString()));
        }
        return this.getFilteredAssets(filters);
    }

    protected boolean allFiltersAreEmpty(Map<FilterableAttribute, Collection<String>> filters) {
        for (Map.Entry<FilterableAttribute, Collection<String>> filter : filters.entrySet()) {
            Collection<String> values = filter.getValue();
            if (values == null || values.isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected Collection<String> getValues(FilterableAttribute attrib, Asset asset) {
        switch (attrib) {
            case LOWER_CASE_SHORT_NAME: {
                String ret = asset.getWlpInformation().getLowerCaseShortName();
                return ret == null ? Collections.emptyList() : Collections.singleton(ret);
            }
            case PRODUCT_HAS_MAX_VERSION: {
                return AbstractRepositoryClient.getFromAppliesTo(asset, new AppliesToFilterGetter(){

                    @Override
                    public String getValue(AppliesToFilterInfo atfi) {
                        return atfi.getHasMaxVersion();
                    }
                });
            }
            case PRODUCT_ID: {
                return AbstractRepositoryClient.getFromAppliesTo(asset, new AppliesToFilterGetter(){

                    @Override
                    public String getValue(AppliesToFilterInfo atfi) {
                        return atfi.getProductId() != null ? atfi.getProductId() : null;
                    }
                });
            }
            case PRODUCT_MIN_VERSION: {
                return AbstractRepositoryClient.getFromAppliesTo(asset, new AppliesToFilterGetter(){

                    @Override
                    public String getValue(AppliesToFilterInfo atfi) {
                        return atfi.getMinVersion() != null ? atfi.getMinVersion().getValue() : null;
                    }
                });
            }
            case SHORT_NAME: {
                String ret = asset.getWlpInformation().getShortName();
                return ret == null ? Collections.emptyList() : Collections.singleton(ret);
            }
            case SYMBOLIC_NAME: {
                return asset.getWlpInformation().getProvideFeature() == null ? Collections.emptyList() : asset.getWlpInformation().getProvideFeature();
            }
            case TYPE: {
                String ret = asset.getType() == null ? null : asset.getType().getValue();
                return ret == null ? Collections.emptyList() : Collections.singleton(ret);
            }
            case VISIBILITY: {
                String ret = asset.getWlpInformation().getVisibility() == null ? null : asset.getWlpInformation().getVisibility().toString();
                return ret == null ? Collections.emptyList() : Collections.singleton(ret);
            }
            case VANITY_URL: {
                String ret = asset.getWlpInformation().getVanityRelativeURL() == null ? null : asset.getWlpInformation().getVanityRelativeURL();
                return ret == null ? Collections.emptyList() : Collections.singleton(ret);
            }
        }
        return null;
    }

    private static Collection<String> getFromAppliesTo(Asset asset, AppliesToFilterGetter getter) {
        Collection<AppliesToFilterInfo> atfis = asset.getWlpInformation().getAppliesToFilterInfo();
        ArrayList<String> ret = new ArrayList<String>();
        if (atfis != null) {
            for (AppliesToFilterInfo at : atfis) {
                String val;
                if (at == null || (val = getter.getValue(at)) == null) continue;
                ret.add(val);
            }
        }
        return ret;
    }

    private static interface AppliesToFilterGetter {
        public String getValue(AppliesToFilterInfo var1);
    }
}

