/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.attachment.AttachmentDeserializer;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJStreamWriter;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.ServiceUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class MessageModeOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    MessageModeOutInterceptorInternal internal;
    SAAJOutInterceptor saajOut;
    Class<?> type;
    QName bindingName;
    private static final Logger LOG = LogUtils.getLogger(MessageModeOutInterceptor.class);
    static final long serialVersionUID = -8153654816499891956L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MessageModeOutInterceptor(SAAJOutInterceptor saajOut, QName bname) {
        super("prepare-send");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor", "<init>", new Object[]{saajOut, bname});
        }
        this.saajOut = saajOut;
        this.bindingName = bname;
        this.internal = new MessageModeOutInterceptorInternal();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MessageModeOutInterceptor(Class<?> t, QName bname) {
        super("prepare-send");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor", "<init>", new Object[]{t, bname});
        }
        this.type = t;
        this.bindingName = bname;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(@Sensitive Message message) throws Fault {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive org.apache.cxf.message.Message>";
            LOG.entering("org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor", "handleMessage", objectArray);
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        BindingOperationInfo bop = message.getExchange().getBindingOperationInfo();
        if (bop != null && !this.bindingName.equals(bop.getBinding().getName())) {
            if (isFinestEnabled) {
                LOG.finest("BindingOperationInfo is null or binding qname is different than the one provided in constructor. Returning.");
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor", "handleMessage");
            }
            return;
        }
        if (this.saajOut != null) {
            this.doSoap(message);
        } else if (DataSource.class.isAssignableFrom(this.type)) {
            String ct;
            MessageContentsList list = (MessageContentsList)message.getContent(List.class);
            DataSource ds = (DataSource)list.get(0);
            if (isFinestEnabled) {
                LOG.finest("First element of messageContentsList that is obtained from message that will be cast to DataSource: " + list.get(0));
            }
            if ((ct = ds.getContentType()).toLowerCase().contains("multipart/related")) {
                MessageImpl msg = new MessageImpl();
                msg.setExchange(message.getExchange());
                msg.put((Object)"Content-Type", (Object)ct);
                try {
                    msg.setContent(InputStream.class, (Object)ds.getInputStream());
                    AttachmentDeserializer deser = new AttachmentDeserializer((Message)msg);
                    deser.initializeAttachments();
                }
                catch (IOException ex) {
                    throw new Fault((Throwable)ex);
                }
                message.setAttachments(msg.getAttachments());
                final InputStream in = (InputStream)msg.getContent(InputStream.class);
                final String ct2 = (String)msg.get((Object)"Content-Type");
                list.set(0, (Object)new DataSource(){
                    static final long serialVersionUID = 4915416665347580650L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public String getContentType() {
                        return ct2;
                    }

                    public InputStream getInputStream() throws IOException {
                        return in;
                    }

                    public String getName() {
                        return ct2;
                    }

                    public OutputStream getOutputStream() throws IOException {
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor$1", 1.class, null, null);
                    }
                });
            } else if (!ct.toLowerCase().contains("xml")) {
                OutputStream out = (OutputStream)message.getContent(OutputStream.class);
                message.put((Object)"Content-Type", (Object)ct);
                try {
                    InputStream in = ds.getInputStream();
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    in.close();
                    out.flush();
                    out.close();
                    if (isFinestEnabled) {
                        LOG.finest("The InputStream that is obtained from DataSource is copied over to OutputStream that is obtained from message content.");
                    }
                }
                catch (IOException e) {
                    throw new Fault((Throwable)e);
                }
                list.remove(0);
                out = new CachedOutputStream();
                message.setContent(OutputStream.class, (Object)out);
                XMLStreamWriter writer = StaxUtils.createXMLStreamWriter((OutputStream)out);
                message.setContent(XMLStreamWriter.class, (Object)writer);
            }
        } else if (ServiceUtils.isSchemaValidationEnabled((SchemaValidation.SchemaValidationType)SchemaValidation.SchemaValidationType.OUT, (Message)message) && Source.class.isAssignableFrom(this.type)) {
            MessageContentsList list = (MessageContentsList)message.getContent(List.class);
            Source ds = (Source)list.get(0);
            if (isFinestEnabled) {
                LOG.finest("Source that is obtained from message content: " + ds);
            }
            if (!(ds instanceof DOMSource)) {
                try {
                    ds = new DOMSource(StaxUtils.read((Source)ds));
                    if (isFinestEnabled) {
                        LOG.finest("Source is an instance of DOMSource. A new DOMSource will be constructed with it: " + ds);
                    }
                }
                catch (XMLStreamException e) {
                    throw new Fault((Throwable)e);
                }
                list.set(0, (Object)ds);
                if (isFinestEnabled) {
                    LOG.finest("MessageContentsList(list): " + list);
                }
                this.validatePossibleFault(message, bop, ((DOMSource)ds).getNode());
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void validatePossibleFault(@Sensitive Message message, BindingOperationInfo bop, Node ds) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            Object[] objectArray = new Object[3];
            objectArray[0] = "<sensitive org.apache.cxf.message.Message>";
            objectArray[1] = bop;
            objectArray[2] = ds;
            LOG.entering("org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor", "validatePossibleFault", objectArray);
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        Element el = DOMUtils.getFirstElement((Node)ds);
        if (!"Fault".equals(el.getLocalName())) {
            if (isFinestEnabled) {
                LOG.finest("Node already contains a fault. No extra validation required. Returning. " + ds);
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor", "validatePossibleFault");
            }
            return;
        }
        message.put((Object)Message.RESPONSE_CODE, (Object)500);
        el = DOMUtils.getFirstElement((Node)el);
        while (el != null && !"detail".equals(el.getLocalName())) {
            el = DOMUtils.getNextElement((Element)el);
        }
        if (isFinestEnabled) {
            LOG.finest("Detail sub section of the fault" + el);
        }
        if (el != null) {
            Schema schema = EndpointReferenceUtils.getSchema((ServiceInfo)((ServiceInfo)message.getExchange().getService().getServiceInfos().get(0)), (Bus)message.getExchange().getBus());
            if (isFinestEnabled) {
                LOG.finest("Schema that is obtained from EndpointReferenceUtils" + schema);
            }
            try {
                this.validateFaultDetail(el, schema, bop);
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
            message.put((Object)"schema-validation-enabled", (Object)Boolean.FALSE);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor", "validatePossibleFault");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void validateFaultDetail(Element detail, Schema schema, BindingOperationInfo bop) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor", "validateFaultDetail", new Object[]{detail, schema, bop});
        }
        if (detail != null) {
            Element el = DOMUtils.getFirstElement((Node)detail);
            while (el != null) {
                QName qn = DOMUtils.getElementQName((Element)el);
                for (BindingFaultInfo bfi : bop.getFaults()) {
                    if (!bfi.getFaultInfo().getMessagePartByIndex(0).getConcreteName().equals(qn)) continue;
                    schema.newValidator().validate(new DOMSource(DOMUtils.getDomElement((Node)el)));
                }
                el = DOMUtils.getNextElement((Element)el);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor", "validateFaultDetail");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void validateFault(@Sensitive SoapMessage message, SOAPFault fault, BindingOperationInfo bop) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            Object[] objectArray = new Object[3];
            objectArray[0] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
            objectArray[1] = fault;
            objectArray[2] = bop;
            LOG.entering("org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor", "validateFault", objectArray);
        }
        if (ServiceUtils.isSchemaValidationEnabled((SchemaValidation.SchemaValidationType)SchemaValidation.SchemaValidationType.OUT, (Message)message)) {
            Schema schema = EndpointReferenceUtils.getSchema((ServiceInfo)((ServiceInfo)message.getExchange().getService().getServiceInfos().get(0)), (Bus)message.getExchange().getBus());
            Detail d = fault.getDetail();
            try {
                this.validateFaultDetail((Element)d, schema, bop);
            }
            catch (Exception e) {
                throw new SoapFault(e.getMessage(), (Throwable)e, message.getVersion().getReceiver());
            }
            message.put((Object)"schema-validation-enabled", (Object)Boolean.FALSE);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor", "validateFault");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void doSoap(@Sensitive Message message) {
        block23: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                Object[] objectArray = new Object[1];
                objectArray[0] = "<sensitive org.apache.cxf.message.Message>";
                LOG.entering("org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor", "doSoap", objectArray);
            }
            boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
            MessageContentsList list = (MessageContentsList)message.getContent(List.class);
            if (list == null || list.isEmpty()) {
                if (isFinestEnabled) {
                    LOG.finest("MessageContentsList is null or empty. Returning.");
                }
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor", "doSoap");
                }
                return;
            }
            Object o = list.get(0);
            if (isFinestEnabled) {
                LOG.finest("First element of MessageContentsList that is obtained from message: " + o);
            }
            if (o instanceof SOAPMessage) {
                SOAPMessage soapMessage;
                block22: {
                    block21: {
                        soapMessage = (SOAPMessage)o;
                        if (soapMessage.countAttachments() > 0) {
                            message.put((Object)"write.attachments", (Object)Boolean.TRUE);
                            if (isFinestEnabled) {
                                LOG.finest("write.attachments is set t true in message.");
                            }
                        }
                        try {
                            if (message instanceof SoapMessage) {
                                String namespace;
                                SoapMessage cxfSoapMessage = (SoapMessage)message;
                                String cxfNamespace = cxfSoapMessage.getVersion().getNamespace();
                                SOAPHeader soapHeader = soapMessage.getSOAPHeader();
                                String string = namespace = soapHeader == null ? null : soapHeader.getNamespaceURI();
                                if ("http://www.w3.org/2003/05/soap-envelope".equals(namespace) && !namespace.equals(cxfNamespace)) {
                                    cxfSoapMessage.setVersion((SoapVersion)Soap12.getInstance());
                                    cxfSoapMessage.put((Object)"Content-Type", (Object)cxfSoapMessage.getVersion().getContentType());
                                    if (isFinestEnabled) {
                                        LOG.finest("Message version is SOAP 1.2 " + cxfSoapMessage.getVersion());
                                        LOG.finest("Message content type is set to cxfSoapMessage version's content type: " + cxfSoapMessage.get((Object)"Content-Type"));
                                    }
                                }
                            }
                        }
                        catch (SOAPException e) {
                            if (!isFinestEnabled) break block21;
                            LOG.finest("Ignored SOAPException(message): " + e.getMessage());
                        }
                    }
                    try {
                        Object enc = soapMessage.getProperty("javax.xml.soap.character-set-encoding");
                        if (enc instanceof String) {
                            message.put((Object)Message.ENCODING, enc);
                            if (isFinestEnabled) {
                                LOG.finest("Message encoding is set to : " + enc);
                            }
                        }
                    }
                    catch (SOAPException e) {
                        if (!isFinestEnabled) break block22;
                        LOG.finest("Ignored SOAPException(message): " + e.getMessage());
                    }
                }
                try {
                    Object xmlDec = soapMessage.getProperty("javax.xml.soap.write-xml-declaration");
                    if (xmlDec != null) {
                        boolean b = PropertyUtils.isTrue((Object)xmlDec);
                        message.put((Object)"org.apache.cxf.stax.force-start-document", (Object)b);
                    }
                }
                catch (SOAPException e) {
                    if (!isFinestEnabled) break block23;
                    LOG.finest("Ignored SOAPException(message): " + e.getMessage());
                }
            }
        }
        message.getInterceptorChain().add((Interceptor)this.internal);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor", "doSoap");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private class MessageModeOutInterceptorInternal
    extends AbstractSoapInterceptor {
        static final long serialVersionUID = -7373572431613445360L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        MessageModeOutInterceptorInternal() {
            super("pre-protocol");
            this.addBefore(SAAJOutInterceptor.class.getName());
        }

        public void handleMessage(@Sensitive SoapMessage message) throws Fault {
            boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
            MessageContentsList list = (MessageContentsList)message.getContent(List.class);
            Object o = list.remove(0);
            SOAPMessage soapMessage = null;
            if (o instanceof SOAPMessage) {
                soapMessage = (SOAPMessage)o;
                if (soapMessage.countAttachments() > 0) {
                    message.put((Object)"write.attachments", (Object)Boolean.TRUE);
                    if (isFinestEnabled) {
                        LOG.finest("write.attachments is set to true in message.");
                    }
                }
            } else {
                try {
                    MessageFactory factory = MessageModeOutInterceptor.this.saajOut.getFactory(message);
                    soapMessage = factory.createMessage();
                    SOAPPart part = soapMessage.getSOAPPart();
                    if (o instanceof Source) {
                        StaxUtils.copy((Source)((Source)o), (XMLStreamWriter)new SAAJStreamWriter(part));
                        if (isFinestEnabled) {
                            LOG.finest("Source that is obtained from message content is copied over SAAJStreamWriter instance with the parameter SOAPPart: " + o);
                        }
                    }
                }
                catch (SOAPException | XMLStreamException e) {
                    throw new SoapFault("Error creating SOAPMessage", e, message.getVersion().getSender());
                }
            }
            BindingOperationInfo bop = message.getExchange().getBindingOperationInfo();
            DocumentFragment frag = soapMessage.getSOAPPart().createDocumentFragment();
            try {
                Object buffer;
                SOAPBody body = SAAJUtils.getBody((SOAPMessage)soapMessage);
                Node nd = body.getFirstChild();
                while (nd != null) {
                    if (nd instanceof SOAPFault) {
                        message.put((Object)Message.RESPONSE_CODE, (Object)500);
                        MessageModeOutInterceptor.this.validateFault(message, (SOAPFault)nd, bop);
                    }
                    body.removeChild(nd);
                    nd = DOMUtils.getDomElement((Node)nd);
                    frag.appendChild(nd);
                    nd = SAAJUtils.getBody((SOAPMessage)soapMessage).getFirstChild();
                }
                if (isFinestEnabled) {
                    LOG.finest("Nodes are removed from body and added to newly instantiated DocumentFragment: " + frag);
                }
                message.setContent(SOAPMessage.class, (Object)soapMessage);
                if (!message.containsKey((Object)SAAJOutInterceptor.ORIGINAL_XML_WRITER)) {
                    XMLStreamWriter origWriter = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
                    message.put((Object)SAAJOutInterceptor.ORIGINAL_XML_WRITER, (Object)origWriter);
                }
                SAAJStreamWriter writer = new SAAJStreamWriter(soapMessage.getSOAPPart());
                message.setContent(XMLStreamWriter.class, (Object)writer);
                message.setContent(SOAPMessage.class, (Object)soapMessage);
                int index = 0;
                boolean client = this.isRequestor((Message)message);
                BindingMessageInfo bmsg = null;
                if (client && bop != null) {
                    bmsg = bop.getInput();
                } else if (bop != null && bop.getOutput() != null) {
                    bmsg = bop.getOutput();
                }
                if (bmsg != null && bmsg.getMessageParts() != null && bmsg.getMessageParts().size() > 0) {
                    index = ((MessagePartInfo)bmsg.getMessageParts().get(0)).getIndex();
                }
                list.set(index, (Object)frag);
                if (isFinestEnabled) {
                    LOG.finest("DocumentFragment is set in MessageContentsList: " + frag + ",  with index: " + index);
                }
                if ((buffer = message.getContextualProperty("org.apache.cxf.output.buffering")) == null) {
                    message.put((Object)"org.apache.cxf.output.buffering", (Object)Boolean.FALSE);
                    if (isFinestEnabled) {
                        LOG.finest("org.apache.cxf.output.buffering is set to false.");
                    }
                }
            }
            catch (Exception ex) {
                throw new Fault((Throwable)ex);
            }
            if (bop != null && bop.isUnwrapped()) {
                bop = bop.getWrappedOperation();
                message.getExchange().put(BindingOperationInfo.class, (Object)bop);
                if (isFinestEnabled) {
                    LOG.finest("BindingOperationInfo is switched to wrapped version in exchange.");
                }
            }
            message.getInterceptorChain().add((Interceptor)SAAJOutInterceptor.SAAJOutEndingInterceptor.INSTANCE);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor$MessageModeOutInterceptorInternal", MessageModeOutInterceptorInternal.class, null, null);
        }
    }
}

