/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.netty;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.jfapchannel.framework.IOConnectionContext;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionContext;
import com.ibm.ws.sib.jfapchannel.netty.NettyIOConnectionContext;
import com.ibm.ws.sib.jfapchannel.netty.NettyNetworkConnection;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import io.netty.channel.Channel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLSession;

public class NettyNetworkConnectionContext
implements NetworkConnectionContext {
    private static final TraceComponent tc = SibTr.register(NettyNetworkConnectionContext.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private ConversationMetaData metaData;
    private NettyNetworkConnection conn = null;

    public NettyNetworkConnectionContext(final NettyNetworkConnection conn) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{conn});
        }
        this.conn = conn;
        this.metaData = new ConversationMetaData(){

            @Override
            public boolean isInbound() {
                return conn.isInbound();
            }

            @Override
            public SSLSession getSSLSession() {
                return conn.getSSLSession();
            }

            @Override
            public int getRemotePort() {
                return ((InetSocketAddress)conn.getVirtualConnection().remoteAddress()).getPort();
            }

            @Override
            public InetAddress getRemoteAddress() {
                return ((InetSocketAddress)conn.getVirtualConnection().remoteAddress()).getAddress();
            }

            @Override
            public String getChainName() {
                return conn.getChainName();
            }
        };
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>", (Object)new Object[]{this.conn, this.metaData});
        }
    }

    @Override
    public void close(NetworkConnection networkConnection, Throwable throwable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object)new Object[]{networkConnection, throwable});
        }
        if (FrameworkState.isStopping()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
            }
            return;
        }
        Exception exception = null;
        exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
        Channel chan = this.conn.getVirtualConnection();
        if (chan != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"close: Found Netty Channel to close: ", (Object)new Object[]{chan, chan.isActive(), chan.isOpen()});
            }
            chan.close();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"close", (Object)"Found NULL Netty Channel to close");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close", (Object)new Object[]{networkConnection, throwable});
        }
    }

    @Override
    public IOConnectionContext getIOContextForDevice() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getIOContextForDevice");
        }
        NettyIOConnectionContext ioConnCtx = new NettyIOConnectionContext(this.conn);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getIOContextForDevice", (Object)ioConnCtx);
        }
        return ioConnCtx;
    }

    @Override
    public ConversationMetaData getMetaData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMetaData");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)this.metaData);
        }
        return this.metaData;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/netty/jfapchannel/NettyNetworkConnectionContext.java, SIB.comms, WASX.SIB, uu1215.01 1.2");
        }
    }
}

