/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class WebContainerLogger
extends Logger {
    private Logger delegateLogger;
    private static Hashtable<String, WebContainerLogger> map = new Hashtable();

    public static Logger getLogger(final String name, final String resourceBundleName) {
        WebContainerLogger tempLogger = map.get(name);
        if (tempLogger == null) {
            tempLogger = AccessController.doPrivileged(new PrivilegedAction<WebContainerLogger>(){

                @Override
                public WebContainerLogger run() {
                    return new WebContainerLogger(Logger.getLogger(name, resourceBundleName), name, resourceBundleName);
                }
            });
            map.put(name, tempLogger);
        }
        return tempLogger;
    }

    protected WebContainerLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    protected WebContainerLogger(Logger logger, String name, String resourceBundleName) {
        super(name, null);
        this.delegateLogger = logger;
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        this.delegateLogger.logp(level, sourceClass, sourceMethod, msg);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        this.delegateLogger.logp(level, sourceClass, sourceMethod, msg, param1);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        this.delegateLogger.logp(level, sourceClass, sourceMethod, msg, thrown);
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.delegateLogger.getResourceBundle();
    }

    @Override
    public String getResourceBundleName() {
        return this.delegateLogger.getResourceBundleName();
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
        this.delegateLogger.setFilter(newFilter);
    }

    @Override
    public Filter getFilter() {
        return this.delegateLogger.getFilter();
    }

    @Override
    public void log(LogRecord record) {
        this.delegateLogger.log(record);
    }

    private void doLog(LogRecord lr) {
        this.delegateLogger.log(lr);
    }

    @Override
    public void log(Level level, String msg) {
        this.delegateLogger.log(level, msg);
    }

    @Override
    public void log(Level level, String msg, Object param1) {
        this.delegateLogger.log(level, msg, param1);
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        this.delegateLogger.log(level, msg, params);
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        this.delegateLogger.log(level, msg, thrown);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        this.delegateLogger.logrb(level, sourceClass, sourceMethod, bundleName, msg);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        this.delegateLogger.logrb(level, sourceClass, sourceMethod, bundleName, msg, param1);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        this.delegateLogger.logrb(level, sourceClass, sourceMethod, bundleName, msg, params);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        this.delegateLogger.logrb(level, sourceClass, sourceMethod, bundleName, msg, thrown);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        this.delegateLogger.entering(sourceClass, sourceMethod);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object param1) {
        this.delegateLogger.entering(sourceClass, sourceMethod, param1);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        this.delegateLogger.entering(sourceClass, sourceMethod, params);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        this.delegateLogger.exiting(sourceClass, sourceMethod);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod, Object result) {
        this.delegateLogger.exiting(sourceClass, sourceMethod, result);
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.delegateLogger.throwing(sourceClass, sourceMethod, thrown);
    }

    @Override
    public void severe(String msg) {
        this.delegateLogger.severe(msg);
    }

    @Override
    public void warning(String msg) {
        this.delegateLogger.warning(msg);
    }

    @Override
    public void info(String msg) {
        this.delegateLogger.info(msg);
    }

    @Override
    public void config(String msg) {
        this.delegateLogger.config(msg);
    }

    @Override
    public void fine(String msg) {
        this.delegateLogger.fine(msg);
    }

    @Override
    public void finer(String msg) {
        this.delegateLogger.finer(msg);
    }

    @Override
    public void finest(String msg) {
        this.delegateLogger.finest(msg);
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        this.delegateLogger.setLevel(newLevel);
    }

    @Override
    public Level getLevel() {
        return this.delegateLogger.getLevel();
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.delegateLogger.isLoggable(level);
    }

    @Override
    public String getName() {
        return this.delegateLogger.getName();
    }

    @Override
    public synchronized void addHandler(Handler handler) throws SecurityException {
        this.delegateLogger.addHandler(handler);
    }

    @Override
    public synchronized void removeHandler(Handler handler) throws SecurityException {
        this.delegateLogger.removeHandler(handler);
    }

    @Override
    public synchronized Handler[] getHandlers() {
        return this.delegateLogger.getHandlers();
    }

    @Override
    public synchronized void setUseParentHandlers(boolean useParentHandlers) {
        this.delegateLogger.setUseParentHandlers(useParentHandlers);
    }

    @Override
    public synchronized boolean getUseParentHandlers() {
        return this.delegateLogger.getUseParentHandlers();
    }

    @Override
    public Logger getParent() {
        return this.delegateLogger.getParent();
    }

    @Override
    public void setParent(Logger parent) {
        this.delegateLogger.setParent(parent);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (params != null && params.length > 0 && params[params.length - 1] instanceof Throwable) {
            params[params.length - 1] = WebContainerLogger.throwableToString((Throwable)params[params.length - 1]);
        }
        this.delegateLogger.logp(level, sourceClass, sourceMethod, msg, params);
    }

    public static String throwableToString(Throwable t) {
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        t.printStackTrace(p);
        return s.toString();
    }
}

