/*
 * Decompiled with CFR 0.152.
 */
package jakarta.security.jacc;

class URLPattern
implements Comparable<URLPattern> {
    private static String DEFAULT_PATTERN = "/";
    public static final int PT_DEFAULT = 0;
    public static final int PT_EXTENSION = 1;
    public static final int PT_PREFIX = 2;
    public static final int PT_EXACT = 3;
    private int patternType = -1;
    private final String pattern;

    public URLPattern() {
        this.pattern = DEFAULT_PATTERN;
        this.patternType = 0;
    }

    public URLPattern(String pattern) {
        if (pattern == null) {
            this.pattern = DEFAULT_PATTERN;
            this.patternType = 0;
        } else {
            this.pattern = pattern;
        }
    }

    public int patternType() {
        if (this.patternType < 0) {
            this.patternType = this.pattern.startsWith("*.") ? 1 : (this.pattern.startsWith("/") && this.pattern.endsWith("/*") ? 2 : (DEFAULT_PATTERN.equals(this.pattern) ? 0 : 3));
        }
        return this.patternType;
    }

    @Override
    public int compareTo(URLPattern that) {
        int refPatternType = this.patternType();
        int result = refPatternType - that.patternType();
        if (result == 0) {
            if (refPatternType == 2 || refPatternType == 3) {
                result = this.getPatternDepth() - that.getPatternDepth();
                if (result == 0) {
                    result = this.pattern.compareTo(that.pattern);
                }
            } else {
                result = this.pattern.compareTo(that.pattern);
            }
        }
        return result > 0 ? 1 : (result < 0 ? -1 : 0);
    }

    public boolean implies(URLPattern that) {
        String thatPattern;
        String thisPattern;
        if (that == null) {
            that = new URLPattern(null);
        }
        if ((thisPattern = this.pattern).equals(thatPattern = that.pattern)) {
            return true;
        }
        if (thisPattern.startsWith("/") && thisPattern.endsWith("/*")) {
            int length = (thisPattern = thisPattern.substring(0, thisPattern.length() - 2)).length();
            if (length == 0) {
                return true;
            }
            return thatPattern.startsWith(thisPattern) && (thatPattern.length() == length || thatPattern.substring(length).startsWith("/"));
        }
        if (thisPattern.startsWith("*.")) {
            int slash = thatPattern.lastIndexOf(47);
            int period = thatPattern.lastIndexOf(46);
            return slash >= 0 && period > slash && thatPattern.endsWith(thisPattern.substring(1));
        }
        return thisPattern.equals(DEFAULT_PATTERN);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URLPattern)) {
            return false;
        }
        return this.pattern.equals(((URLPattern)obj).pattern);
    }

    public String toString() {
        return this.pattern;
    }

    public int getPatternDepth() {
        int i = 0;
        int depth = 1;
        while (i >= 0) {
            if ((i = this.pattern.indexOf("/", i)) < 0) continue;
            if (i == 0 && depth != 1) {
                throw new IllegalArgumentException("// in pattern");
            }
            ++i;
        }
        return depth;
    }
}

