/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.utils.ras.SibTr;

public class ProtocolItemStream
extends SIMPItemStream {
    private static TraceComponent tc = SibTr.register(ProtocolItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private BaseDestinationHandler destinationHandler = null;

    public ProtocolItemStream() {
    }

    public ProtocolItemStream(BaseDestinationHandler destinationHandler, Transaction transaction) throws OutOfCacheSpace, MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ProtocolItemStream", (Object)new Object[]{destinationHandler, transaction});
        }
        this.setStorageStrategy(destinationHandler.getStorageStrategy());
        destinationHandler.addItemStream(this, transaction);
        this.initializeNonPersistent(destinationHandler, destinationHandler.getTxManager());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ProtocolItemStream", (Object)((Object)this));
        }
    }

    public void reconstitute(BaseDestinationHandler destinationHandler, SIMPTransactionManager txManager) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)new Object[]{destinationHandler, txManager});
        }
        this.initializeNonPersistent(destinationHandler, txManager);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitute");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeNonPersistent(BaseDestinationHandler destinationHandler, SIMPTransactionManager txManager) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNonPersistent", (Object)new Object[]{destinationHandler, txManager});
        }
        this.destinationHandler = destinationHandler;
        NonLockingCursor cursor = null;
        try {
            cursor = this.newNonLockingItemCursor(new ClassEqualsFilter(StreamSet.class));
            AbstractItem item = null;
            while (null != (item = cursor.next())) {
                StreamSet streamSet = (StreamSet)item;
                streamSet.initializeNonPersistent(txManager);
            }
        }
        finally {
            if (cursor != null) {
                cursor.finished();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    public int countProtocolItems() throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"countProtocolItems");
        }
        int count = 0;
        NonLockingCursor cursor = this.newNonLockingItemCursor(new ClassEqualsFilter(StreamSet.class));
        AbstractItem item = cursor.next();
        while (null != item) {
            ++count;
            item = cursor.next();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"countProtocolItems", (Object)new Integer(count));
        }
        return count;
    }

    public BaseDestinationHandler getDestinationHandler() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHandler");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHandler", (Object)this.destinationHandler);
        }
        return this.destinationHandler;
    }
}

