/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.memory;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.store.memory.MemoryStore;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.session.IStore;
import com.ibm.wsspi.session.IStoreCallback;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;

public class MemorySession
implements ISession {
    private static final long serialVersionUID = 5445113386085090398L;
    protected IStore _store;
    protected IStoreCallback _storeCallback;
    protected String _sessionId;
    protected boolean _isValid = true;
    protected boolean _isNew = true;
    protected long _currentAccessTime;
    protected long _lastAccessedTime;
    protected long _creationTime;
    protected int _version;
    protected String _userName;
    protected int _maxInactiveInterval;
    protected int _refCount;
    protected String _appName;
    protected Hashtable _attributes = new Hashtable(5);
    protected Hashtable _attributeNames = new Hashtable(5);
    private Object _adaptation = null;
    private Object _appAdaptation = null;
    private boolean isOverflow = false;
    protected boolean invalInProgress = false;
    protected SessionGCount _gcCount = null;
    protected SessionManagerConfig _smc;
    private static final String methodClassName = "MemorySession";
    private static final String newValueString = "New Value=";
    private static final String oldValueString = "; Old Value=";
    protected String appNameAndIdString = "";
    private static final int INVALIDATE = 0;
    private static final int GET_ATTRIBUTE = 1;
    private static final int SET_ATTRIBUTE = 2;
    private static final int REMOVE_ATTRIBUTE = 3;
    private static final int GET_LISTENER_ATTRIBUTE_NAMES = 4;
    private static final int UPDATE_LAST_ACCESS_TIME = 5;
    private static final int INTERNAL_INVALIDATE = 6;
    private static final int GET_SWAPPABLE_DATA = 7;
    private boolean _removeAttrOnInvalidate = false;
    private static final String[] methodNames = new String[]{"invalidate", "getAttribute", "setAttribute", "removeAttribute", "getListenerAttributeNames", "updateLastAccessTime", "internalInvalidate", "getSwappableData"};

    public MemorySession() {
    }

    public MemorySession(IStore store, String Id, IStoreCallback storeCallback) {
        this(store, Id, storeCallback, false);
    }

    public MemorySession(IStore store, String Id, IStoreCallback storeCallback, boolean removeAttrOnInvalidate) {
        this._store = store;
        this._appName = store.getId();
        this._sessionId = Id;
        this._creationTime = System.currentTimeMillis();
        this._lastAccessedTime = 0L;
        this._currentAccessTime = this._creationTime;
        this._storeCallback = storeCallback;
        this._smc = ((MemoryStore)this._store).getSessionManagerConfig();
        if (this._smc.isTrackGCCount()) {
            this._gcCount = new SessionGCount();
        }
        this._removeAttrOnInvalidate = removeAttrOnInvalidate;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            this.appNameAndIdString = this.getAppNameAndID() + " , _removeAttrOnInvalidate -->" + this._removeAttrOnInvalidate;
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "Constructor", "App name and ID [" + this.appNameAndIdString + "");
        }
    }

    @Override
    public String getId() {
        return this._sessionId;
    }

    @Override
    public boolean isValid() {
        if (!this._isValid && TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            String s = this._isValid + this.appNameAndIdString;
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "isValid", s);
        }
        return this._isValid;
    }

    @Override
    public boolean isNew() {
        return this._isNew;
    }

    @Override
    public void setIsNew(boolean flag) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer(newValueString).append(flag).append(oldValueString).append(this._isNew).append(this.appNameAndIdString);
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "setIsNew", sb.toString());
        }
        this._isNew = flag;
    }

    @Override
    public synchronized void setIsValid(boolean flag) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer(newValueString).append(flag).append(oldValueString).append(this._isValid).append(this.appNameAndIdString);
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "setIsValid", sb.toString());
        }
        this._isValid = flag;
    }

    @Override
    public synchronized void invalidate() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[0], this.appNameAndIdString);
        }
        if (this.invalInProgress) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[0], "Invalidation in Progress");
            }
            return;
        }
        if (!this._isValid) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[0], "isInProcessOfStopping: " + ((MemoryStore)this._store).isInProcessOfStopping());
            }
            if (!((MemoryStore)this._store).isInProcessOfStopping()) {
                throw new IllegalStateException();
            }
        }
        this.invalInProgress = true;
        if (this._smc.isUsingMemory()) {
            this._storeCallback.sessionCacheDiscard(this);
        }
        this._storeCallback.sessionInvalidated(this);
        this._store.removeSession(this._sessionId);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[0], "_removeAttrOnInvalidate = " + this._removeAttrOnInvalidate);
            if (this._attributes != null) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[0], "session _attributes.size() = " + this._attributes.size());
            }
        }
        if (this._attributes != null && this._removeAttrOnInvalidate) {
            Enumeration attrKey = this._attributes.keys();
            while (attrKey.hasMoreElements()) {
                String key = (String)attrKey.nextElement();
                this.removeAttribute(key);
            }
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[0], "session attributes removed");
            }
        }
        this.setIsValid(false);
        this.invalInProgress = false;
        this._attributes = null;
        this._attributeNames.clear();
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[0]);
        }
    }

    @Override
    public void flush() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "flush", "");
        }
    }

    @Override
    public void flush(boolean metadataOnly) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "flush", "" + metadataOnly);
        }
    }

    @Override
    public void setVersion(int version) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer(newValueString).append(version).append(oldValueString).append(this._version).append(this.appNameAndIdString);
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "setVersion", sb.toString());
        }
        this._version = version;
    }

    @Override
    public int getVersion() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            String s = this._version + this.appNameAndIdString;
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "getVersion()", s);
        }
        return this._version;
    }

    @Override
    public final Object getAdaptation() {
        return this._adaptation;
    }

    @Override
    public final Object getAdaptation(int i) {
        if (i == 1) {
            return this._appAdaptation;
        }
        return this._adaptation;
    }

    @Override
    public void setAdaptation(Object adaptation) {
        this._adaptation = adaptation;
    }

    @Override
    public void setAdaptation(Object adaptation, int i) {
        if (i == 1) {
            this._appAdaptation = adaptation;
        } else {
            this._adaptation = adaptation;
        }
    }

    @Override
    public String getContextId() {
        return null;
    }

    @Override
    public void setContextId(String contextID) {
    }

    @Override
    public String getUserName() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            String s = this._userName + this.appNameAndIdString;
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "getUserName", s);
        }
        return this._userName;
    }

    @Override
    public void setUserName(String userName) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer(newValueString).append(userName).append(oldValueString).append(this._userName).append(this.appNameAndIdString);
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "setUserName", sb.toString());
        }
        this._userName = userName;
    }

    @Override
    public long getCreationTime() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            String s = this._creationTime + this.appNameAndIdString;
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "getCreationTime", s);
        }
        return this._creationTime;
    }

    @Override
    public synchronized long getLastAccessedTime() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            String s = this._lastAccessedTime + this.appNameAndIdString;
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "getLastAccessedTime", s);
        }
        return this._lastAccessedTime;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this._maxInactiveInterval;
    }

    @Override
    public void setMaxInactiveInterval(int maxInactiveInterval) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer(newValueString).append(maxInactiveInterval).append(oldValueString).append(this._maxInactiveInterval).append(this.appNameAndIdString);
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "setMaxInactiveInterval", sb.toString());
        }
        this._maxInactiveInterval = maxInactiveInterval <= 0 ? -1 : maxInactiveInterval;
    }

    public void setMaxInactiveIntervalForInvalidateAll(int maxInactiveInterval) {
        if (maxInactiveInterval != 0) {
            this.setMaxInactiveInterval(maxInactiveInterval);
        } else {
            this._maxInactiveInterval = 0;
        }
    }

    @Override
    public long getExpiryTime() {
        return 0L;
    }

    @Override
    public void setExpiryTime(long l) {
    }

    @Override
    public synchronized Object getAttribute(Object name) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            String s = name + this.appNameAndIdString;
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[1], s);
        }
        Object o = this._attributes.get(name);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            if (!SessionManagerConfig.isHideSessionValues()) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[1], o);
            } else {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[1]);
            }
        }
        return o;
    }

    @Override
    public synchronized Object setAttribute(Object name, Object value, Boolean newIsListener) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            StringBuffer sb = new StringBuffer("{").append(name).append(",");
            if (!SessionManagerConfig.isHideSessionValues()) {
                sb.append(value).append(",");
            }
            sb.append(newIsListener).append("} ").append(this.appNameAndIdString);
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[2], sb.toString());
        }
        Object oldValue = this._attributes.put(name, value);
        Boolean oldIsListener = this._attributeNames.put(name, newIsListener);
        this._storeCallback.sessionAttributeSet(this, name, oldValue, oldIsListener, value, newIsListener);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            if (!SessionManagerConfig.isHideSessionValues()) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[2], oldValue);
            } else {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[2]);
            }
        }
        return oldValue;
    }

    @Override
    public synchronized Object removeAttribute(Object name) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            String s = name + this.appNameAndIdString;
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[3], s);
        }
        Object oldValue = this._attributes.remove(name);
        Boolean oldIsBindingListener = (Boolean)this._attributeNames.get(name);
        this._attributeNames.remove(name);
        this._storeCallback.sessionAttributeRemoved(this, name, oldValue, oldIsBindingListener);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            if (!SessionManagerConfig.isHideSessionValues()) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[3], oldValue);
            } else {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[3]);
            }
        }
        return oldValue;
    }

    @Override
    public synchronized Map getAttributes() {
        return null;
    }

    public synchronized Enumeration getAttributeNames() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            String s = this._attributeNames + this.appNameAndIdString;
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "getAttributeNames", s);
        }
        return this._attributeNames.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ArrayList getListenerAttributeNames() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[4], this.appNameAndIdString);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Hashtable hashtable = this._attributeNames;
        synchronized (hashtable) {
            String attributeName2 = null;
            for (String attributeName2 : this._attributeNames.keySet()) {
                if (!this._attributeNames.get(attributeName2).equals(Boolean.TRUE)) continue;
                arrayList.add(attributeName2);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[4], arrayList);
        }
        return arrayList;
    }

    @Override
    public boolean hasAttributeListeners() {
        return false;
    }

    @Override
    public int getAttributeListenerCount() {
        return 0;
    }

    @Override
    public synchronized void setAttributeListenerCount(int attributeListenerCount) {
    }

    @Override
    public synchronized int incrementRefCount() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            int temp = this._refCount + 1;
            StringBuffer sb = new StringBuffer("to ").append(temp).append(" from ").append(this._refCount).append(this.appNameAndIdString);
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "incrementRefCount", sb.toString());
        }
        ++this._refCount;
        return this._refCount;
    }

    @Override
    public synchronized void setRefCount(int i) {
        this._refCount = i;
    }

    @Override
    public int getRefCount() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            String s = this._refCount + this.appNameAndIdString;
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "getRefCount", s);
        }
        return this._refCount;
    }

    @Override
    public synchronized int decrementRefCount() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            int temp = this._refCount - 1;
            StringBuffer sb = new StringBuffer("to ").append(temp).append(" from ").append(this._refCount).append(this.appNameAndIdString);
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "decrementRefCount", sb.toString());
        }
        --this._refCount;
        return this._refCount;
    }

    @Override
    public void setSharingAcrossWebapps(boolean flag) {
    }

    @Override
    public Object getLockContext() {
        return null;
    }

    @Override
    public void setLockContext(Object lockContext) {
    }

    @Override
    public void updateLastAccessTime() {
    }

    @Override
    public synchronized void updateLastAccessTime(long accessTime) {
        this._lastAccessedTime = this._lastAccessedTime == 0L ? accessTime : this._currentAccessTime;
        this._currentAccessTime = accessTime;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[5], "" + accessTime);
        }
    }

    @Override
    public long getCurrentAccessTime() {
        return this._currentAccessTime;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("# ").append(this.getClass().getName()).append(" # \n { ").append("\n _sessionId=").append(this._sessionId).append("\n").append("hashCode : ").append(this.hashCode()).append("\n").append("create time : ").append(new Date(this._creationTime).toString()).append("\n").append("last access : ").append(new Date(this._lastAccessedTime).toString()).append("\n").append("max inactive interval : ").append(this._maxInactiveInterval).append("\n").append("user name : ").append(this._userName).append("\n").append("valid session : ").append(this._isValid).append("\n").append("new session : ").append(this._isNew).append("\n").append("overflowed : ").append(this.isOverflow).append("\n").append("app name : ").append(this._appName).append("\n");
        if (this._store != null) {
            if (SessionManagerConfig.isHideSessionValues()) {
                sb.append("\nAttribute Names=").append(this._attributeNames.keySet());
            } else if (this._attributes != null) {
                sb.append("\nAttributes=").append(this._attributes);
            }
        }
        sb.append("\n _refCount=").append(this._refCount).append("\n } \n");
        return sb.toString();
    }

    @Override
    public void setOverflow() {
        this.isOverflow = true;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "setOverflow", this.appNameAndIdString);
        }
    }

    @Override
    public boolean isOverflow() {
        return this.isOverflow;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public IStoreCallback getStoreCallback() {
        return this._storeCallback;
    }

    public void setStoreCallback(IStoreCallback callback) {
        this._storeCallback = callback;
    }

    @Override
    public IStore getIStore() {
        return this._store;
    }

    public void setIStore(IStore store) {
        this._store = store;
    }

    public void internalInvalidate(boolean timeoutOccurred) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[6], this.appNameAndIdString);
        }
        if (this._isValid) {
            try {
                this._store.setThreadContext();
                this.callInvalidateFromInternalInvalidate();
                if (timeoutOccurred) {
                    this._storeCallback.sessionInvalidatedByTimeout(this);
                }
            }
            finally {
                this._store.unsetThreadContext();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[6]);
        }
    }

    public Map<Object, Object> getSwappableData() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[7], this.appNameAndIdString);
        }
        Hashtable<Object, Object> swapData = new Hashtable<Object, Object>();
        if (this._attributes != null) {
            Enumeration e = this._attributes.keys();
            while (e.hasMoreElements()) {
                Object mykey = e.nextElement();
                if (!(this._attributes.get(mykey) instanceof Serializable)) continue;
                swapData.put(mykey, this._attributes.get(mykey));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[7], swapData);
        }
        return swapData;
    }

    public boolean isInvalInProgress() {
        return this.invalInProgress;
    }

    public String getAppNameAndID() {
        StringBuffer sb = new StringBuffer(" AppName=");
        sb.append(this._appName);
        sb.append("; Id=").append(this._sessionId);
        return sb.toString();
    }

    protected void setAppName(String storeId) {
        this._appName = storeId;
    }

    public String getAppName() {
        return this._appName;
    }

    protected boolean isSwappableData(Object obj) {
        return obj != null && (obj instanceof Serializable || obj instanceof Externalizable);
    }

    protected void callInvalidateFromInternalInvalidate() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "callInvalidateFromInternalInvalidate", "calling invalidate");
        }
        if (this._isValid) {
            this.invalidate();
        }
    }

    @Override
    public Object getAdaptation(Integer protocol) {
        return null;
    }

    @Override
    public Object getCorrelator() {
        return null;
    }

    @Override
    public void setAdaptation(Object adaptation, Integer protocol) {
    }

    @Override
    public void setId(String id) {
        this._sessionId = id;
    }

    class SessionGCount {
        SessionGCount() {
        }

        protected void finalize() throws Throwable {
            try {
                if (MemorySession.this._store != null && MemorySession.this._store.getSessionStatistics() != null) {
                    MemorySession.this._store.getSessionStatistics().incSessionGarbageCollected(System.currentTimeMillis());
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.session.store.memory.MemorySession.finalize", (String)"96", (Object)this);
            }
            super.finalize();
        }
    }
}

