/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.jwt;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.jwt.Builder;
import com.ibm.websphere.security.jwt.InvalidBuilderException;
import com.ibm.websphere.security.jwt.InvalidClaimException;
import com.ibm.websphere.security.jwt.InvalidTokenException;
import com.ibm.websphere.security.jwt.JwtException;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.websphere.security.jwt.KeyException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.security.Key;
import java.util.List;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={JwtBuilder.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"}, name="jwtBuilder")
public class JwtBuilder {
    private Builder builder;
    private final Object initlock = new Object(){
        static final long serialVersionUID = -6733816094838164622L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.websphere.security.jwt.JwtBuilder$1", 1.class, null, null);
        }
    };
    private static final String KEY_JWT_BUILDER_SERVICE = "builder";
    private static AtomicServiceReference<Builder> builderServiceRef;
    static final long serialVersionUID = -8577084715788682369L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JwtBuilder() {
    }

    public JwtBuilder(String builderConfigId) throws InvalidBuilderException {
        this.builder = this.getTheService().create(builderConfigId);
    }

    private Builder getTheService() {
        return (Builder)builderServiceRef.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=Builder.class, name="builder", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.RELUCTANT)
    protected void setBuilder(ServiceReference<Builder> ref) {
        Object object = this.initlock;
        synchronized (object) {
            builderServiceRef.setReference(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetBuilder(ServiceReference<Builder> ref) {
        Object object = this.initlock;
        synchronized (object) {
            builderServiceRef.unsetReference(ref);
        }
    }

    @Activate
    protected void activate(ComponentContext cc) {
        builderServiceRef.activate(cc);
    }

    @Modified
    protected void modify(Map<String, Object> properties) {
    }

    @Deactivate
    protected void deactivate(int reason, ComponentContext cc) {
        builderServiceRef.deactivate(cc);
    }

    public static JwtBuilder create() throws InvalidBuilderException {
        return JwtBuilder.create("defaultJWT");
    }

    public static synchronized JwtBuilder create(String builderConfigId) throws InvalidBuilderException {
        return new JwtBuilder(builderConfigId);
    }

    public JwtBuilder issuer(String issuerUrl) throws InvalidClaimException {
        this.builder = this.builder.issuer(issuerUrl);
        return this;
    }

    public JwtBuilder audience(List<String> newaudiences) throws InvalidClaimException {
        this.builder = this.builder.audience(newaudiences);
        return this;
    }

    public JwtBuilder expirationTime(long exp) throws InvalidClaimException {
        this.builder = this.builder.expirationTime(exp);
        return this;
    }

    public JwtBuilder jwtId(boolean create) {
        this.builder = this.builder.jwtId(create);
        return this;
    }

    public JwtBuilder notBefore(long time_from) throws InvalidClaimException {
        this.builder = this.builder.notBefore(time_from);
        return this;
    }

    public JwtBuilder subject(String username) throws InvalidClaimException {
        this.builder = this.builder.subject(username);
        return this;
    }

    public JwtBuilder signWith(String algorithm, Key key) throws KeyException {
        this.builder = this.builder.signWith(algorithm, key);
        return this;
    }

    public JwtBuilder signWith(String algorithm, String key) throws KeyException {
        this.builder = this.builder.signWith(algorithm, key);
        return this;
    }

    public JwtBuilder encryptWith(String keyManagementAlg, Key keyManagementKey, String contentEncryptionAlg) throws KeyException {
        this.builder = this.builder.encryptWith(keyManagementAlg, keyManagementKey, contentEncryptionAlg);
        return this;
    }

    public JwtBuilder claim(String name, Object value) throws InvalidClaimException {
        this.builder = this.builder.claim(name, value);
        return this;
    }

    public JwtBuilder claim(Map<String, Object> map) throws InvalidClaimException {
        this.builder = this.builder.claim(map);
        return this;
    }

    public JwtBuilder fetch(String name) throws InvalidClaimException {
        this.builder = this.builder.fetch(name);
        return this;
    }

    public JwtBuilder remove(String name) throws InvalidClaimException {
        this.builder = this.builder.remove(name);
        return this;
    }

    public JwtBuilder claimFrom(String jsonOrJwt, String claim) throws InvalidClaimException, InvalidTokenException {
        this.builder = this.builder.claimFrom(jsonOrJwt, claim);
        return this;
    }

    public JwtBuilder claimFrom(String jsonOrJwt) throws InvalidClaimException, InvalidTokenException {
        this.builder = this.builder.claimFrom(jsonOrJwt);
        return this;
    }

    public JwtBuilder claimFrom(JwtToken jwt, String claimName) throws InvalidClaimException, InvalidTokenException {
        this.builder = this.builder.claimFrom(jwt, claimName);
        return this;
    }

    public JwtBuilder claimFrom(JwtToken jwt) throws InvalidTokenException {
        this.builder = this.builder.claimFrom(jwt);
        return this;
    }

    public JwtToken buildJwt() throws JwtException, InvalidBuilderException {
        return this.builder.buildJwt();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.websphere.security.jwt.JwtBuilder", JwtBuilder.class, null, null);
        builderServiceRef = new AtomicServiceReference(KEY_JWT_BUILDER_SERVICE);
    }
}

