/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.items;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.AIStreamKey;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.RemoteQPConsumerKey;
import com.ibm.ws.sib.processor.impl.interfaces.RemoteDispatchableKey;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.AOValue;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.List;

public class AIMessageItem
extends MessageItem {
    private static final TraceComponent tc = SibTr.register(AIMessageItem.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_mt = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSJUMessages");
    private AnycastInputHandler aih;
    private int cachedRedeliveredCount;
    private AIStreamKey key;
    private boolean informedConsumerKeyThatLocked;
    private PersistentTranId rejectTransactionID = null;
    private AOValue restoredTargetAOValue;
    private volatile boolean isReserved;
    private boolean incLockCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AIMessageItem() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIMessageItem");
        }
        AIMessageItem aIMessageItem = this;
        synchronized (aIMessageItem) {
            this.informedConsumerKeyThatLocked = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIMessageItem", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AIMessageItem(JsMessage msg) {
        super(msg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIMessageItem", (Object)msg);
        }
        AIMessageItem aIMessageItem = this;
        synchronized (aIMessageItem) {
            this.informedConsumerKeyThatLocked = false;
            this.cachedRedeliveredCount = msg.getRedeliveredCount();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIMessageItem", (Object)this);
        }
    }

    public synchronized void setRejectTransactionID(PersistentTranId id) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRejectTransactionID", (Object)id);
        }
        this.rejectTransactionID = id;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRejectTransactionID");
        }
    }

    private synchronized boolean isRejectTransactionID(PersistentTranId id) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isRejectTransactionID", (Object)id);
        }
        boolean retVal = false;
        if (this.rejectTransactionID != null) {
            retVal = id.equals((Object)this.rejectTransactionID);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isRejectTransactionID", (Object)retVal);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataSlice> getPersistentData() throws PersistentDataEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData");
        }
        AIMessageItem aIMessageItem = this;
        synchronized (aIMessageItem) {
            if (!this.informedConsumerKeyThatLocked) {
                RemoteDispatchableKey dkey = this.key.getRemoteDispatchableKey();
                RemoteQPConsumerKey ck = null;
                if (dkey instanceof RemoteQPConsumerKey) {
                    ck = (RemoteQPConsumerKey)dkey;
                }
                if (ck != null) {
                    ck.messageLocked(this.key);
                    this.informedConsumerKeyThatLocked = true;
                }
            }
            this.key.clearRemoteDispatchableKey();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
        return super.getPersistentData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(List<DataSlice> dataSlices) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", dataSlices);
        }
        super.restore(dataSlices);
        this.key = new AIStreamKey(this.getMessage().getGuaranteedRemoteGetValueTick());
        ItemStream itemstream = null;
        try {
            itemstream = this.getItemStream();
        }
        catch (SevereMessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.AIMessageItem.restore", (String)"1:249:1.44.1.10", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)((Object)e));
            }
            throw new SIErrorException((Throwable)e);
        }
        BaseDestinationHandler destinationHandler = null;
        PtoPMessageItemStream localisation = (PtoPMessageItemStream)itemstream;
        destinationHandler = localisation.getDestinationHandler();
        SIBUuid8 sourceMEId = this.getMessage().getGuaranteedSourceMessagingEngineUUID();
        SIBUuid12 gatheringUuid = this.getMessage().getGuaranteedGatheringTargetUUID();
        this.aih = destinationHandler.getAnycastInputHandler(sourceMEId, gatheringUuid, true);
        AIMessageItem aIMessageItem = this;
        synchronized (aIMessageItem) {
            this.cachedRedeliveredCount = this.getMessage().getRedeliveredCount();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInfo(AnycastInputHandler aih, AIStreamKey key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setInfo", (Object)new Object[]{aih, key});
        }
        AIMessageItem aIMessageItem = this;
        synchronized (aIMessageItem) {
            this.aih = aih;
            this.key = key;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setInfo");
        }
    }

    public final AIStreamKey getAIStreamKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAIStreamKey");
            SibTr.exit((TraceComponent)tc, (String)"getAIStreamKey", (Object)this.key);
        }
        return this.key;
    }

    @Override
    public final int getStorageStrategy() {
        return 2;
    }

    @Override
    public long getMaximumTimeInStore() {
        long min;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMaximumTimeInStore");
        }
        long originalExpiryTime = super.getMaximumTimeInStore();
        long rejectTime = this.aih.getRCD().getRejectTimeout();
        if (originalExpiryTime == -2L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMaximumTimeInStore", (Object)rejectTime);
            }
            return rejectTime;
        }
        if (rejectTime == -2L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMaximumTimeInStore", (Object)originalExpiryTime);
            }
            return originalExpiryTime;
        }
        long l = min = originalExpiryTime < rejectTime ? originalExpiryTime : rejectTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMaximumTimeInStore", (Object)min);
        }
        return min;
    }

    @Override
    public boolean canExpireSilently() {
        super.canExpireSilently();
        return false;
    }

    @Override
    public void eventExpiryNotification(Transaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventExpiryNotification", (Object)new Object[]{transaction, this.key.getTick()});
        }
        super.eventExpiryNotification(transaction);
        this.setRejectTransactionID(transaction.getPersistentTranId());
        if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
            SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage("REMOTE_MESSAGE_EXPIRED_CWSJU0034", new Object[]{this.getMessage(), this.key.getTick(), this.aih.getDestName(), this.aih.getMessageProcessor().getMessagingEngineUuid(), this.aih.getLocalisationUuid(), this.aih.getGatheringTargetDestUuid()}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventExpiryNotification");
        }
    }

    public void eventPrecommitRemove(Transaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPrecommitRemove", (Object)new Object[]{transaction, this});
        }
        super.eventPrecommitRemove(transaction);
        if (!this.isRejectTransactionID(transaction.getPersistentTranId())) {
            this.aih.accept(this.key, (TransactionCommon)transaction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPrecommitRemove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventPostCommitRemove(Transaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitRemove", (Object)new Object[]{transaction, this});
        }
        super.eventPostCommitRemove(transaction);
        AIMessageItem aIMessageItem = this;
        synchronized (aIMessageItem) {
            if (!this.informedConsumerKeyThatLocked) {
                RemoteDispatchableKey dkey = this.key.getRemoteDispatchableKey();
                RemoteQPConsumerKey ck = null;
                if (dkey instanceof RemoteQPConsumerKey) {
                    ck = (RemoteQPConsumerKey)dkey;
                }
                if (ck != null) {
                    ck.messageLocked(this.key);
                    this.informedConsumerKeyThatLocked = true;
                }
            }
        }
        if (this.isRejectTransactionID(transaction.getPersistentTranId())) {
            this.aih.rolledback(this.key);
        } else if (this.getReliability().compareTo((Object)Reliability.RELIABLE_PERSISTENT) < 0) {
            this.aih.committed(this.key);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitRemove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventLocked() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventLocked");
        }
        AIMessageItem aIMessageItem = this;
        synchronized (aIMessageItem) {
            RemoteDispatchableKey dkey = this.key.getRemoteDispatchableKey();
            RemoteQPConsumerKey ck = null;
            if (dkey instanceof RemoteQPConsumerKey) {
                ck = (RemoteQPConsumerKey)dkey;
            }
            if (ck != null) {
                ck.messageLocked(this.key);
                this.informedConsumerKeyThatLocked = true;
            }
        }
        super.eventLocked();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventLocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventUnlocked() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventUnlocked");
        }
        AIMessageItem aIMessageItem = this;
        synchronized (aIMessageItem) {
            RemoteDispatchableKey dkey = this.key.getRemoteDispatchableKey();
            RemoteQPConsumerKey ck = null;
            if (dkey instanceof RemoteQPConsumerKey) {
                ck = (RemoteQPConsumerKey)dkey;
            }
            if (ck != null) {
                ck.messageUnlocked(this.key);
                this.informedConsumerKeyThatLocked = false;
            }
        }
        this.isReserved = false;
        if (this.incLockCount) {
            this.aih.incrementUnlockCount(this.getMessage().getGuaranteedRemoteGetValueTick());
        }
        this.incLockCount = false;
        super.eventUnlocked();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventUnlocked");
        }
    }

    @Override
    public int guessRedeliveredCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"guessRedeliveredCount");
        }
        int redeliveredCount = super.guessRedeliveredCount() + this.cachedRedeliveredCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"guessRedeliveredCount", (Object)redeliveredCount);
        }
        return redeliveredCount;
    }

    @Override
    public boolean isRemoteGet() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isRemoteGet");
            SibTr.exit((TraceComponent)tc, (String)"isRemoteGet", (Object)Boolean.TRUE);
        }
        return true;
    }

    public void setRestoredTargetAOValue(AOValue restoredTargetAOValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRestoredTargetAOValue", (Object)restoredTargetAOValue);
        }
        this.restoredTargetAOValue = restoredTargetAOValue;
        this.isReserved = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRestoredTargetAOValue");
        }
    }

    public boolean isReserved() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReserved");
            SibTr.exit((TraceComponent)tc, (String)"isReserved", (Object)this.isReserved);
        }
        return this.isReserved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreAOData(long lockId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restoreAOData");
        }
        if (this.restoredTargetAOValue != null) {
            AOValue aOValue = this.restoredTargetAOValue;
            synchronized (aOValue) {
                if (!this.restoredTargetAOValue.isFlushing()) {
                    SIMPTransactionManager txManager = this.aih.getMessageProcessor().getTXManager();
                    ExternalAutoCommitTransaction tran = txManager.createAutoCommitTransaction();
                    try {
                        this.lockItemIfAvailable(lockId);
                        this.persistLock((Transaction)tran);
                        this.restoredTargetAOValue.setPLockId(this.getLockID());
                        this.restoredTargetAOValue.setMsgId(this.getID());
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.AIMessageItem.restoreAOData", (String)"1:574:1.44.1.10", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)e);
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.items.AIMessageItem", "1:579:1.44.1.10"});
                        this.isReserved = false;
                    }
                } else {
                    this.isReserved = false;
                }
            }
            this.restoredTargetAOValue = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restoreAOData");
        }
    }

    @Override
    public void unlockMsg(long lockID, Transaction transaction, boolean incrementUnlock) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockMsg", (Object)new Object[]{lockID, transaction, incrementUnlock});
        }
        this.incLockCount = incrementUnlock;
        super.unlockMsg(lockID, transaction, incrementUnlock);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockMsg");
        }
    }
}

