/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import javax.security.auth.Subject;

public class SecurityContext {
    private static final TraceComponent tc = SibTr.register(SecurityContext.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private AuthUtils authorisationUtils = null;
    private Subject subject = null;
    private String userId = null;
    private String alternateUser = null;
    private String discriminator = null;
    private JsMessage msg = null;

    public SecurityContext(String userId, String discriminator) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SecurityContext", (Object)new Object[]{"userid(" + userId + ")", discriminator});
        }
        this.userId = userId;
        this.discriminator = discriminator;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SecurityContext", (Object)this);
        }
    }

    public SecurityContext(Subject subject, String alternateUser, String discriminator, AuthUtils authorisationUtils) {
        if (tc.isEntryEnabled()) {
            String report = "<null>";
            if (subject != null) {
                report = "subject(" + authorisationUtils.getUserName(subject) + ")";
            }
            SibTr.entry((TraceComponent)tc, (String)"SecurityContext", (Object)new Object[]{report, alternateUser, discriminator, authorisationUtils});
        }
        this.authorisationUtils = authorisationUtils;
        this.subject = subject;
        this.alternateUser = alternateUser;
        this.discriminator = discriminator;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SecurityContext", (Object)this);
        }
    }

    public SecurityContext(JsMessage msg, String alternateUser, String discriminator, AuthUtils authorisationUtils) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SecurityContext", (Object)new Object[]{"Message(" + msg + ")", alternateUser, discriminator});
        }
        this.msg = msg;
        this.authorisationUtils = authorisationUtils;
        this.alternateUser = alternateUser;
        this.discriminator = discriminator;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SecurityContext", (Object)this);
        }
    }

    public String toString() {
        String report = null;
        if (this.isSubjectBased()) {
            if (this.authorisationUtils != null) {
                report = "subject(" + this.authorisationUtils.getUserName(this.subject) + ")";
            }
        } else if (this.isUserIdBased()) {
            report = "id(" + this.userId + ")";
        } else if (this.isMsgBased()) {
            report = "msg(" + this.msg.getSecurityUserid() + ")";
        }
        if (this.alternateUser != null) {
            report = report + ", alt user(" + this.alternateUser + ")";
        }
        if (this.discriminator != null) {
            report = report + ", discriminator(" + this.discriminator + ")";
        }
        return report;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public boolean testDiscriminatorAtCreate() {
        return this.discriminator != null;
    }

    public boolean isSubjectBased() {
        return this.subject != null;
    }

    public boolean isUserIdBased() {
        return this.userId != null;
    }

    public boolean isAlternateUserBased() {
        return this.alternateUser != null;
    }

    public boolean isMsgBased() {
        return this.msg != null;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAlternateUser() {
        return this.alternateUser;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public void setUserId(String string) {
        this.userId = string;
    }

    public void setDiscriminator(String string) {
        this.discriminator = string;
    }

    public JsMessage getMsg() {
        return this.msg;
    }

    public String getUserName(boolean notAlternateUser) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUserName", (Object)new Object[]{new Boolean(notAlternateUser)});
        }
        String userName = null;
        if (!notAlternateUser && this.isAlternateUserBased()) {
            userName = this.alternateUser;
        } else if (this.isSubjectBased()) {
            if (this.authorisationUtils != null) {
                userName = this.authorisationUtils.getUserName(this.subject);
            }
        } else if (this.isUserIdBased()) {
            userName = this.userId;
        } else if (this.isMsgBased()) {
            userName = this.msg.getSecurityUserid();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUserName", (Object)userName);
        }
        return userName;
    }

    public boolean isSIBServerSubject() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSIBServerSubject");
        }
        boolean ispriv = false;
        if (this.isSubjectBased()) {
            if (this.authorisationUtils != null) {
                ispriv = this.authorisationUtils.isSIBServerSubject(this.subject);
            }
        } else if (this.isMsgBased() && this.authorisationUtils != null) {
            ispriv = this.authorisationUtils.sentBySIBServer(this.msg);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSIBServerSubject", (Object)new Boolean(ispriv));
        }
        return ispriv;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: ");
        }
    }
}

