/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.jwt.JwtBuilder;
import com.ibm.websphere.security.jwt.JwtConsumer;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.utils.JsonUtils;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.UserApiConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.utils.OAuthClientUtil;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TAIJwtUtils {
    public static final TraceComponent tc = Tr.register(TAIJwtUtils.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    static final long serialVersionUID = 6866510771679541117L;

    protected TAIJwtUtils() {
    }

    @FFDCIgnore(value={SocialLoginException.class})
    public JwtToken createJwtToken(OAuthClientUtil clientUtil, @Sensitive String idToken, SocialLoginConfig clientConfig, @Sensitive String accessToken, SSLSocketFactory sslSocketFactory) throws SocialLoginException {
        JwtToken jwtToken = null;
        if (idToken == null) {
            UserApiConfig[] userinfoCfg = clientConfig.getUserApis();
            if (userinfoCfg == null || userinfoCfg.length == 0) {
                throw new SocialLoginException("NO_USER_API_CONFIGS_PRESENT", null, new Object[]{clientConfig.getUniqueId()});
            }
            String userinfoApi = userinfoCfg[0].getApi();
            try {
                jwtToken = clientUtil.getUserApiAsJwtToken(userinfoApi, accessToken, sslSocketFactory, false, clientConfig);
            }
            catch (SocialLoginException e) {
                throw new SocialLoginException("FAILED_TO_CREATE_JWT_FROM_USER_API", e, new Object[]{userinfoApi, e.getMessage()});
            }
            catch (Exception e) {
                Object[] objectArray = new Object[5];
                objectArray[0] = clientUtil;
                objectArray[1] = "<sensitive java.lang.String>";
                objectArray[2] = clientConfig;
                objectArray[3] = "<sensitive java.lang.String>";
                objectArray[4] = sslSocketFactory;
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.social.tai.TAIJwtUtils", (String)"55", (Object)this, (Object[])objectArray);
                throw new SocialLoginException("FAILED_TO_CREATE_JWT_FROM_USER_API", e, new Object[]{userinfoApi, e.getMessage()});
            }
        } else {
            jwtToken = this.createJwtTokenFromIdToken(idToken, clientConfig.getUniqueId());
        }
        return jwtToken;
    }

    /*
     * WARNING - void declaration
     */
    public JwtToken createJwtTokenFromIdToken(@Sensitive String idToken, String jwtConfigId) throws SocialLoginException {
        try {
            return JwtConsumer.create((String)jwtConfigId).createJwt(idToken);
        }
        catch (Exception exception) {
            void e;
            Object[] objectArray = new Object[2];
            objectArray[0] = "<sensitive java.lang.String>";
            objectArray[1] = jwtConfigId;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.tai.TAIJwtUtils", (String)"69", (Object)this, (Object[])objectArray);
            throw new SocialLoginException("FAILED_TO_CREATE_JWT_FROM_ID_TOKEN", (Exception)e, new Object[]{jwtConfigId, e.getMessage()});
        }
    }

    public JwtToken createJwtTokenFromJson(String userApiResponse, SocialLoginConfig clientConfig, boolean isOidc) throws Exception {
        Map<String, Object> claims = this.handleJwtClaims(userApiResponse, clientConfig, isOidc);
        JwtBuilder jwtBuilder = JwtBuilder.create((String)clientConfig.getJwtRef()).claim(claims);
        return jwtBuilder.buildJwt();
    }

    public Map<String, Object> handleJwtClaims(String jsonoridtoken, SocialLoginConfig clientConfig, boolean isOidc) throws Exception {
        Map claimsMap = null;
        if (isOidc) {
            String decodedPayload;
            String payload = JsonUtils.getPayload((String)jsonoridtoken);
            if (payload != null && (decodedPayload = JsonUtils.decodeFromBase64String((String)payload)) != null) {
                claimsMap = JsonUtils.claimsFromJsonObject((String)decodedPayload);
            }
        } else {
            claimsMap = JsonUtils.claimsFromJsonObject((String)jsonoridtoken);
        }
        return this.handleJwtClaimsMap(claimsMap, clientConfig, isOidc);
    }

    protected Map<String, Object> handleJwtClaimsMap(Map claimsMap, SocialLoginConfig clientConfig, boolean isOidc) {
        HashMap<String, Object> claimsToCopyMap = new HashMap<String, Object>();
        if (claimsMap != null && !claimsMap.isEmpty()) {
            String[] claimsToCopy = clientConfig.getJwtClaims();
            if (claimsToCopy != null && claimsToCopy.length > 0) {
                for (String claim : claimsToCopy) {
                    Object v = claimsMap.get(claim);
                    if (v == null) continue;
                    claimsToCopyMap.put(claim, v);
                }
            } else if (isOidc) {
                String subClaim = clientConfig.getUserNameAttribute();
                Object subClaimValue = claimsMap.get(subClaim);
                if (subClaim != null && subClaimValue != null) {
                    claimsToCopyMap.put(subClaim, subClaimValue);
                }
            } else {
                claimsMap = this.handleIssuerClaim(claimsMap);
                claimsToCopyMap.putAll(claimsMap);
            }
        }
        return claimsToCopyMap;
    }

    private Map handleIssuerClaim(Map claimsMap) {
        if (claimsMap != null && !claimsMap.isEmpty() && claimsMap.containsKey("iss")) {
            claimsMap.remove("iss");
        }
        return claimsMap;
    }
}

