/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.extension;

import io.smallrye.reactive.messaging.DefaultMediatorConfiguration;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.inject.spi.Bean;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Outgoing;

class CollectedMediatorMetadata {
    private final List<MediatorConfiguration> mediators = new ArrayList<MediatorConfiguration>();

    CollectedMediatorMetadata() {
    }

    void add(Method method, Bean<?> bean) {
        this.mediators.add(this.createMediatorConfiguration(method, bean));
    }

    private MediatorConfiguration createMediatorConfiguration(Method met, Bean<?> bean) {
        DefaultMediatorConfiguration configuration = new DefaultMediatorConfiguration(met, bean);
        configuration.compute(met.getAnnotation(Incoming.class), met.getAnnotation(Outgoing.class));
        return configuration;
    }

    void addAll(Collection<? extends MediatorConfiguration> mediators) {
        this.mediators.addAll(mediators);
    }

    List<MediatorConfiguration> mediators() {
        return this.mediators;
    }
}

