/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.PublisherDecorator;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class MicrometerDecorator
implements PublisherDecorator {
    @Inject
    @ConfigProperty(name="smallrye.messaging.metrics.micrometer.enabled", defaultValue="true")
    boolean enabled;

    @Override
    public Multi<? extends Message<?>> decorate(Multi<? extends Message<?>> publisher, String channelName, boolean isConnector) {
        if (this.enabled) {
            return publisher.invoke(this.incrementCount(channelName));
        }
        return publisher;
    }

    private Consumer<Message<?>> incrementCount(String channelName) {
        Counter counter = Metrics.counter((String)"mp.messaging.message.count", (String[])new String[]{"channel", channelName});
        return m -> counter.increment();
    }
}

