/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver.internal.kernel;

import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.repository.resolver.internal.kernel.KernelResolverEsa;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class CapabilityMatching {
    public static List<ProvisioningFeatureDefinition> findFeaturesSatisfyingCapability(ProvisioningFeatureDefinition feature, Collection<? extends ProvisioningFeatureDefinition> features) {
        String capabilityString = feature instanceof KernelResolverEsa ? ((KernelResolverEsa)feature).getResource().getProvisionCapability() : feature.getHeader("IBM-Provision-Capability");
        return CapabilityMatching.matchCapability(capabilityString, features).getFeatures();
    }

    public static CapabilityMatchingResult matchCapability(String capabilityString, Collection<? extends ProvisioningFeatureDefinition> features) {
        if (capabilityString == null) {
            CapabilityMatchingResult result = new CapabilityMatchingResult();
            result.capabilitySatisfied = true;
            result.features = Collections.emptyList();
            return result;
        }
        CapabilityMatchingResult result = new CapabilityMatchingResult();
        result.capabilitySatisfied = true;
        result.features = new ArrayList();
        List<FeatureCapabilityInfo> capabilityMaps = CapabilityMatching.createCapabilityMaps(features);
        for (Filter filter : CapabilityMatching.createFilterList(capabilityString)) {
            boolean matched = false;
            for (FeatureCapabilityInfo capabilityInfo : capabilityMaps) {
                if (!filter.matches(capabilityInfo.capabilities)) continue;
                matched = true;
                result.getFeatures().add(capabilityInfo.feature);
                break;
            }
            if (matched) continue;
            result.capabilitySatisfied = false;
        }
        return result;
    }

    private static List<FeatureCapabilityInfo> createCapabilityMaps(Collection<? extends ProvisioningFeatureDefinition> features) {
        ArrayList<FeatureCapabilityInfo> result = new ArrayList<FeatureCapabilityInfo>();
        for (ProvisioningFeatureDefinition provisioningFeatureDefinition : features) {
            FeatureCapabilityInfo capabilityInfo = new FeatureCapabilityInfo();
            capabilityInfo.feature = provisioningFeatureDefinition;
            capabilityInfo.capabilities = new HashMap<String, String>();
            capabilityInfo.capabilities.put("osgi.identity", provisioningFeatureDefinition.getSymbolicName());
            capabilityInfo.capabilities.put("type", "osgi.subsystem.feature");
            result.add(capabilityInfo);
        }
        return result;
    }

    private static List<Filter> createFilterList(String capabilityHeader) {
        List metadatas = ManifestHeaderProcessor.parseCapabilityString((String)capabilityHeader);
        ArrayList<Filter> result = new ArrayList<Filter>();
        for (ManifestHeaderProcessor.GenericMetadata metadata : metadatas) {
            String filterString = (String)metadata.getDirectives().get("filter");
            if (!"osgi.identity".equals(metadata.getNamespace()) || filterString == null) continue;
            try {
                result.add(FrameworkUtil.createFilter((String)filterString));
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException("invalid provisionCapabiliy requirement: " + filterString, e);
            }
        }
        return result;
    }

    public static class CapabilityMatchingResult {
        private List<ProvisioningFeatureDefinition> features;
        private boolean capabilitySatisfied;

        public boolean isCapabilitySatisfied() {
            return this.capabilitySatisfied;
        }

        public List<ProvisioningFeatureDefinition> getFeatures() {
            return this.features;
        }
    }

    private static class FeatureCapabilityInfo {
        ProvisioningFeatureDefinition feature;
        Map<String, String> capabilities;

        private FeatureCapabilityInfo() {
        }
    }
}

