/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.client.LibertyCustomizeBindingOutEndingInterceptor;
import com.ibm.ws.jaxws.client.LibertyCustomizeBindingOutInterceptor;
import com.ibm.ws.jaxws.client.LibertyWebServiceClientInInterceptor;
import com.ibm.ws.jaxws.metadata.ConfigProperties;
import com.ibm.ws.jaxws.metadata.PortComponentRefInfo;
import com.ibm.ws.jaxws.metadata.WebServiceFeatureInfo;
import com.ibm.ws.jaxws.metadata.WebServiceRefInfo;
import com.ibm.ws.jaxws.security.JaxWsSecurityConfigurationService;
import com.ibm.ws.jaxws23.client.security.LibertyJaxWsClientSecurityOutInterceptor;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.cxf.jaxws.ServiceImpl;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyServiceImpl
extends ServiceImpl {
    private static final TraceComponent tc = Tr.register(LibertyServiceImpl.class, null, null);
    private static final Map<String, String> servicePidToPropertyPrefixMap = new HashMap<String, String>();
    private final WebServiceRefInfo wsrInfo;
    private final JaxWsSecurityConfigurationService securityConfigService;
    private final Map<QName, Set<ConfigProperties>> servicePropertiesMap = new HashMap<QName, Set<ConfigProperties>>();
    private static boolean issuedBetaMessage;
    static final long serialVersionUID = -4033028438282755436L;

    /*
     * WARNING - void declaration
     */
    public LibertyServiceImpl(JaxWsSecurityConfigurationService securityConfigService, WebServiceRefInfo wsrInfo, Bus bus, URL url, QName name, Class<?> clazz, WebServiceFeature ... features) {
        super(bus, url, name, clazz, features);
        this.securityConfigService = securityConfigService;
        this.wsrInfo = wsrInfo;
        if (null != wsrInfo) {
            try {
                this.configureClientProperties();
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.jaxws.client.LibertyServiceImpl", (String)"110", (Object)((Object)this), (Object[])new Object[]{securityConfigService, wsrInfo, bus, url, name, clazz, features});
                throw new Fault((Throwable)e);
            }
        }
    }

    protected <T> T createPort(QName portName, EndpointReferenceType epr, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        if (features == null || features.length == 0) {
            features = this.getWebServiceFeaturesOnPortComponentRef(serviceEndpointInterface);
        }
        Object clientProxy = super.createPort(portName, epr, serviceEndpointInterface, features);
        Client client = ClientProxy.getClient((Object)clientProxy);
        this.configureCustomizeBinding(client, portName);
        if (!ProductInfo.getBetaEdition()) {
            return (T)clientProxy;
        }
        if (!issuedBetaMessage) {
            Tr.info((TraceComponent)tc, (String)("BETA: A webServiceClient configuration beta method has been invoked for the class " + ((Object)((Object)this)).getClass().getName() + " for the first time."), (Object[])new Object[0]);
            issuedBetaMessage = !issuedBetaMessage;
        }
        this.configureWebServiceClientProperties(client);
        return (T)clientProxy;
    }

    public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
        DispatchImpl dispatch = (DispatchImpl)super.createDispatch(portName, type, context, mode, features);
        Client client = dispatch.getClient();
        this.configureCustomizeBinding(client, portName);
        if (!ProductInfo.getBetaEdition()) {
            return dispatch;
        }
        if (!issuedBetaMessage) {
            Tr.info((TraceComponent)tc, (String)("BETA: A webServiceClient configuration beta method has been invoked for the class " + ((Object)((Object)this)).getClass().getName() + " for the first time."), (Object[])new Object[0]);
            issuedBetaMessage = !issuedBetaMessage;
        }
        this.configureWebServiceClientProperties(client);
        return dispatch;
    }

    private void configureWebServiceClientProperties(Client client) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Adding the LibertyWebServiceClintInInterceptor ", (Object[])new Object[0]);
        }
        client.getInInterceptors().add(new LibertyWebServiceClientInInterceptor());
    }

    protected void configureCustomizeBinding(Client client, QName portName) {
        Map requestContext = client.getRequestContext();
        if (null != requestContext && null != this.wsrInfo) {
            LoggingFeature loggingFeature;
            Collection featureList;
            Bus bus;
            Map<String, String> portProps;
            PortComponentRefInfo portRefInfo = this.wsrInfo.getPortComponentRefInfo(portName);
            Map<String, String> wsrProps = this.wsrInfo.getProperties();
            Map<String, String> map = portProps = null != portRefInfo ? portRefInfo.getProperties() : null;
            if (null != wsrProps) {
                requestContext.putAll(wsrProps);
            }
            if (null != portProps) {
                requestContext.putAll(portProps);
            }
            if (null != wsrProps && Boolean.valueOf(wsrProps.get("enableLoggingInOutInterceptor")).booleanValue() && (bus = this.getBus()) != null && !(featureList = bus.getFeatures()).contains(LoggingFeature.class) && !featureList.contains(loggingFeature = new LoggingFeature())) {
                loggingFeature.setPrettyLogging(true);
                loggingFeature.initialize(bus);
                featureList.add(loggingFeature);
                bus.setFeatures(featureList);
            }
        }
        Set<ConfigProperties> configPropsSet = this.servicePropertiesMap.get(portName);
        client.getOutInterceptors().add(new LibertyCustomizeBindingOutInterceptor(this.wsrInfo, this.securityConfigService, configPropsSet));
        client.getOutInterceptors().add(new LibertyJaxWsClientSecurityOutInterceptor(this.wsrInfo, this.securityConfigService, configPropsSet, client.getEndpoint().getEndpointInfo()));
        client.getOutInterceptors().add(new LibertyCustomizeBindingOutEndingInterceptor(this.wsrInfo));
    }

    private WebServiceFeature[] getWebServiceFeaturesOnPortComponentRef(Class serviceEndpointInterface) {
        WebServiceFeature[] returnArray = new WebServiceFeature[]{};
        if (serviceEndpointInterface != null && this.wsrInfo != null) {
            String seiName = serviceEndpointInterface.getName();
            PortComponentRefInfo pcr = this.wsrInfo.getPortComponentRefInfo(seiName);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SEI name = " + seiName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("PortComponentRefInfo found = " + pcr), (Object[])new Object[0]);
            }
            if (pcr != null) {
                List<WebServiceFeatureInfo> featureInfoList = pcr.getWebServiceFeatureInfos();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("List of WebServiceFeatureInfo from PortComponentRefInfo = " + featureInfoList), (Object[])new Object[0]);
                }
                if (!featureInfoList.isEmpty()) {
                    returnArray = new WebServiceFeature[featureInfoList.size()];
                    for (int i = 0; i < featureInfoList.size(); ++i) {
                        WebServiceFeature wsf;
                        WebServiceFeatureInfo featureInfo = featureInfoList.get(i);
                        returnArray[i] = wsf = featureInfo.getWebServiceFeature();
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Added WebServiceFeature " + wsf), (Object[])new Object[0]);
                    }
                }
            }
        }
        return returnArray;
    }

    private void configureClientProperties() throws IOException {
        Map<String, String> serviceRefProps = this.wsrInfo.getProperties();
        Iterator iterator = this.getPorts();
        while (null != iterator && iterator.hasNext()) {
            Map<String, String> portProps;
            QName portQName = (QName)iterator.next();
            PortComponentRefInfo portInfo = this.wsrInfo.getPortComponentRefInfo(portQName);
            Map<String, String> map = portProps = null != portInfo ? portInfo.getProperties() : null;
            if (null == serviceRefProps && null == portProps) continue;
            this.prepareProperties(portQName, serviceRefProps, portProps);
        }
    }

    private void prepareProperties(QName portQName, Map<String, String> serviceRefProps, Map<String, String> portProps) throws IOException {
        HashMap<String, String> allProperties = new HashMap<String, String>();
        if (null != serviceRefProps) {
            allProperties.putAll(serviceRefProps);
        }
        if (null != portProps) {
            allProperties.putAll(portProps);
        }
        for (Map.Entry<String, String> entry : servicePidToPropertyPrefixMap.entrySet()) {
            String serviceFactoryPid = entry.getKey();
            String prefix = entry.getValue();
            Map<String, String> extractProps = this.extract(prefix, allProperties);
            ConfigProperties configProps = new ConfigProperties(serviceFactoryPid, extractProps);
            Set<ConfigProperties> configSet = this.servicePropertiesMap.get(portQName);
            if (null == configSet) {
                configSet = new HashSet<ConfigProperties>();
                this.servicePropertiesMap.put(portQName, configSet);
            }
            if (configSet.contains(configProps)) {
                configSet.remove(configProps);
                configSet.add(configProps);
                continue;
            }
            configSet.add(configProps);
        }
    }

    protected Map<String, String> extract(String propertyPrefix, Map<String, String> properties, boolean removeProps) {
        if (null == properties || properties.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> extractProps = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> propIter = properties.entrySet().iterator();
        while (propIter.hasNext()) {
            Map.Entry<String, String> propEntry = propIter.next();
            if (null == propEntry.getKey() || !propEntry.getKey().startsWith(propertyPrefix)) continue;
            String propKey = propEntry.getKey().substring(propertyPrefix.length());
            extractProps.put(propKey, propEntry.getValue());
            if (!removeProps) continue;
            propIter.remove();
        }
        return extractProps;
    }

    protected Map<String, String> extract(String propertyPrefix, Map<String, String> properties) {
        return this.extract(propertyPrefix, properties, true);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        servicePidToPropertyPrefixMap.put("org.apache.cxf.http.conduits", "http.conduit.");
        issuedBetaMessage = false;
    }
}

