/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import jakarta.annotation.ParametersAreNonnullByDefault;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.shredzone.acme4j.Identifier;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Order;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.connector.Resource;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.toolbox.JSON;
import org.shredzone.acme4j.toolbox.JSONBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class OrderBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OrderBuilder.class);
    private final Login login;
    private final Set<Identifier> identifierSet = new LinkedHashSet<Identifier>();
    private Instant notBefore;
    private Instant notAfter;
    private boolean recurrent;
    private Instant recurrentStart;
    private Instant recurrentEnd;
    private Duration recurrentValidity;
    private Duration recurrentPredate;
    private boolean recurrentGet;

    protected OrderBuilder(Login login) {
        this.login = login;
    }

    public OrderBuilder domain(String domain) {
        return this.identifier(Identifier.dns(domain));
    }

    public OrderBuilder domains(String ... domains) {
        for (String domain : Objects.requireNonNull(domains, "domains")) {
            this.domain(domain);
        }
        return this;
    }

    public OrderBuilder domains(Collection<String> domains) {
        Objects.requireNonNull(domains, "domains").forEach(this::domain);
        return this;
    }

    public OrderBuilder identifier(Identifier identifier) {
        this.identifierSet.add(Objects.requireNonNull(identifier, "identifier"));
        return this;
    }

    public OrderBuilder identifiers(Collection<Identifier> identifiers) {
        Objects.requireNonNull(identifiers, "identifiers").forEach(this::identifier);
        return this;
    }

    public OrderBuilder notBefore(Instant notBefore) {
        if (this.recurrent) {
            throw new IllegalArgumentException("cannot combine notBefore with recurrent");
        }
        this.notBefore = Objects.requireNonNull(notBefore, "notBefore");
        return this;
    }

    public OrderBuilder notAfter(Instant notAfter) {
        if (this.recurrent) {
            throw new IllegalArgumentException("cannot combine notAfter with recurrent");
        }
        this.notAfter = Objects.requireNonNull(notAfter, "notAfter");
        return this;
    }

    public OrderBuilder recurrent() {
        if (this.notBefore != null || this.notAfter != null) {
            throw new IllegalArgumentException("cannot combine notBefore/notAfter with recurrent");
        }
        this.recurrent = true;
        return this;
    }

    public OrderBuilder recurrentStart(Instant start) {
        this.recurrent();
        this.recurrentStart = Objects.requireNonNull(start, "start");
        return this;
    }

    public OrderBuilder recurrentEnd(Instant end) {
        this.recurrent();
        this.recurrentEnd = Objects.requireNonNull(end, "end");
        return this;
    }

    public OrderBuilder recurrentCertificateValidity(Duration duration) {
        this.recurrent();
        this.recurrentValidity = Objects.requireNonNull(duration, "duration");
        return this;
    }

    public OrderBuilder recurrentCertificatePredate(Duration duration) {
        this.recurrent();
        this.recurrentPredate = Objects.requireNonNull(duration, "duration");
        return this;
    }

    public OrderBuilder recurrentEnableGet() {
        this.recurrent();
        this.recurrentGet = true;
        return this;
    }

    public Order create() throws AcmeException {
        if (this.identifierSet.isEmpty()) {
            throw new IllegalArgumentException("At least one identifer is required");
        }
        Session session = this.login.getSession();
        if (this.recurrent && !session.getMetadata().isStarEnabled()) {
            throw new AcmeException("CA does not support short-term automatic renewals");
        }
        LOG.debug("create");
        try (Connection conn = session.connect();){
            JSONBuilder claims = new JSONBuilder();
            claims.array("identifiers", this.identifierSet.stream().map(Identifier::toMap).collect(Collectors.toList()));
            if (this.notBefore != null) {
                claims.put("notBefore", this.notBefore);
            }
            if (this.notAfter != null) {
                claims.put("notAfter", this.notAfter);
            }
            if (this.recurrent) {
                claims.put("recurrent", true);
                if (this.recurrentStart != null) {
                    claims.put("recurrent-start-date", this.recurrentStart);
                }
                if (this.recurrentStart != null) {
                    claims.put("recurrent-end-date", this.recurrentEnd);
                }
                if (this.recurrentValidity != null) {
                    claims.put("recurrent-certificate-validity", this.recurrentValidity);
                }
                if (this.recurrentPredate != null) {
                    claims.put("recurrent-certificate-predate", this.recurrentPredate);
                }
                if (this.recurrentGet) {
                    claims.put("recurrent-certificate-get", this.recurrentGet);
                }
            }
            conn.sendSignedRequest(session.resourceUrl(Resource.NEW_ORDER), claims, this.login);
            URL orderLocation = conn.getLocation();
            if (orderLocation == null) {
                throw new AcmeProtocolException("Server did not provide an order location");
            }
            Order order = new Order(this.login, orderLocation);
            JSON json = conn.readJsonResponse();
            if (json != null) {
                order.setJSON(json);
            }
            Order order2 = order;
            return order2;
        }
    }
}

