/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.acme.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.acme.AcmeCaException;
import com.ibm.ws.security.acme.internal.AcmeClient;
import com.ibm.ws.security.acme.internal.AcmeConfig;
import com.ibm.wsspi.kernel.service.utils.DictionaryUtils;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"com.ibm.ws.security.acme.config"}, service={}, property={"service.vendor=IBM"})
public class AcmeConfigService {
    private static final TraceComponent tc = Tr.register(AcmeConfigService.class, (String)"ACMECA", (String)"com.ibm.ws.security.acme.resources.AcmeMessages");
    @Activate
    private BundleContext bundleContext;
    private ServiceRegistration<AcmeConfigService> serviceRegistration;
    private static ThreadLocal<AcmeConfig> threadLocalAcmeConfig = new ThreadLocal();
    private final Object syncObject = new Object();
    static final long serialVersionUID = 7377895743051208814L;

    @Activate
    @FFDCIgnore(value={AcmeCaException.class})
    public void activate(Map<String, Object> properties) {
        try {
            this.initialize(properties);
            this.registerService(properties);
        }
        catch (AcmeCaException e) {
            Tr.error((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    @Deactivate
    public void deactivate(int reason) {
        this.unregisterService();
    }

    public static AcmeConfig getThreadLocalAcmeConfig() {
        return threadLocalAcmeConfig.get();
    }

    @Modified
    @FFDCIgnore(value={AcmeCaException.class})
    public void modified(Map<String, Object> properties) {
        try {
            this.initialize(properties);
            if (!this.registerService(properties)) {
                this.serviceRegistration.setProperties(DictionaryUtils.mapToDictionary(properties));
            }
        }
        catch (AcmeCaException e) {
            Tr.error((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Map<String, Object> properties) throws AcmeCaException {
        AcmeConfig acmeConfig = new AcmeConfig(properties, true);
        AcmeClient acmeClient = new AcmeClient(acmeConfig);
        try {
            threadLocalAcmeConfig.set(acmeConfig);
            acmeClient.fetchCertificate(true);
        }
        finally {
            threadLocalAcmeConfig.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerService(Map<String, Object> properties) {
        boolean registered = false;
        Object object = this.syncObject;
        synchronized (object) {
            if (this.serviceRegistration == null) {
                this.serviceRegistration = this.bundleContext.registerService(AcmeConfigService.class, (Object)this, DictionaryUtils.mapToDictionary(properties));
                registered = true;
            }
        }
        return registered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterService() {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.serviceRegistration != null) {
                try {
                    this.serviceRegistration.unregister();
                    this.serviceRegistration = null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.security.acme.internal.AcmeConfigService", (String)"166", (Object)this, (Object[])new Object[0]);
                }
            }
        }
    }
}

