/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.pmi.basic;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.pmi.SipMessagePMIEntry;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import java.util.HashMap;
import java.util.Map;

public class SessionsCounter {
    private static final transient LogMgr c_logger = Log.get(SessionsCounter.class);
    private static final String IN = "Inbound ";
    private static final String OUT = "Outbound ";
    private static final String REQ = " Request";
    private static final String RES = " Response";
    private static final String OTHER_METHOD = "OTHER_METHOD";
    private static final int OTHER_CODE = 0;
    private long _sipAppSessions = 0L;
    private long _sipSessions = 0L;
    private Object _sipSessionsSynchronizer = new Object();
    private Object _sipAppSessionsSynchronizer = new Object();
    private Map<String, SipMessagePMIEntry> _inReqTable = new HashMap<String, SipMessagePMIEntry>();
    private Map<String, SipMessagePMIEntry> _outReqTable = new HashMap<String, SipMessagePMIEntry>();
    private Map<String, SipMessagePMIEntry> _inResTable = new HashMap<String, SipMessagePMIEntry>();
    private Map<String, SipMessagePMIEntry> _outResTable = new HashMap<String, SipMessagePMIEntry>();
    private Map<Integer, SipMessagePMIEntry> _messageTable = new HashMap<Integer, SipMessagePMIEntry>();
    private int _tracePMIModulus = -1;
    private long _lastSipSessionCountPrinted = 0L;
    private long _lastAppSessionCountPrinted = 0L;
    private String[] _responseCodes = new String[1000];

    public SessionsCounter() {
        this.readConfigSettings();
        this.initRequestTables();
        this.initResponseTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sipAppSessionIncrement() {
        Object object = this._sipAppSessionsSynchronizer;
        synchronized (object) {
            ++this._sipAppSessions;
        }
        this.traceAppSessionCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sipAppSessionDecrement() {
        Object object = this._sipAppSessionsSynchronizer;
        synchronized (object) {
            --this._sipAppSessions;
        }
        this.traceAppSessionCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sipSessionIncrement() {
        Object object = this._sipSessionsSynchronizer;
        synchronized (object) {
            ++this._sipSessions;
        }
        this.traceSipSessionsCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sipSessionDecrement() {
        Object object = this._sipSessionsSynchronizer;
        synchronized (object) {
            --this._sipSessions;
        }
        this.traceSipSessionsCount();
    }

    public void inboundRequest(String method) {
        this.updateRequestTable(this._inReqTable, method);
    }

    public void outboundRequest(String method) {
        this.updateRequestTable(this._outReqTable, method);
    }

    private void updateRequestTable(Map<String, SipMessagePMIEntry> requestTable, String method) {
        SipMessagePMIEntry entry = requestTable.get(method);
        if (entry == null) {
            entry = requestTable.get(OTHER_METHOD);
        }
        entry.increment();
        this.traceCounter(entry.getDescription(), entry.getCounter());
    }

    public void inboundResponse(int code) {
        this.updateResponseTable(this._inResTable, code, IN);
    }

    public void outboundResponse(int code) {
        this.updateResponseTable(this._outResTable, code, OUT);
    }

    public void updateCounters() {
        for (SipMessagePMIEntry element : this._messageTable.values()) {
            if (element == null) continue;
            element.update();
        }
    }

    private void updateResponseTable(Map<String, SipMessagePMIEntry> responseTable, int code, String direction) {
        String key = this.getResponseCode(code);
        SipMessagePMIEntry entry = responseTable.get(key);
        if (entry == null) {
            entry = responseTable.get(this.getResponseCode(0));
        }
        entry.increment();
        this.traceCounter(entry.getDescription(), entry.getCounter());
    }

    private String getResponseCode(int code) {
        String respCode = this._responseCodes[code];
        if (respCode == null) {
            this._responseCodes[code] = respCode = Integer.toString(code);
        }
        return respCode;
    }

    private void initRequestTables() {
        this.initReqEntry(OTHER_METHOD, 60, 80);
        this.initReqEntry("REGISTER", 61, 81);
        this.initReqEntry("INVITE", 62, 82);
        this.initReqEntry("ACK", 63, 83);
        this.initReqEntry("OPTIONS", 64, 84);
        this.initReqEntry("BYE", 65, 85);
        this.initReqEntry("CANCEL", 66, 86);
        this.initReqEntry("PRACK", 67, 87);
        this.initReqEntry("INFO", 68, 88);
        this.initReqEntry("SUBSCRIBE", 69, 89);
        this.initReqEntry("NOTIFY", 70, 90);
        this.initReqEntry("MESSAGE", 71, 91);
        this.initReqEntry("PUBLISH", 72, 92);
        this.initReqEntry("REFER", 73, 93);
        this.initReqEntry("UPDATE", 74, 94);
    }

    private void initEntry(Map<String, SipMessagePMIEntry> table, String key, int statisticId, String desc) {
        SipMessagePMIEntry entry = new SipMessagePMIEntry(statisticId, desc);
        table.put(key, entry);
        this._messageTable.put(statisticId, entry);
    }

    private void initResponseTables() {
        this.initResEntry(0, 1000, 2000);
        this.initResEntry(100, 1100, 2100);
        this.initResEntry(180, 1180, 2180);
        this.initResEntry(181, 1181, 2181);
        this.initResEntry(182, 1182, 2182);
        this.initResEntry(183, 1183, 2183);
        this.initResEntry(200, 1200, 2200);
        this.initResEntry(202, 1202, 2202);
        this.initResEntry(204, 1204, 2204);
        this.initResEntry(300, 1300, 2300);
        this.initResEntry(301, 1301, 2301);
        this.initResEntry(302, 1302, 2302);
        this.initResEntry(305, 1305, 2305);
        this.initResEntry(380, 1380, 2380);
        this.initResEntry(400, 1400, 2400);
        this.initResEntry(401, 1401, 2401);
        this.initResEntry(402, 1402, 2402);
        this.initResEntry(403, 1403, 2403);
        this.initResEntry(404, 1404, 2404);
        this.initResEntry(405, 1405, 2405);
        this.initResEntry(406, 1406, 2406);
        this.initResEntry(407, 1407, 2407);
        this.initResEntry(408, 1408, 2408);
        this.initResEntry(409, 1409, 2409);
        this.initResEntry(410, 1410, 2410);
        this.initResEntry(412, 1412, 2412);
        this.initResEntry(413, 1413, 2413);
        this.initResEntry(414, 1414, 2414);
        this.initResEntry(415, 1415, 2415);
        this.initResEntry(416, 1416, 2416);
        this.initResEntry(417, 1417, 2417);
        this.initResEntry(420, 1420, 2420);
        this.initResEntry(421, 1421, 2421);
        this.initResEntry(422, 1422, 2422);
        this.initResEntry(423, 1423, 2423);
        this.initResEntry(424, 1424, 2424);
        this.initResEntry(428, 1428, 2428);
        this.initResEntry(429, 1429, 2429);
        this.initResEntry(433, 1433, 2433);
        this.initResEntry(436, 1436, 2436);
        this.initResEntry(437, 1437, 2437);
        this.initResEntry(438, 1438, 2438);
        this.initResEntry(480, 1480, 2480);
        this.initResEntry(481, 1481, 2481);
        this.initResEntry(482, 1482, 2482);
        this.initResEntry(483, 1483, 2483);
        this.initResEntry(484, 1484, 2484);
        this.initResEntry(485, 1485, 2485);
        this.initResEntry(486, 1486, 2486);
        this.initResEntry(487, 1487, 2487);
        this.initResEntry(488, 1488, 2488);
        this.initResEntry(489, 1489, 2489);
        this.initResEntry(491, 1491, 2491);
        this.initResEntry(493, 1493, 2493);
        this.initResEntry(494, 1494, 2494);
        this.initResEntry(500, 1500, 2500);
        this.initResEntry(501, 1501, 2501);
        this.initResEntry(502, 1502, 2502);
        this.initResEntry(503, 1503, 2503);
        this.initResEntry(504, 1504, 2504);
        this.initResEntry(505, 1505, 2505);
        this.initResEntry(513, 1513, 2513);
        this.initResEntry(600, 1600, 2600);
        this.initResEntry(603, 1603, 2603);
        this.initResEntry(604, 1604, 2604);
        this.initResEntry(606, 1606, 2606);
    }

    private void initResEntry(int code, int statisticInId, int statisticOutId) {
        this.initEntry(this._inResTable, this.getResponseCode(code), statisticInId, IN + code + RES);
        this.initEntry(this._outResTable, this.getResponseCode(code), statisticOutId, OUT + code + RES);
    }

    private void initReqEntry(String method, int statisticInId, int statisticOutId) {
        this.initEntry(this._inReqTable, method, statisticInId, IN + method + REQ);
        this.initEntry(this._outReqTable, method, statisticOutId, OUT + method + REQ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSipAppSessions() {
        Object object = this._sipAppSessionsSynchronizer;
        synchronized (object) {
            return this._sipAppSessions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSipSessions() {
        Object object = this._sipSessionsSynchronizer;
        synchronized (object) {
            return this._sipSessions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSipAppSessions() {
        Object object = this._sipAppSessionsSynchronizer;
        synchronized (object) {
            this._sipAppSessions = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSipSessions() {
        Object object = this._sipSessionsSynchronizer;
        synchronized (object) {
            this._sipSessions = 0L;
        }
    }

    public long getInboundRequestCount(String methodKey) {
        long count = 0L;
        SipMessagePMIEntry entry = this._inReqTable.get(methodKey);
        if (entry != null) {
            count = entry.getCounter();
        }
        return count;
    }

    public long getOutboundRequestCount(String methodKey) {
        long count = 0L;
        SipMessagePMIEntry entry = this._outReqTable.get(methodKey);
        if (entry != null) {
            count = entry.getCounter();
        }
        return count;
    }

    public long getInboundResponseCount(int code) {
        long count = 0L;
        SipMessagePMIEntry entry = this._inResTable.get(this.getResponseCode(code));
        if (entry != null) {
            count = entry.getCounter();
        }
        return count;
    }

    public long getOutboundResponseCount(int code) {
        long count = 0L;
        SipMessagePMIEntry entry = this._outResTable.get(this.getResponseCode(code));
        if (entry != null) {
            count = entry.getCounter();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceSipSessionsCount() {
        Object object = this._sipSessionsSynchronizer;
        synchronized (object) {
            if (this._tracePMIModulus > 0 && this._lastSipSessionCountPrinted != this._sipSessions && this._sipSessions % (long)this._tracePMIModulus == 0L) {
                this._lastSipSessionCountPrinted = this._sipSessions;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceAppSessionCount() {
        Object object = this._sipAppSessionsSynchronizer;
        synchronized (object) {
            if (this._tracePMIModulus > 0 && this._lastAppSessionCountPrinted != this._sipAppSessions && this._sipAppSessions % (long)this._tracePMIModulus == 0L) {
                this._lastAppSessionCountPrinted = this._sipAppSessions;
            }
        }
    }

    private void traceCounter(String description, long counter) {
        if (this._tracePMIModulus > 0) {
            System.out.println(this + description + " : " + counter);
        }
    }

    private void readConfigSettings() {
        PropertiesStore store = PropertiesStore.getInstance();
        this._tracePMIModulus = store.getProperties().getInt("traceSessionsModulus");
    }
}

