/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.matching;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.parser.SipXMLParser;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.container.rules.Condition;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.virtualhost.VirtualHostAlias;
import com.ibm.ws.sip.container.virtualhost.VirtualHostAliasImpl;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import com.ibm.ws.sip.stack.transport.virtualhost.SipVirtualHostAdapter;
import jain.protocol.ip.sip.ListeningPoint;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedList;
import javax.servlet.sip.SipApplicationSession;

public class SipServletsMatcher {
    private static final LogMgr c_logger = Log.get(SipServletsMatcher.class);
    private LinkedList<SipAppDesc> m_apps = new LinkedList();
    private HashMap<String, SipAppDesc> activeApp = new HashMap();
    private SipXMLParser m_parser;
    private HashMap listeningPointsVHAliasesList = new HashMap();

    public LinkedList<SipAppDesc> getAllApps() {
        return this.m_apps;
    }

    public void addAppToActiveApplicationsList(SipAppDesc app) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "addAppToActiveApplicationsList", "Adding App : " + app.getApplicationName() + " to the active applications list. ");
        }
        String applicationKey = app.getApplicationName();
        this.activeApp.put(applicationKey, app);
        this.m_apps.add(app);
    }

    public SipAppDesc unloadApplicationConfiguration(String appName) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{appName};
            c_logger.traceEntry((Object)this, "unloadApplicationConfiguration", params);
        }
        SipAppDesc app = null;
        for (SipAppDesc temp : this.m_apps) {
            if (!temp.getWebAppName().equals(appName)) continue;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "unloadApplicationConfiguration", "application removed");
            }
            this.m_apps.remove(temp);
            app = temp;
            break;
        }
        app = this.activeApp.remove(appName);
        PerformanceMgr perfMgr = PerformanceMgr.getInstance();
        if (perfMgr != null && app != null) {
            perfMgr.appUnloaded(appName, app.getAppIndexForPmi());
        }
        return app;
    }

    public SipServletDesc matchSipletForApplication(SipServletRequestImpl request, String appName) {
        SipServletDesc matchedSiplet;
        block9: {
            SipAppDesc app;
            block8: {
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceEntry((Object)this, "matchSipletForApplication", request.getMethod(), appName);
                }
                app = null;
                matchedSiplet = null;
                app = this.activeApp.get(appName);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "matchSipletForApplication", "Application router asked match for application: " + appName);
                }
                if (app == null) {
                    request.processCompositionErrorResponse();
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "matchSipletForApplication", "There is no application been installed: " + appName);
                    }
                    return null;
                }
                if (this.shouldExcludeFromApplicationRouting(request, app)) {
                    return null;
                }
                String virtualHost = null;
                virtualHost = request.getVirtualHost();
                if (!this.isModuleInCorrectVH(request, app, virtualHost)) {
                    return null;
                }
                if (!app.hasMainServlet()) break block8;
                matchedSiplet = app.getMainSiplet();
                if (!c_logger.isTraceDebugEnabled()) break block9;
                c_logger.traceDebug(this, "matchSipletForApplication", "Selecting main servlet=" + matchedSiplet);
                break block9;
            }
            for (SipServletDesc siplet : app.getSipServlets()) {
                Condition rule = siplet.getTriggeringRule();
                if (rule == null || !rule.evaluate(request)) continue;
                matchedSiplet = siplet;
                if (!c_logger.isTraceDebugEnabled()) break;
                StringBuffer buffer = new StringBuffer(64);
                buffer.append("Siplet: ");
                buffer.append(matchedSiplet);
                buffer.append(" matched request: ");
                buffer.append(request.getMethod());
                c_logger.traceDebug(this, "matchSipletForApplication", buffer.toString());
                break;
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "matchSipletForApplication", matchedSiplet);
        }
        request.setNextApplication(null);
        return matchedSiplet;
    }

    private boolean shouldExcludeFromApplicationRouting(SipServletRequestImpl request, SipAppDesc appDesc) {
        SipAppDesc originatingSipAppDesc;
        String originatingAppName;
        if (appDesc.shouldExcludeFromApplicationRouting()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "shouldExcludeFromApplicationRouting", "The application " + appDesc.getApplicationName() + " is configured to be excluded from application routing");
            }
            return true;
        }
        SipApplicationSession sas = request.getApplicationSession();
        if (sas != null && (originatingAppName = sas.getApplicationName()) != null && (originatingSipAppDesc = this.activeApp.get(originatingAppName)) != null && originatingSipAppDesc.shouldExcludeFromApplicationRouting()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "shouldExcludeFromApplicationRouting", "The originating application " + originatingAppName + " is configured to be excluded from application routing");
            }
            return true;
        }
        return false;
    }

    private boolean isModuleInCorrectVH(SipServletRequestImpl request, SipAppDesc app, String virtualHostName) {
        if (virtualHostName != null) {
            return app.getVirtualHostName().equals(virtualHostName);
        }
        ListeningPoint listeningPoint = request.getSipProvider().getListeningPoint();
        VirtualHostAlias vha = (VirtualHostAlias)this.listeningPointsVHAliasesList.get(listeningPoint);
        if (vha == null) {
            String hostName;
            block7: {
                vha = new VirtualHostAliasImpl();
                hostName = listeningPoint.getHost();
                try {
                    InetAddress addr = InetAddressCache.getByName(hostName);
                    hostName = addr.getHostName();
                }
                catch (UnknownHostException e2) {
                    if (!c_logger.isTraceDebugEnabled()) break block7;
                    c_logger.traceDebug(this, "isModuleInCorrectVH", "failed to lookup host, " + hostName);
                }
            }
            vha.init(hostName, listeningPoint.getPort());
            this.listeningPointsVHAliasesList.put(listeningPoint, vha);
        }
        boolean isVhMatch = SipVirtualHostAdapter.isHostAliasMatchVirtualHost(vha, app);
        if (c_logger.isTraceDebugEnabled()) {
            if (isVhMatch) {
                c_logger.traceDebug(this, "isModuleInCorrectVH", "found match for virtual host alias");
            } else {
                c_logger.traceDebug(this, "isModuleInCorrectVH", "no match for virtual host alias");
            }
        }
        return isVhMatch;
    }

    public SipServletDesc getDefaultHandler() {
        SipAppDesc appDesc;
        SipServletDesc sipletDesc = null;
        if (this.m_apps.size() > 0 && null != (appDesc = this.m_apps.getFirst())) {
            sipletDesc = appDesc.getDefaultSiplet();
        }
        return sipletDesc;
    }

    public SipServletDesc getSipletByName(String name) {
        for (SipAppDesc appDesc : this.activeApp.values()) {
            SipServletDesc siplet = appDesc.getSipServlet(name);
            if (siplet == null) continue;
            return siplet;
        }
        return null;
    }

    public SipAppDesc getSipApp(String appName) {
        return this.activeApp.get(appName);
    }

    public int getNumOfRunningApplications() {
        return this.activeApp.values().size();
    }

    public void loadAppConfiguration(SipAppDesc app) {
        PerformanceMgr perfMgr;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{app};
            c_logger.traceEntry((Object)this, "loadAppConfiguration", params);
        }
        this.addAppToActiveApplicationsList(app);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "loadAppConfiguration", "Sip App loaded successfully: " + app.getApplicationName());
        }
        if ((perfMgr = PerformanceMgr.getInstance()) != null) {
            perfMgr.appLoaded(app.getApplicationName(), app);
        }
    }
}

