/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfigurationManager;
import com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl;
import com.ibm.ws.jsp.taglib.ParsedTagElement;
import com.ibm.ws.jsp.taglib.ParsedTagFileElement;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.translator.JspTranslator;
import com.ibm.ws.jsp.translator.JspTranslatorFactory;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.tagfilescan.TagFileScanResult;
import com.ibm.ws.jsp.translator.visitor.xml.ParserFactory;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class TldParser
extends DefaultHandler {
    protected static Logger logger;
    protected static Level logLevel;
    private static final String CLASS_NAME = "com.ibm.ws.jsp.taglib.TldParser";
    public static final String TAGLIB_DTD_PUBLIC_ID_11 = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN";
    public static final String TAGLIB_DTD_RESOURCE_PATH_11 = "/javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd";
    public static final String TAGLIB_DTD_PUBLIC_ID_12 = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN";
    public static final String TAGLIB_DTD_RESOURCE_PATH_12 = "/javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd";
    public static final String XMLSCHEMA_DTD_PUBLIC_ID = "-//W3C//DTD XMLSCHEMA 200102//EN";
    public static final String XMLSCHEMA_DTD_RESOURCE_PATH = "/javax/servlet/resources/XMLSchema.dtd";
    public static final String DATATYPES_DTD_PUBLIC_ID = "datatypes";
    public static final String DATATYPES_DTD_RESOURCE_PATH = "/javax/servlet/resources/datatypes.dtd";
    public static final String TAGLIB_XSD_SYSTEM_ID_20 = "web-jsptaglibrary_2_0.xsd";
    public static final String TAGLIB_XSD_RESOURCE_PATH_20 = "/javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd";
    public static final String TAGLIB_XSD_SYSTEM_ID_30 = "web-jsptaglibrary_3_0.xsd";
    public static final String TAGLIB_XSD_RESOURCE_PATH_30 = "/jakarta/servlet/resources/web-jsptaglibrary_3_0.xsd";
    public static final String J2EE14_XSD_SYSTEM_ID = "j2ee_1_4.xsd";
    public static final String J2EE14_XSD_RESOURCE_PATH = "/javax/servlet/resources/j2ee_1_4.xsd";
    public static final String XML_XSD_SYSTEM_ID = "http://www.w3.org/2001/xml.xsd";
    public static final String XML_XSD_RESOURCE_PATH = "/javax/servlet/resources/xml.xsd";
    public static final String WEB_SERVICE_CLIENT_XSD_SYSTEM_ID = "http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd";
    public static final String WEB_SERVICE_CLIENT_XSD_RESOURCE_PATH = "/javax/servlet/resources/j2ee_web_services_client_1_1.xsd";
    protected static final int TAGLIB_ELEMENT = 1;
    protected static final int TAG_ELEMENT = 2;
    protected static final int TAGFILE_ELEMENT = 3;
    protected static final int FUNCTION_ELEMENT = 4;
    protected static final int ATTRIBUTE_ELEMENT = 5;
    protected static final int DEFERRED_VALUE_ELEMENT = 6;
    protected static String[] elementTypes;
    protected int currentElement;
    protected JspCoreContext ctxt;
    protected JspConfigurationManager configManager;
    protected ClassLoader classloader;
    protected SAXParser saxParser;
    protected TagLibraryInfoImpl tli;
    protected List<TagInfo> tags;
    protected String tagName;
    protected String tagDescription;
    protected String tagClassName;
    protected String teiClassName;
    protected String bodyContent;
    protected String displayName;
    protected String smallIcon;
    protected String largeIcon;
    protected boolean dynamicAttributes;
    protected List<TagAttributeInfo> attributes;
    protected String attributeName;
    protected boolean required;
    protected String type;
    protected boolean reqTime;
    protected boolean fragment;
    protected boolean deferredValue;
    protected boolean deferredMethod;
    protected String expectedType;
    protected String methodSignature;
    protected List<TagVariableInfo> variables;
    protected String nameGiven;
    protected String nameFromAttribute;
    protected String variableClassName;
    protected boolean declare;
    protected int scope;
    protected List<TagFileInfo> tagFiles;
    protected String tagFileName;
    protected String path;
    protected List<FunctionInfo> functions;
    protected String functionName;
    protected String functionClass;
    protected String functionSignature;
    protected String validatorClass;
    protected HashMap<String, String> validatorInitParams;
    protected String paramName;
    protected String paramValue;
    protected StringBuffer chars;
    protected List<String> eventListenerList;
    protected String tldLocation;
    public ArrayList<ParsedTagElement> parsedTagElements;
    public ArrayList<ParsedTagFileElement> parsedTagFileElements;
    public HashMap<String, HashMap<String, String>> tagLibValidators;
    static final long serialVersionUID = -8565946898559754969L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TldParser(JspCoreContext ctxt, JspConfigurationManager configManager, boolean validateTLDs, ClassLoader classloader) throws JspCoreException {
        this(ctxt, configManager, validateTLDs);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{ctxt, configManager, validateTLDs, classloader});
        }
        if (classloader != null) {
            this.classloader = classloader;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
            logger.logp(logLevel, CLASS_NAME, "TldParser(JspCoreContext, JspConfigurationManager, boolean, ClassLoader)", "ctxt= [" + ctxt + "]  configManager= [" + configManager + "] validateTLDs= [" + validateTLDs + "] classloader= [" + classloader + "]");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TldParser(JspCoreContext ctxt, JspConfigurationManager configManager, boolean validateTLDs) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{ctxt, configManager, validateTLDs});
        }
        this.currentElement = 0;
        this.ctxt = null;
        this.configManager = null;
        this.classloader = null;
        this.saxParser = null;
        this.tli = null;
        this.tags = new ArrayList<TagInfo>();
        this.tagName = null;
        this.tagDescription = null;
        this.tagClassName = null;
        this.teiClassName = null;
        this.bodyContent = "JSP";
        this.displayName = null;
        this.smallIcon = null;
        this.largeIcon = null;
        this.dynamicAttributes = false;
        this.attributes = new ArrayList<TagAttributeInfo>();
        this.attributeName = null;
        this.required = false;
        this.type = null;
        this.reqTime = false;
        this.fragment = false;
        this.deferredValue = false;
        this.deferredMethod = false;
        this.expectedType = null;
        this.methodSignature = null;
        this.variables = new ArrayList<TagVariableInfo>();
        this.nameGiven = null;
        this.nameFromAttribute = null;
        this.variableClassName = "java.lang.String";
        this.declare = true;
        this.scope = 0;
        this.tagFiles = new ArrayList<TagFileInfo>();
        this.tagFileName = null;
        this.path = null;
        this.functions = new ArrayList<FunctionInfo>();
        this.functionName = null;
        this.functionClass = null;
        this.functionSignature = null;
        this.validatorClass = null;
        this.validatorInitParams = null;
        this.paramName = null;
        this.paramValue = null;
        this.chars = null;
        this.eventListenerList = new ArrayList<String>();
        this.tldLocation = null;
        this.ctxt = ctxt;
        this.configManager = configManager;
        if (ctxt != null) {
            this.classloader = ctxt.getJspClassloaderContext().getClassLoader();
        }
        ClassLoader oldLoader = ThreadContextHelper.getContextClassLoader();
        ThreadContextHelper.setClassLoader((ClassLoader)TldParser.class.getClassLoader());
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            if (validateTLDs) {
                saxFactory.setFeature("http://xml.org/sax/features/validation", true);
                saxFactory.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            this.saxParser = saxFactory.newSAXParser();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                logger.logp(logLevel, CLASS_NAME, "TldParser(JspCoreContext, JspConfigurationManager, boolean)", "ctxt= [" + ctxt + "]  configManager= [" + configManager + "] validateTLDs= [" + validateTLDs + "] saxParser= [" + this.saxParser + "]");
            }
        }
        catch (ParserConfigurationException e) {
            throw new JspCoreException(e);
        }
        catch (SAXException e) {
            throw new JspCoreException(e);
        }
        finally {
            ThreadContextHelper.setClassLoader((ClassLoader)oldLoader);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void reset() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "reset", new Object[0]);
        }
        this.resetTagFile();
        this.resetTag();
        this.resetFunction();
        this.resetVariable();
        this.resetAttribute();
        this.resetValidator();
        this.tags.clear();
        this.tagFiles.clear();
        this.functions.clear();
        this.eventListenerList.clear();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "reset");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void resetTagFile() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "resetTagFile", new Object[0]);
        }
        this.tagFileName = null;
        this.path = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "resetTagFile");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void resetTag() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "resetTag", new Object[0]);
        }
        this.tagName = null;
        this.tagClassName = null;
        this.teiClassName = null;
        this.bodyContent = "JSP";
        this.tagDescription = null;
        this.displayName = null;
        this.smallIcon = null;
        this.largeIcon = null;
        this.dynamicAttributes = false;
        this.attributes.clear();
        this.variables.clear();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "resetTag");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void resetFunction() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "resetFunction", new Object[0]);
        }
        this.functionClass = null;
        this.functionSignature = null;
        this.functionName = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "resetFunction");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void resetVariable() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "resetVariable", new Object[0]);
        }
        this.nameGiven = null;
        this.nameFromAttribute = null;
        this.variableClassName = "java.lang.String";
        this.declare = true;
        this.scope = 0;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "resetVariable");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void resetAttribute() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "resetAttribute", new Object[0]);
        }
        this.attributeName = null;
        this.required = false;
        this.type = null;
        this.reqTime = false;
        this.fragment = false;
        this.deferredValue = false;
        this.deferredMethod = false;
        this.expectedType = null;
        this.methodSignature = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "resetAttribute");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void resetValidator() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "resetValidator", new Object[0]);
        }
        this.validatorClass = null;
        this.validatorInitParams = null;
        this.paramName = null;
        this.paramValue = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "resetValidator");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TagLibraryInfoImpl parseTLD(JspInputSource inputSource, String tldOriginatorId) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "parseTLD", new Object[]{inputSource, tldOriginatorId});
        }
        this.tldLocation = inputSource.getRelativeURL();
        this.tli = new TagLibraryInfoImpl(tldOriginatorId, inputSource);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
            logger.logp(logLevel, CLASS_NAME, "parseTLD(JspInputSource, String)", "inputSource= [" + inputSource + "]  tldOriginatorId= [" + tldOriginatorId + "]");
        }
        try {
            if (inputSource instanceof JspInputSourceContainerImpl) {
                InputStream is = inputSource.getInputStream();
                if (is != null) {
                    this.parse(is);
                } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                    logger.logp(logLevel, CLASS_NAME, "parseTLD(JspInputSource, String)", "problem parsing tld for " + inputSource.getRelativeURL());
                }
            } else {
                this.parse(inputSource.getInputStream());
            }
        }
        catch (SAXException e) {
            this.tli = null;
            this.logParseErrorMessage(e);
            throw new JspCoreException(e);
        }
        catch (IOException e) {
            this.tli = null;
            this.logParseErrorMessage(e);
            throw new JspCoreException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
            logger.logp(logLevel, CLASS_NAME, "parseTLD(JspInputSource, String)", "returning tli= [" + (Object)((Object)this.tli) + "]");
        }
        TagLibraryInfoImpl tagLibraryInfoImpl = this.tli;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            tagLibraryInfoImpl = tagLibraryInfoImpl;
            logger.exiting(CLASS_NAME, "parseTLD", (Object)tagLibraryInfoImpl);
        }
        return tagLibraryInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TagLibraryInfoImpl parseTLD(JspInputSource inputSource, InputStream is, String tldOriginatorId) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "parseTLD", new Object[]{inputSource, is, tldOriginatorId});
        }
        this.tldLocation = inputSource.getRelativeURL();
        this.tli = new TagLibraryInfoImpl(tldOriginatorId, inputSource);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
            logger.logp(logLevel, CLASS_NAME, "parseTLD(JspInputSource, InputStream, String)", "inputSource= [" + inputSource + "]  InputStream=[" + is + "] tldOriginatorId= [" + tldOriginatorId + "]");
        }
        try {
            this.parse(is);
        }
        catch (SAXException e) {
            this.tli = null;
            this.logParseErrorMessage(e);
            throw new JspCoreException(e);
        }
        catch (IOException e) {
            this.tli = null;
            this.logParseErrorMessage(e);
            throw new JspCoreException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
            logger.logp(logLevel, CLASS_NAME, "parseTLD(JspInputSource, InputStream, String)", "returning tli= [" + (Object)((Object)this.tli) + "]");
        }
        TagLibraryInfoImpl tagLibraryInfoImpl = this.tli;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            tagLibraryInfoImpl = tagLibraryInfoImpl;
            logger.exiting(CLASS_NAME, "parseTLD", (Object)tagLibraryInfoImpl);
        }
        return tagLibraryInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void parse(InputStream is) throws SAXException, IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "parse", new Object[]{is});
        }
        this.reset();
        try {
            ParserFactory.parseDocument(this.saxParser, is, (DefaultHandler)this);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "parse");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<String> getEventListenerList() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getEventListenerList", new Object[0]);
        }
        List<String> list = this.eventListenerList;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting(CLASS_NAME, "getEventListenerList", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<String> getParsedTagsList() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getParsedTagsList", new Object[0]);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.parsedTagElements != null) {
            for (ParsedTagElement pte : this.parsedTagElements) {
                result.add(pte.getTagClassName());
            }
        }
        ArrayList<String> arrayList = result;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting(CLASS_NAME, "getParsedTagsList", arrayList);
        }
        return arrayList;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void startElement(String namespaceURI, String localName, String elementName, Attributes attrs) throws SAXException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "startElement", new Object[]{namespaceURI, localName, elementName, attrs});
        }
        this.chars = new StringBuffer();
        if (elementName.equals("taglib")) {
            this.currentElement = 1;
            String ver = attrs.getValue("version");
            if (ver != null) {
                this.tli.setRequiredVersion(ver.trim());
            }
        } else if (elementName.equals("tag")) {
            this.currentElement = 2;
        } else if (elementName.equals("tag-file")) {
            this.currentElement = 3;
        } else if (elementName.equals("function")) {
            this.currentElement = 4;
        } else if (elementName.equals("attribute")) {
            this.currentElement = 5;
        } else if (elementName.equals("deferred-value")) {
            this.currentElement = 6;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
            logger.logp(logLevel, CLASS_NAME, "startElement", "currentElement= [" + elementTypes[this.currentElement - 1] + "]");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "startElement");
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void characters(char[] ch, int start, int length) throws SAXException {
        for (int i = 0; i < length; ++i) {
            if (this.chars == null) continue;
            this.chars.append(ch[start + i]);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void endElement(String namespaceURI, String localName, String elementName) throws SAXException {
        block105: {
            block126: {
                block125: {
                    block124: {
                        block123: {
                            block122: {
                                block121: {
                                    block120: {
                                        block119: {
                                            block118: {
                                                block117: {
                                                    block116: {
                                                        block115: {
                                                            block114: {
                                                                block113: {
                                                                    block112: {
                                                                        block111: {
                                                                            block110: {
                                                                                block109: {
                                                                                    block108: {
                                                                                        block107: {
                                                                                            block106: {
                                                                                                block104: {
                                                                                                    if (logger != null && logger.isLoggable(Level.FINER)) {
                                                                                                        logger.entering(CLASS_NAME, "endElement", new Object[]{namespaceURI, localName, elementName});
                                                                                                    }
                                                                                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                                                                                                        logger.logp(logLevel, CLASS_NAME, "endElement", "namespaceURI= [" + namespaceURI + "] localName= [" + localName + "] elementName=[" + elementName + "]");
                                                                                                    }
                                                                                                    if (!elementName.equals("tlibversion") && !elementName.equals("tlib-version")) break block104;
                                                                                                    this.tli.setTlibversion(this.chars.toString().trim());
                                                                                                    break block105;
                                                                                                }
                                                                                                if (!elementName.equals("jspversion") && !elementName.equals("jsp-version")) break block106;
                                                                                                this.tli.setRequiredVersion(this.chars.toString().trim());
                                                                                                break block105;
                                                                                            }
                                                                                            if (!elementName.equals("shortname") && !elementName.equals("short-name")) break block107;
                                                                                            this.tli.setShortName(this.chars.toString().trim());
                                                                                            break block105;
                                                                                        }
                                                                                        if (!elementName.equals("uri")) break block108;
                                                                                        this.tli.setReliableURN(this.chars.toString().trim());
                                                                                        break block105;
                                                                                    }
                                                                                    if (!elementName.equals("info") && !elementName.equals("description")) break block109;
                                                                                    switch (this.currentElement) {
                                                                                        case 1: {
                                                                                            this.tli.setInfoString(this.chars.toString().trim());
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            this.tagDescription = this.chars.toString().trim();
                                                                                            break;
                                                                                        }
                                                                                    }
                                                                                    break block105;
                                                                                }
                                                                                if (!elementName.equals("tag")) break block110;
                                                                                TagAttributeInfo[] tagAttributes = new TagAttributeInfo[this.attributes.size()];
                                                                                if (this.attributes.size() > 0) {
                                                                                    tagAttributes = this.attributes.toArray(tagAttributes);
                                                                                }
                                                                                TagVariableInfo[] tagVariables = new TagVariableInfo[this.variables.size()];
                                                                                if (this.variables.size() > 0) {
                                                                                    tagVariables = this.variables.toArray(tagVariables);
                                                                                }
                                                                                if (this.classloader == null) {
                                                                                    if (this.parsedTagElements == null) {
                                                                                        this.parsedTagElements = new ArrayList();
                                                                                    }
                                                                                    this.parsedTagElements.add(new ParsedTagElement(this.tldLocation, this.tagName, this.tagClassName, this.bodyContent, this.tagDescription, this.tli, this.teiClassName, tagAttributes, this.displayName, this.smallIcon, this.largeIcon, tagVariables, this.dynamicAttributes));
                                                                                } else {
                                                                                    TagExtraInfo tei = null;
                                                                                    if (this.teiClassName != null) {
                                                                                        if (this.teiClassName.trim().equals("")) {
                                                                                            logger.logp(Level.WARNING, CLASS_NAME, "endElement", "TagExtraInfo specified in tld without a value.  tld=[" + this.tldLocation + "]");
                                                                                        } else {
                                                                                            try {
                                                                                                tei = (TagExtraInfo)this.classloader.loadClass(this.teiClassName).newInstance();
                                                                                            }
                                                                                            catch (Exception e) {
                                                                                                String message = JspCoreException.getMsg("jsp.error.failed.load.tei.class", new Object[]{this.teiClassName});
                                                                                                message = message + " from " + this.tldLocation;
                                                                                                logger.logp(Level.WARNING, CLASS_NAME, "endElement", message);
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    TagInfo tag = new TagInfo(this.tagName, this.tagClassName, this.bodyContent, this.tagDescription, (TagLibraryInfo)this.tli, tei, tagAttributes, this.displayName, this.smallIcon, this.largeIcon, tagVariables, this.dynamicAttributes);
                                                                                    this.tags.add(tag);
                                                                                }
                                                                                this.resetTag();
                                                                                this.currentElement = 1;
                                                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                                                                                    logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] TagInfo tag= [" + this.tagName + "]");
                                                                                }
                                                                                break block105;
                                                                            }
                                                                            if (!elementName.equals("tag-file")) break block111;
                                                                            if (this.ctxt != null) {
                                                                                try {
                                                                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                                                                                        logger.logp(Level.FINEST, CLASS_NAME, "endElement", "about to do tagfilescan for = [" + this.path + " " + this.tagFileName + "]");
                                                                                    }
                                                                                    JspOptions jspOptions = new JspOptions();
                                                                                    JspInputSource tagFileInputSource = this.ctxt.getJspInputSourceFactory().copyJspInputSource(this.tli.getInputSource(), this.path);
                                                                                    JspTranslator jspTranslator = JspTranslatorFactory.getFactory().createTranslator("TagFileScan", tagFileInputSource, this.ctxt, this.configManager.createJspConfiguration(), jspOptions, new HashMap());
                                                                                    JspVisitorInputMap inputMap = new JspVisitorInputMap();
                                                                                    inputMap.put("TagLibraryInfo", this.tli);
                                                                                    inputMap.put("TagFileName", this.tagFileName);
                                                                                    inputMap.put("TagFilePath", this.path);
                                                                                    HashMap results = jspTranslator.processVisitors(inputMap);
                                                                                    TagFileScanResult result = (TagFileScanResult)results.get("TagFileScan");
                                                                                    TagFileInfo tfi = new TagFileInfo(this.tagFileName, this.path, result.getTagInfo());
                                                                                    this.tagFiles.add(tfi);
                                                                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                                                                                        logger.logp(logLevel, CLASS_NAME, "endElement", "TldParser elementName= [" + elementName + "] TagFileInfo tfi= [" + tfi + "]");
                                                                                    }
                                                                                }
                                                                                catch (JspCoreException e) {
                                                                                    throw new SAXException(e);
                                                                                }
                                                                            }
                                                                            this.resetTagFile();
                                                                            this.currentElement = 1;
                                                                            break block105;
                                                                        }
                                                                        if (!elementName.equals("function")) break block112;
                                                                        FunctionInfo fi = new FunctionInfo(this.functionName, this.functionClass, this.functionSignature);
                                                                        this.functions.add(fi);
                                                                        this.resetFunction();
                                                                        this.currentElement = 1;
                                                                        break block105;
                                                                    }
                                                                    if (!elementName.equals("name")) break block113;
                                                                    switch (this.currentElement) {
                                                                        case 3: {
                                                                            this.tagFileName = this.chars.toString().trim();
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            this.tagName = this.chars.toString().trim();
                                                                            break;
                                                                        }
                                                                        case 4: {
                                                                            this.functionName = this.chars.toString().trim();
                                                                            break;
                                                                        }
                                                                        case 5: {
                                                                            this.attributeName = this.chars.toString().trim();
                                                                            break;
                                                                        }
                                                                    }
                                                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                                                                        logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] currentElement= [" + elementTypes[this.currentElement - 1] + "]");
                                                                    }
                                                                    break block105;
                                                                }
                                                                if (!elementName.equals("path")) break block114;
                                                                this.path = this.chars.toString().trim();
                                                                break block105;
                                                            }
                                                            if (!elementName.equals("tag-class") && !elementName.equals("tagclass")) break block115;
                                                            this.tagClassName = this.chars.toString().trim();
                                                            break block105;
                                                        }
                                                        if (!elementName.equals("tei-class") && !elementName.equals("teiclass")) break block116;
                                                        this.teiClassName = this.chars.toString().trim();
                                                        break block105;
                                                    }
                                                    if (!elementName.equals("body-content") && !elementName.equals("bodycontent")) break block117;
                                                    this.bodyContent = this.chars.toString().trim();
                                                    break block105;
                                                }
                                                if (!elementName.equals("variable")) break block118;
                                                TagVariableInfo tvi = new TagVariableInfo(this.nameGiven, this.nameFromAttribute, this.variableClassName, this.declare, this.scope);
                                                this.variables.add(tvi);
                                                this.resetVariable();
                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                                                    logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] TagVariableInfo= [" + tvi + "]");
                                                }
                                                break block105;
                                            }
                                            if (!elementName.equals("attribute")) break block119;
                                            if (this.fragment) {
                                                this.type = "javax.servlet.jsp.tagext.JspFragment";
                                                this.reqTime = true;
                                            }
                                            if (!this.reqTime) {
                                                this.type = "java.lang.String";
                                            }
                                            if (this.deferredValue && this.expectedType == null) {
                                                this.expectedType = "java.lang.Object";
                                            }
                                            TagAttributeInfo tai = new TagAttributeInfo(this.attributeName, this.required, this.type, this.reqTime, this.fragment, null, this.deferredValue, this.deferredMethod, this.expectedType, this.methodSignature);
                                            this.attributes.add(tai);
                                            this.resetAttribute();
                                            this.currentElement = 2;
                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                                                logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] TagAttributeInfo= [" + tai + "]");
                                            }
                                            break block105;
                                        }
                                        if (!elementName.equals("required")) break block120;
                                        String requiredString = this.chars.toString().trim();
                                        this.required = requiredString.equalsIgnoreCase("yes") || requiredString.equalsIgnoreCase("true");
                                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                                            logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] required= [" + this.required + "]");
                                        }
                                        break block105;
                                    }
                                    if (!elementName.equals("rtexprvalue")) break block121;
                                    String reqTimeString = this.chars.toString().trim();
                                    this.reqTime = reqTimeString.equalsIgnoreCase("yes") || reqTimeString.equalsIgnoreCase("true");
                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                                        logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] reqTime= [" + this.reqTime + "]");
                                    }
                                    break block105;
                                }
                                if (!elementName.equals("deferred-value")) break block122;
                                this.deferredValue = true;
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                                    logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] deferredValue= [" + this.deferredValue + "] type= [" + this.type + "]");
                                }
                                break block105;
                            }
                            if (!elementName.equals("deferred-method")) break block123;
                            this.deferredMethod = true;
                            if (this.methodSignature == null) {
                                this.methodSignature = "java.lang.Object method()";
                            }
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                                logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] deferredMethod= [" + this.deferredMethod + "] methodSignature= [" + this.methodSignature + "]");
                            }
                            break block105;
                        }
                        if (!elementName.equals("method-signature")) break block124;
                        this.methodSignature = this.chars.toString().trim();
                        this.methodSignature = this.methodSignature != null && this.methodSignature.length() > 0 ? this.methodSignature.trim() : "java.lang.Object method()";
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                            logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] methodSignature= [" + this.methodSignature + "]");
                        }
                        break block105;
                    }
                    if (elementName.equals("listener")) break block105;
                    if (!elementName.equals("listener-class")) break block125;
                    this.eventListenerList.add(this.chars.toString().trim());
                    break block105;
                }
                if (!elementName.equals("type")) break block126;
                switch (this.currentElement) {
                    case 2: 
                    case 5: {
                        this.type = this.chars.toString().trim();
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                            logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] tagDescription= [" + this.tagDescription + "]");
                            break;
                        }
                        break block105;
                    }
                    case 6: {
                        this.expectedType = this.chars.toString().trim();
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                            logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] expectedType= [" + this.expectedType + "]");
                        }
                        this.currentElement = 5;
                        break;
                    }
                }
                break block105;
            }
            if (elementName.equals("function-class")) {
                this.functionClass = this.chars.toString().trim();
            } else if (elementName.equals("function-signature")) {
                this.functionSignature = this.chars.toString().trim();
            } else if (elementName.equals("dynamic-attributes")) {
                String dynamicAttributesString = this.chars.toString().trim();
                this.dynamicAttributes = dynamicAttributesString.equalsIgnoreCase("yes") || dynamicAttributesString.equalsIgnoreCase("true");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                    logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] dynamicAttributes= [" + this.dynamicAttributes + "]");
                }
            } else if (elementName.equals("fragment")) {
                String fragmentString = this.chars.toString().trim();
                this.fragment = fragmentString.equalsIgnoreCase("yes") || fragmentString.equalsIgnoreCase("true");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                    logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] fragment= [" + this.fragment + "]");
                }
            } else if (elementName.equals("name-given")) {
                this.nameGiven = this.chars.toString().trim();
            } else if (elementName.equals("name-from-attribute")) {
                this.nameFromAttribute = this.chars.toString().trim();
            } else if (elementName.equals("variable-class")) {
                this.variableClassName = this.chars.toString().trim();
            } else if (elementName.equals("declare")) {
                String declareString = this.chars.toString().trim();
                this.declare = declareString.equalsIgnoreCase("yes") || declareString.equalsIgnoreCase("true");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                    logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] declare= [" + this.declare + "]");
                }
            } else if (elementName.equals("scope")) {
                String strScope = this.chars.toString().trim();
                if (strScope.equals("AT_BEGIN")) {
                    this.scope = 1;
                } else if (strScope.equals("NESTED")) {
                    this.scope = 0;
                } else if (strScope.equals("AT_END")) {
                    this.scope = 2;
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                    logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] scope= [" + this.scope + "]");
                }
            } else if (elementName.equals("validator")) {
                if (this.validatorClass != null) {
                    if (this.validatorClass.trim().equals("")) {
                        logger.logp(Level.WARNING, CLASS_NAME, "endElement", "TagLibraryValidator specified in tld without a value.  tld=[" + this.tldLocation + "]");
                    } else if (this.ctxt == null) {
                        if (this.tagLibValidators == null) {
                            this.tagLibValidators = new HashMap();
                        }
                        this.tagLibValidators.put(this.validatorClass, this.validatorInitParams);
                    } else {
                        try {
                            Class<?> tlvClass = this.classloader.loadClass(this.validatorClass);
                            this.tli.setTabLibraryValidator(tlvClass, this.validatorInitParams);
                        }
                        catch (Exception e) {
                            String message = JspCoreException.getMsg("jsp.error.failed.load.tlv.class", new Object[]{this.validatorClass});
                            logger.logp(Level.FINE, CLASS_NAME, "endElement", message, e);
                            throw new SAXException(message);
                        }
                        catch (NoClassDefFoundError e) {
                            String message = JspCoreException.getMsg("jsp.error.failed.load.tlv.class", new Object[]{this.validatorClass});
                            logger.logp(Level.FINE, CLASS_NAME, "endElement", message, e);
                            throw new SAXException(message);
                        }
                    }
                }
                this.resetValidator();
            } else if (elementName.equals("validator-class")) {
                this.validatorClass = this.chars.toString().trim();
            } else if (elementName.equals("init-param")) {
                if (this.validatorInitParams == null) {
                    this.validatorInitParams = new HashMap();
                }
                this.validatorInitParams.put(this.paramName, this.paramValue);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                    logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] paramName= [" + this.paramName + "] paramValue= [" + this.paramValue + "]");
                }
            } else if (elementName.equals("param-name")) {
                this.paramName = this.chars.toString().trim();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                    logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] paramName= [" + this.paramName + "]");
                }
            } else if (elementName.equals("param-value")) {
                this.paramValue = this.chars.toString().trim();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                    logger.logp(logLevel, CLASS_NAME, "endElement", "elementName= [" + elementName + "] paramValue= [" + this.paramValue + "]");
                }
            } else if (elementName.equals("small-icon")) {
                this.smallIcon = this.chars.toString().trim();
            } else if (elementName.equals("large-icon")) {
                this.largeIcon = this.chars.toString().trim();
            } else if (elementName.equals("taglib")) {
                this.tli.setTags(this.tags);
                this.tli.setTagFiles(this.tagFiles);
                this.tli.setFunctions(this.functions);
                this.currentElement = 0;
            } else if (elementName.equals("display-name")) {
                this.displayName = this.chars.toString().trim();
            }
        }
        this.chars = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "endElement");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "resolveEntity", new Object[]{publicId, systemId});
        }
        InputSource isrc = null;
        String resourcePath = null;
        if (publicId != null) {
            if (publicId.equals(TAGLIB_DTD_PUBLIC_ID_11)) {
                resourcePath = TAGLIB_DTD_RESOURCE_PATH_11;
            } else if (publicId.equals(TAGLIB_DTD_PUBLIC_ID_12)) {
                resourcePath = TAGLIB_DTD_RESOURCE_PATH_12;
            } else if (publicId.equals(XMLSCHEMA_DTD_PUBLIC_ID)) {
                resourcePath = XMLSCHEMA_DTD_RESOURCE_PATH;
            } else if (publicId.equals(DATATYPES_DTD_PUBLIC_ID)) {
                resourcePath = DATATYPES_DTD_RESOURCE_PATH;
            }
        } else if (systemId != null) {
            if (systemId.endsWith(TAGLIB_XSD_SYSTEM_ID_30)) {
                resourcePath = TAGLIB_XSD_RESOURCE_PATH_30;
            } else if (systemId.endsWith(TAGLIB_XSD_SYSTEM_ID_20)) {
                resourcePath = TAGLIB_XSD_RESOURCE_PATH_20;
            } else if (systemId.endsWith(J2EE14_XSD_SYSTEM_ID)) {
                resourcePath = J2EE14_XSD_RESOURCE_PATH;
            } else if (systemId.equals(XML_XSD_SYSTEM_ID)) {
                resourcePath = XML_XSD_RESOURCE_PATH;
            } else if (systemId.equals(WEB_SERVICE_CLIENT_XSD_SYSTEM_ID)) {
                resourcePath = WEB_SERVICE_CLIENT_XSD_RESOURCE_PATH;
            }
        }
        if (resourcePath != null) {
            InputStream input = this.getClass().getResourceAsStream(resourcePath);
            if (input == null) {
                throw new SAXException(JspCoreException.getMsg("jsp.error.internal.dtd.not.found") + "[" + resourcePath + "]");
            }
            isrc = new InputSource(input);
            isrc.setSystemId(systemId);
        }
        InputSource inputSource = isrc;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            inputSource = inputSource;
            logger.exiting(CLASS_NAME, "resolveEntity", inputSource);
        }
        return inputSource;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void error(SAXParseException arg0) throws SAXException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "error", new Object[]{arg0});
        }
        throw arg0;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void fatalError(SAXParseException arg0) throws SAXException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "fatalError", new Object[]{arg0});
        }
        throw arg0;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void warning(SAXParseException arg0) throws SAXException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "warning", new Object[]{arg0});
        }
        String origMessage = arg0.getMessage();
        String newMessage = "Parser warning during parse of Tag Library [" + this.tldLocation + "]";
        if (origMessage != null) {
            newMessage = newMessage + ": " + origMessage;
        }
        logger.logp(Level.WARNING, CLASS_NAME, "warning", newMessage);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "warning");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void logParseErrorMessage(Exception e) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "logParseErrorMessage", new Object[]{e});
        }
        String origMessage = e.getMessage();
        String newMessage = "Failed to parse Tag Library [" + this.tldLocation + "]";
        if (origMessage != null) {
            newMessage = newMessage + ": " + origMessage;
        }
        logger.logp(Level.SEVERE, CLASS_NAME, "logParseErrorMessage", newMessage);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "logParseErrorMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        logLevel = Level.FINEST;
        logger = Logger.getLogger("com.ibm.ws.jsp");
        elementTypes = new String[]{"TAGLIB_ELEMENT", "TAG_ELEMENT", "TAGFILE_ELEMENT", "FUNCTION_ELEMENT", "ATTRIBUTE_ELEMENT", "DEFERRED_VALUE_ELEMENT"};
    }
}

