/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.KeyTransportAlgorithmPredicate;
import org.opensaml.xmlsec.encryption.support.KeyAgreementEncryptionConfiguration;
import org.opensaml.xmlsec.encryption.support.RSAOAEPParameters;
import org.opensaml.xmlsec.impl.BasicWhitelistBlacklistConfiguration;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicEncryptionConfiguration
extends BasicWhitelistBlacklistConfiguration
implements EncryptionConfiguration {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BasicEncryptionConfiguration.class);
    @Nonnull
    @NonnullElements
    private List<Credential> dataEncryptionCredentials = Collections.emptyList();
    @Nonnull
    @NonnullElements
    private List<String> dataEncryptionAlgorithms = Collections.emptyList();
    @Nonnull
    @NonnullElements
    private List<Credential> keyTransportEncryptionCredentials = Collections.emptyList();
    @Nonnull
    @NonnullElements
    private List<String> keyTransportEncryptionAlgorithms = Collections.emptyList();
    @Nullable
    private NamedKeyInfoGeneratorManager dataKeyInfoGeneratorManager;
    @Nullable
    private NamedKeyInfoGeneratorManager keyTransportKeyInfoGeneratorManager;
    @Nullable
    private RSAOAEPParameters rsaOAEPParameters;
    private boolean rsaOAEPParametersMerge = true;
    @Nullable
    private KeyTransportAlgorithmPredicate keyTransportPredicate;
    @Nonnull
    @NonnullElements
    private Map<String, KeyAgreementEncryptionConfiguration> keyAgreementConfigurations = Collections.emptyMap();

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<Credential> getDataEncryptionCredentials() {
        return this.dataEncryptionCredentials;
    }

    public void setDataEncryptionCredentials(@Nullable @NonnullElements List<Credential> credentials) {
        this.dataEncryptionCredentials = credentials == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Credential>(credentials));
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<String> getDataEncryptionAlgorithms() {
        return this.dataEncryptionAlgorithms;
    }

    public void setDataEncryptionAlgorithms(@Nullable @NonnullElements List<String> algorithms) {
        this.dataEncryptionAlgorithms = algorithms == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(StringSupport.normalizeStringCollection(algorithms)));
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<Credential> getKeyTransportEncryptionCredentials() {
        return this.keyTransportEncryptionCredentials;
    }

    public void setKeyTransportEncryptionCredentials(@Nullable @NonnullElements List<Credential> credentials) {
        this.keyTransportEncryptionCredentials = credentials == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Credential>(credentials));
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<String> getKeyTransportEncryptionAlgorithms() {
        return this.keyTransportEncryptionAlgorithms;
    }

    public void setKeyTransportEncryptionAlgorithms(@Nullable @NonnullElements List<String> algorithms) {
        this.keyTransportEncryptionAlgorithms = algorithms == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(StringSupport.normalizeStringCollection(algorithms)));
    }

    @Override
    @Nullable
    public NamedKeyInfoGeneratorManager getDataKeyInfoGeneratorManager() {
        return this.dataKeyInfoGeneratorManager;
    }

    public void setDataKeyInfoGeneratorManager(@Nullable NamedKeyInfoGeneratorManager keyInfoManager) {
        this.dataKeyInfoGeneratorManager = keyInfoManager;
    }

    @Override
    @Nullable
    public NamedKeyInfoGeneratorManager getKeyTransportKeyInfoGeneratorManager() {
        return this.keyTransportKeyInfoGeneratorManager;
    }

    public void setKeyTransportKeyInfoGeneratorManager(@Nullable NamedKeyInfoGeneratorManager keyInfoManager) {
        this.keyTransportKeyInfoGeneratorManager = keyInfoManager;
    }

    @Override
    @Nullable
    public RSAOAEPParameters getRSAOAEPParameters() {
        return this.rsaOAEPParameters;
    }

    public void setRSAOAEPParameters(@Nullable RSAOAEPParameters params) {
        this.rsaOAEPParameters = params;
    }

    @Override
    public boolean isRSAOAEPParametersMerge() {
        return this.rsaOAEPParametersMerge;
    }

    public void setRSAOAEPParametersMerge(boolean flag) {
        this.rsaOAEPParametersMerge = flag;
    }

    @Override
    @Nullable
    public KeyTransportAlgorithmPredicate getKeyTransportAlgorithmPredicate() {
        return this.keyTransportPredicate;
    }

    public void setKeyTransportAlgorithmPredicate(KeyTransportAlgorithmPredicate predicate) {
        this.keyTransportPredicate = predicate;
    }

    @Override
    @Nonnull
    public Map<String, KeyAgreementEncryptionConfiguration> getKeyAgreementConfigurations() {
        return this.keyAgreementConfigurations;
    }

    public void setKeyAgreementConfigurations(@Nullable Map<String, KeyAgreementEncryptionConfiguration> configs) {
        this.keyAgreementConfigurations = configs == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, KeyAgreementEncryptionConfiguration>(configs));
    }
}

