/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.client.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.web.WebUtils;
import com.ibm.ws.security.openidconnect.client.internal.OidcClientConfigImpl;
import com.ibm.ws.security.openidconnect.client.internal.OidcClientImpl;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientUtil;
import com.ibm.ws.webcontainer.security.openidconnect.OidcClient;
import io.openliberty.security.oidcclientcore.storage.OidcStorageUtils;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OidcRedirectServlet
extends HttpServlet {
    private static TraceComponent tc = Tr.register(OidcRedirectServlet.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.client.internal.resources.OidcClientMessages");
    private static final long serialVersionUID = 1L;
    public static final String METHOD_GET = "GET";
    private transient ServletContext servletContext = null;
    private transient BundleContext bundleContext = null;
    private transient ServiceReference<OidcClient> OidcClientRef = null;
    private transient OidcClient oidcClient = null;
    public static OidcClientImpl activatedOidcClientImpl = null;

    public static void setActivatedOidcClientImpl(OidcClientImpl activatedOidcClientImpl) {
        OidcRedirectServlet.activatedOidcClientImpl = activatedOidcClientImpl;
    }

    public void init() {
        this.servletContext = this.getServletContext();
        this.bundleContext = (BundleContext)this.servletContext.getAttribute("osgi-bundlecontext");
        this.OidcClientRef = this.bundleContext.getServiceReference(OidcClient.class);
    }

    private synchronized OidcClient getOidcClient() throws ServletException {
        if (this.OidcClientRef == null) {
            throw new ServletException();
        }
        this.oidcClient = (OidcClient)this.bundleContext.getService(this.OidcClientRef);
        return this.oidcClient;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getParameter("state") == null && METHOD_GET.equalsIgnoreCase(request.getMethod())) {
            if (!this.getOidcClient().isValidRedirectUrl(request)) {
                String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_BAD_GET_REQUEST", (Object[])new Object[]{request.getRequestURL()});
                Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
                response.sendError(500);
                return;
            }
            this.getTokenFromFragment(request, response);
        } else {
            this.doPost(request, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String state = request.getParameter("state");
        if (state == null || state.isEmpty()) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_BAD_REQUEST_NO_STATE", (Object[])new Object[]{request.getRequestURL()});
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            response.sendError(500);
            return;
        }
        String requestUrl = this.getOriginalRequestUrl(request, response, state);
        if (requestUrl == null) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"requestURL is not null or empty", (Object[])new Object[0]);
        }
        String clientId = null;
        int iPrefix = request.getRequestURI().lastIndexOf("/");
        if (iPrefix > -1) {
            clientId = request.getRequestURI().substring(iPrefix + 1);
        }
        String oidcClientId = null;
        if (state.length() > 24) {
            oidcClientId = state.substring(24);
        }
        String code = request.getParameter("code");
        String idToken = request.getParameter("id_token");
        if (code != null || idToken != null) {
            this.sendToRedirectUrl(request, response, requestUrl, state, clientId, oidcClientId, idToken);
        } else {
            this.sendError(request, response);
        }
    }

    String getOriginalRequestUrl(HttpServletRequest request, HttpServletResponse response, String state) throws IOException {
        String cookieName = OidcStorageUtils.getOriginalReqUrlStorageKey((String)state);
        String requestUrl = OidcClientUtil.getReferrerURLCookieHandler().getReferrerURLFromCookies(request, cookieName);
        OidcClientUtil.invalidateReferrerURLCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)cookieName);
        if (tc.isDebugEnabled() && requestUrl != null) {
            Tr.debug((TraceComponent)tc, (String)("requestUrl: " + requestUrl), (Object[])new Object[0]);
        }
        if (requestUrl == null || requestUrl.isEmpty()) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_BAD_REQUEST_NO_COOKIE", (Object[])new Object[]{request.getRequestURL()});
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            response.sendError(500);
            return null;
        }
        if (!this.isRedirectionUrlValid(request, requestUrl, cookieName)) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_BAD_REQUEST_MALFORMED_URL_IN_COOKIE", (Object[])new Object[]{request.getRequestURL(), new URL(requestUrl).getHost()});
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            response.sendError(500);
            return null;
        }
        return requestUrl;
    }

    @FFDCIgnore(value={Exception.class})
    public boolean isRedirectionUrlValid(HttpServletRequest request, @Sensitive String requestUrl, String cookieName) {
        try {
            OidcClientUtil.verifyReferrerHostIsValid((HttpServletRequest)request, (String)requestUrl, (String)cookieName);
            return true;
        }
        catch (Exception e) {
            Tr.error((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
            return false;
        }
    }

    private void sendToRedirectUrl(HttpServletRequest request, HttpServletResponse response, String requestUrl, String state, String clientId, String oidcClientId, String id_token) throws IOException {
        String sessionState = request.getParameter("session_state");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Request info: state: " + state + " session_state: " + sessionState), (Object[])new Object[0]);
        }
        boolean isHttpsRequest = requestUrl.toLowerCase().startsWith("https");
        OidcClientConfigImpl clientCfg = activatedOidcClientImpl.getOidcClientConfig(request, clientId);
        OidcClientUtil.setCookieForRequestParameter((HttpServletRequest)request, (HttpServletResponse)response, (String)clientId, (String)state, (boolean)isHttpsRequest, (ConvergedClientConfig)clientCfg);
        if (oidcClientId != null && !oidcClientId.isEmpty() || id_token != null) {
            this.postToWASReqURL(request, response, requestUrl, oidcClientId);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("OIDC _SSO RP Servlet redirecting to [" + requestUrl + "]"), (Object[])new Object[0]);
            }
            response.sendRedirect(requestUrl);
        }
    }

    private void sendError(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String error = request.getParameter("error");
        if (error != null && "access_denied".equals(error)) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"OAUTH_REQUEST_ACCESS_DENIED", (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"OAUTH_REQUEST_ACCESS_DENIED_ENDUSER", (Object[])new Object[0]);
            response.sendError(403, errorMsg);
            return;
        }
        if (error != null) {
            Tr.error((TraceComponent)tc, (String)"REDIRECT_URI_CONTAINED_ERROR", (Object[])new Object[]{error, request.getParameter("error_description")});
        }
        StringBuilder query = new StringBuilder();
        if (error != null && "invalid_scope".equals(error)) {
            query.append("error=invalid_scope");
        } else {
            query.append("error=access_denied");
        }
        response.sendError(403, query.toString());
    }

    public void getTokenFromFragment(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\"><HEAD><title>Submit This Form</title></HEAD>");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
        sb.append("<BODY onload=\"javascript:document.forms[0].submit()\">");
        String requestUrl = this.getOidcRedirectUrl(request);
        if (requestUrl == null) {
            requestUrl = request.getRequestURL().toString();
        }
        requestUrl = WebUtils.htmlEncode((String)requestUrl);
        sb.append("<FORM name=\"redirectform\" id=\"redirectform\" action=\"");
        sb.append(requestUrl);
        sb.append("\" method=\"POST\">");
        sb.append("<script type=\"text/javascript\" language=\"javascript\">");
        sb.append("function createInput(name, value) {");
        sb.append("var input = document.createElement(\"input\");");
        sb.append("input.setAttribute(\"type\", \"hidden\");");
        sb.append("input.setAttribute(\"name\", name);");
        sb.append("input.setAttribute(\"value\", value);");
        sb.append("return input;");
        sb.append("}");
        sb.append("var form=document.forms[0];");
        sb.append("var state=null;");
        sb.append("var params = {}, postBody = location.hash.substring(1),");
        sb.append("regex = /([^&=]+)=([^&]*)/g, m;");
        sb.append("while (m = regex.exec(postBody)){");
        sb.append("form.appendChild( createInput(decodeURIComponent(m[1]), decodeURIComponent(m[2])));");
        sb.append("}");
        sb.append("</script>");
        sb.append("<button type=\"submit\" name=\"redirectform\">Process Form Post</button></FORM></BODY></HTML>");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OIDC _SSO RP redirecting (\"POST\")\n" + sb.toString()), (Object[])new Object[0]);
        }
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, private, max-age=0");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println(sb.toString());
        out.flush();
    }

    private String getOidcRedirectUrl(HttpServletRequest request) {
        String redirectUrl = null;
        if (activatedOidcClientImpl != null) {
            OidcClientConfigImpl clientCfg;
            String clientId = null;
            int iPrefix = request.getRequestURI().lastIndexOf("/");
            if (iPrefix > -1) {
                clientId = request.getRequestURI().substring(iPrefix + 1);
            }
            if (clientId != null && !clientId.isEmpty() && (clientCfg = activatedOidcClientImpl.getOidcClientConfig(request, clientId)) != null) {
                redirectUrl = clientCfg.getRedirectUrlFromServerToClient();
            }
        }
        return redirectUrl;
    }

    protected void postToWASReqURL(HttpServletRequest req, HttpServletResponse resp, String requestUrl, String oidcClientId) throws IOException {
        String access_token = req.getParameter("access_token");
        String id_token = req.getParameter("id_token");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("id_token:" + id_token), (Object[])new Object[0]);
        }
        StringBuffer sb = new StringBuffer("");
        resp.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, private, max-age=0");
        resp.setHeader("Pragma", "no-cache");
        resp.setDateHeader("Expires", 0L);
        resp.setContentType("text/html");
        sb.append("<HTML xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">");
        sb.append("<HEAD>");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>");
        sb.append("<meta http-equiv=\"Cache-Control\" content=\"no-cache, no-store, must-revalidate\"/>");
        sb.append("<meta http-equiv=\"Pragma\" content=\"no-cache\"/>");
        sb.append("<meta http-equiv=\"Expires\" content=\"0\"/>");
        sb.append("</HEAD>");
        sb.append("<BODY onload=\"document.forms[0].submit()\">");
        sb.append("<FORM name=\"redirectform\" id=\"redirectform\" action=\"");
        sb.append(WebUtils.htmlEncode((String)requestUrl));
        sb.append("\" method=\"POST\"><div>");
        if (oidcClientId != null) {
            sb.append("<input type=\"hidden\" name=\"oidc_client\" value=\"" + WebUtils.htmlEncode((String)oidcClientId) + "\"/>");
        }
        if (access_token != null) {
            sb.append("<input type=\"hidden\" name=\"access_token\" value=\"" + WebUtils.htmlEncode((String)access_token) + "\"/>");
        }
        if (id_token != null) {
            sb.append("<input type=\"hidden\" name=\"id_token\" value=\"" + WebUtils.htmlEncode((String)id_token) + "\"/>");
        }
        sb.append("</div>");
        sb.append("<noscript><div>");
        sb.append("<button type=\"submit\" name=\"redirectform\">Process request</button>");
        sb.append("</div></noscript>");
        sb.append("</FORM></BODY></HTML>");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OIDC _SSO RP redirecting\n" + sb.toString()), (Object[])new Object[0]);
        }
        PrintWriter out = resp.getWriter();
        out.println(sb.toString());
        out.flush();
    }
}

