/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption.keys;

import org.apache.xml.security.encryption.AgreementMethod;
import org.apache.xml.security.encryption.keys.content.AgreementMethodImpl;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.I18n;
import org.apache.xml.security.utils.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyInfoEnc
extends KeyInfo {
    private static final Logger LOG = LoggerFactory.getLogger(KeyInfoEnc.class);

    public KeyInfoEnc(Document doc) {
        super(doc);
    }

    public KeyInfoEnc(Element element, String baseURI) throws XMLSecurityException {
        super(element, baseURI);
    }

    public void add(AgreementMethod agreementMethod) {
        if (!(agreementMethod instanceof ElementProxy)) {
            Object[] exArgs = new Object[]{"AgreementMethod", agreementMethod.getClass().getName()};
            throw new IllegalArgumentException(I18n.translate("KeyValue.IllegalArgument", exArgs));
        }
        LOG.debug("Adding agreementMethod with algorithm {0}" + agreementMethod.getAlgorithm());
        this.appendSelf((ElementProxy)((Object)agreementMethod));
        this.addReturnToSelf();
    }

    public int lengthAgreementMethod() {
        return this.length("http://www.w3.org/2001/04/xmlenc#", "AgreementMethod");
    }

    public AgreementMethod itemAgreementMethod(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectXencNode(this.getFirstChild(), "AgreementMethod", i);
        if (e == null) {
            LOG.debug("No AgreementMethod element at position [{0}]" + i);
            return null;
        }
        return new AgreementMethodImpl(e);
    }

    public boolean containsAgreementMethod() {
        return this.lengthAgreementMethod() > 0;
    }
}

