/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.inbound;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.channel.h2internal.H2HttpInboundLinkWrap;
import com.ibm.ws.http.channel.internal.CallbackIDs;
import com.ibm.ws.http.channel.internal.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.HttpObjectFactory;
import com.ibm.ws.http.channel.internal.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.internal.HttpResponseMessageImpl;
import com.ibm.ws.http.channel.internal.HttpServiceContextImpl;
import com.ibm.ws.http.channel.internal.inbound.Http100ContWriteCallback;
import com.ibm.ws.http.channel.internal.inbound.HttpISCBodyReadCallback;
import com.ibm.ws.http.channel.internal.inbound.HttpISCWriteCallback;
import com.ibm.ws.http.channel.internal.inbound.HttpISCWriteErrorCallback;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundChannelFactory;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundLink;
import com.ibm.ws.http.channel.internal.values.ReturnCodes;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.netty.NettyHttpConstants;
import com.ibm.ws.http.netty.NettyVirtualConnectionImpl;
import com.ibm.ws.http.netty.inbound.NettyTCPConnectionContext;
import com.ibm.ws.http.netty.message.NettyRequestMessage;
import com.ibm.ws.http.netty.message.NettyResponseMessage;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.InterChannelCallback;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.IllegalResponseObjectException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpBaseMessage;
import com.ibm.wsspi.http.channel.HttpPlatformUtils;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.error.HttpError;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.exception.HttpInvalidMessageException;
import com.ibm.wsspi.http.channel.exception.IllegalHttpBodyException;
import com.ibm.wsspi.http.channel.exception.MessageTooLargeException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.values.ContentEncodingValues;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.MethodValues;
import com.ibm.wsspi.http.channel.values.SchemeValues;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.http.channel.values.TransferEncodingValues;
import com.ibm.wsspi.http.channel.values.VersionValues;
import com.ibm.wsspi.http.logging.DebugLog;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import java.io.IOException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpInboundServiceContextImpl
extends HttpServiceContextImpl
implements HttpInboundServiceContext {
    private static final TraceComponent tc = Tr.register(HttpInboundServiceContextImpl.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final String CLASS_NAME = HttpInboundServiceContextImpl.class.getName();
    private static final String HTTP_ERROR_IDENTIFIER = "Http Error ID";
    private HttpInboundLink myLink = null;
    private boolean bContainsLargeMessage = false;
    private long startTime = 0L;
    private String remoteUser = "";
    private boolean forwardedHeaderInitialized = false;
    private int forwardedRemotePort = -1;
    private String forwardedRemoteAddress = null;
    private String forwardedProto = null;
    private String forwardedHost = null;
    private boolean suppress0ByteChunk = false;
    private long bytesWritten;
    private ChannelHandlerContext nettyContext;
    private FullHttpRequest nettyRequest;
    private HttpResponse nettyResponse;
    private NettyRequestMessage requestMessage;
    private HttpResponseMessage response;

    public HttpInboundServiceContextImpl(TCPConnectionContext tsc, HttpInboundLink link, VirtualConnection vc, HttpChannelConfig hcc) {
        this.init(tsc, link, vc, hcc);
    }

    public HttpInboundServiceContextImpl(ChannelHandlerContext context, VirtualConnection vc) {
        this.nettyContext = context;
        NettyTCPConnectionContext tsc = new NettyTCPConnectionContext(context.channel(), vc);
        super.init((TCPConnectionContext)tsc, context);
        this.setHeadersParsed();
        this.setVC(vc);
    }

    public void init(TCPConnectionContext tsc, ConnectionLink link, VirtualConnection vc, HttpChannelConfig hcc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Initializing ISC: " + this), (Object[])new Object[0]);
        }
        super.init(tsc, hcc);
        this.setBodyRC(HttpISCBodyReadCallback.getRef());
        this.myLink = (HttpInboundLink)link;
        if (link instanceof H2HttpInboundLinkWrap) {
            super.setH2Connection(true);
            super.setPushPromise(((H2HttpInboundLinkWrap)link).isPushPromise());
        }
        this.setVC(vc);
        vc.getStateMap().put(CallbackIDs.CALLBACK_HTTPISC, this);
        this.getRequestImpl().initScheme();
    }

    public void reinit(TCPConnectionContext tcc, VirtualConnection vc, HttpInboundLink wrapper) {
        this.setVC(vc);
        vc.getStateMap().put(CallbackIDs.CALLBACK_HTTPISC, this);
        this.myLink = wrapper;
        if (wrapper instanceof H2HttpInboundLinkWrap) {
            super.setH2Connection(true);
            super.setPushPromise(((H2HttpInboundLinkWrap)wrapper).isPushPromise());
        }
        super.reinit(tcc);
    }

    @Override
    public void setNettyRequest(FullHttpRequest request) {
        this.nettyRequest = request;
        super.setNettyRequest(request);
        boolean isSecure = this.nettyContext.channel().hasAttr(NettyHttpConstants.IS_SECURE);
        if (isSecure) {
            this.getRequest().setScheme(SchemeValues.HTTPS);
        } else {
            this.getRequest().setScheme(SchemeValues.HTTP);
        }
    }

    @Override
    public void setNettyResponse(HttpResponse response) {
        this.nettyResponse = response;
        super.setNettyResponse(response);
        this.response = new NettyResponseMessage(this.nettyResponse, this, (HttpRequest)this.nettyRequest);
    }

    public FullHttpRequest getNettyRequest() {
        return this.nettyRequest;
    }

    public HttpResponse getNettyResponse() {
        return this.nettyResponse;
    }

    public ChannelHandlerContext getNettyContext() {
        return this.nettyContext;
    }

    @Override
    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Destroying ISC: " + this), (Object[])new Object[0]);
        }
        this.getVC().getStateMap().remove(CallbackIDs.CALLBACK_HTTPISC);
        this.getVC().getStateMap().remove(HTTP_ERROR_IDENTIFIER);
        this.myLink = null;
        super.destroy();
    }

    @Override
    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Clearing ISC: " + this), (Object[])new Object[0]);
        }
        super.clear();
        this.bContainsLargeMessage = false;
        this.remoteUser = "";
        this.forwardedHeaderInitialized = false;
        this.forwardedHost = null;
        this.forwardedProto = null;
        this.forwardedRemoteAddress = null;
        this.forwardedRemotePort = -1;
        this.suppress0ByteChunk = false;
        this.requestMessage = null;
        if (this.getHttpConfig().runningOnZOS()) {
            this.getVC().getStateMap().remove("HTTPFinalWrite");
        }
    }

    @Override
    protected void updatePersistence(HttpBaseMessageImpl msg) {
        if (this.myLink.maxRequestsServed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Max requests already processed on this connection", (Object[])new Object[0]);
            }
            this.setPersistent(false);
        } else if (this.getResponse().getStatusCode().isErrorCode()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error status code disabling persistence.", (Object[])new Object[0]);
            }
            this.setPersistent(false);
        } else {
            super.updatePersistence(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updatePersistence(inbound) updated: " + this.isPersistent()), (Object[])new Object[0]);
        }
    }

    protected void updateBodyLengthHeaders(HttpBaseMessage msg) {
        if (!this.getRequestImpl().getMethodValue().equals(MethodValues.HEAD)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Body not valid on response, fixing headers", (Object[])new Object[0]);
            }
            if (0L < msg.getContentLength()) {
                msg.removeHeader(HttpHeaderKeys.HDR_CONTENT_LENGTH);
            }
            msg.setTransferEncoding(TransferEncodingValues.NOTSET);
        }
    }

    private int skipWhiteSpace(byte[] data, int start) {
        int index;
        for (index = start; index < data.length && (32 == data[index] || 9 == data[index]); ++index) {
        }
        return index;
    }

    private ReturnCodes parseQValue(byte[] data, int start) {
        ReturnCodes rc = new ReturnCodes(false);
        int len = data.length;
        int index = this.skipWhiteSpace(data, start);
        if (index >= len || 113 != data[index] && 81 != data[index]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Non qvalue found", (Object[])new Object[0]);
            }
            rc.setIntValue(index);
            return rc;
        }
        ++index;
        if ((index = this.skipWhiteSpace(data, index)) >= len || 61 != data[index]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Qvalue missing equals", (Object[])new Object[0]);
            }
            rc.setIntValue(index);
            return rc;
        }
        ++index;
        if ((index = this.skipWhiteSpace(data, index)) < len && (49 == data[index] || 48 == data[index])) {
            boolean leadingOne = 49 == data[index];
            rc.setBooleanValue(leadingOne);
            if (++index < len && 44 != data[index]) {
                if (32 == data[index] || 9 == data[index]) {
                    if ((index = this.skipWhiteSpace(data, index)) < len && 44 != data[index]) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Invalid char after trailing whitespace (1) [" + data[index] + "]"), (Object[])new Object[0]);
                        }
                        rc.setBooleanValue(false);
                    }
                } else if (46 != data[index]) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Non-period found after leading digit", (Object[])new Object[0]);
                    }
                    rc.setBooleanValue(false);
                } else {
                    int numDigits = 0;
                    while (++index < len && 44 != data[index] && 48 <= data[index] && 57 >= data[index]) {
                        ++numDigits;
                        if (48 == data[index]) continue;
                        if (leadingOne) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Non-zero after a leading one", (Object[])new Object[0]);
                            }
                            rc.setBooleanValue(false);
                            break;
                        }
                        rc.setBooleanValue(true);
                    }
                    if (3 < numDigits) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Too many digits in float (" + numDigits + ")"), (Object[])new Object[0]);
                        }
                        rc.setBooleanValue(false);
                    } else if (index < len && 44 != data[index]) {
                        if (32 == data[index] || 9 == data[index]) {
                            ++index;
                            if ((index = this.skipWhiteSpace(data, index)) < len && 44 != data[index]) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Invalid char after trailing whitespace (2) [" + data[index] + "]"), (Object[])new Object[0]);
                                }
                                rc.setBooleanValue(false);
                            }
                        } else {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Invalid char after number [" + data[index] + "]"), (Object[])new Object[0]);
                            }
                            rc.setBooleanValue(false);
                        }
                    }
                }
            }
        }
        rc.setIntValue(index);
        return rc;
    }

    @Override
    protected boolean isCompressionAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isCompressionAllowed", (Object[])new Object[0]);
        }
        boolean rc = false;
        if (this.getRequest().getHeader(HttpHeaderKeys.HDR_ACCEPT_ENCODING).asString() == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isCompressionAllowed(1)", (Object)Boolean.TRUE);
            }
            return true;
        }
        if (this.acceptableEncodings.containsKey(this.preferredEncoding)) {
            rc = ((Float)this.acceptableEncodings.get(this.preferredEncoding)).floatValue() > 0.0f;
        } else if (ContentEncodingValues.GZIP.getName().equals(this.preferredEncoding)) {
            if (this.acceptableEncodings.containsKey(ContentEncodingValues.XGZIP.getName())) {
                rc = ((Float)this.acceptableEncodings.get(ContentEncodingValues.XGZIP.getName())).floatValue() > 0.0f;
            }
        } else {
            rc = ContentEncodingValues.IDENTITY.getName().equals(this.preferredEncoding) ? true : this.bStarEncodingParsed;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isCompressionAllowed(2): " + rc));
        }
        return rc;
    }

    @Override
    public boolean isIncomingMessageFullyRead() {
        if (!this.isBodyComplete()) {
            return !super.isIncomingBodyExpected();
        }
        return true;
    }

    @Override
    public HttpRequestMessage getRequest() {
        if (Objects.nonNull(this.nettyContext)) {
            if (Objects.isNull(this.requestMessage)) {
                this.requestMessage = new NettyRequestMessage(this.nettyRequest, this, this.nettyContext);
            }
            return this.requestMessage;
        }
        return this.getRequestImpl();
    }

    protected HttpRequestMessageImpl getRequestImpl() {
        int len;
        if (null == this.getMyRequest()) {
            if (Objects.nonNull(this.nettyContext)) {
                this.getRequest();
            } else {
                if (this.getObjectFactory() == null) {
                    return null;
                }
                this.setMyRequest(this.getObjectFactory().getRequest(this));
                this.getMyRequest().setHeaderChangeLimit(this.getHttpConfig().getHeaderChangeLimit());
            }
        }
        this.setStartTime();
        HttpRequestMessageImpl req = this.getMyRequest();
        if (!this.getHttpConfig().useNetty() && this.myLink instanceof H2HttpInboundLinkWrap && (len = ((H2HttpInboundLinkWrap)this.myLink).getH2ContentLength()) != -1) {
            req.setContentLength(len);
        }
        return req;
    }

    @Override
    public HttpResponseMessage getResponse() {
        if (Objects.isNull(this.response) && Objects.nonNull(this.nettyContext)) {
            this.response = new NettyResponseMessage(this.nettyResponse, this, (HttpRequest)this.nettyRequest);
        }
        return Objects.nonNull(this.nettyContext) ? this.response : this.getResponseImpl();
    }

    protected final HttpResponseMessageImpl getResponseImpl() {
        if (Objects.isNull(this.getMyResponse())) {
            if (Objects.nonNull(this.nettyContext)) {
                throw new UnsupportedOperationException("HttpResponseMessageImpl is not valid in Netty context, use NettyResponseMessage instead.");
            }
            if (this.getObjectFactory() == null) {
                return null;
            }
            this.setMyResponse(this.getObjectFactory().getResponse(this));
        }
        return this.getMyResponse();
    }

    @Override
    public void setResponse(HttpResponseMessage msg) throws IllegalResponseObjectException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setResponse: " + msg), (Object[])new Object[0]);
        }
        if (null == msg) {
            throw new IllegalResponseObjectException("Illegal null message");
        }
        HttpResponseMessageImpl temp = null;
        try {
            temp = (HttpResponseMessageImpl)msg;
        }
        catch (ClassCastException cce) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Non msg impl passed to setResponse", (Object[])new Object[0]);
            }
            throw new IllegalResponseObjectException("Invalid message provided");
        }
        if (null != this.getMyResponse() && this.isResponseOwner()) {
            if (!this.getMyResponse().equals(temp)) {
                this.getMyResponse().destroy();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caller overlaying same message", (Object[])new Object[0]);
            }
        }
        this.setMyResponse(temp);
        this.getMyResponse().init(this);
        this.getMyResponse().setHeaderChangeLimit(this.getHttpConfig().getHeaderChangeLimit());
        this.updatePersistence(this.getMyResponse());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setResponse");
        }
    }

    @Override
    public void sendResponseHeaders() throws IOException, MessageSentException {
        boolean isTemporaryStatus;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendResponseHeaders(sync)", (Object[])new Object[0]);
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)ioe, (String)(CLASS_NAME + ".sendResponseHeaders"), (String)"594");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to send response without a request msg", (Object[])new Object[0]);
            }
            throw ioe;
        }
        if (this.headersSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (this.getHttpConfig().useNetty()) {
            this.sendHeaders(this.nettyResponse);
        } else {
            this.sendHeaders(this.getResponseImpl());
        }
        int status = this.getResponse().getStatusCodeAsInt();
        boolean bl = HttpDispatcher.useEE7Streams() && status == 101 ? false : (isTemporaryStatus = 100 <= status && 200 > status);
        if (isTemporaryStatus) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Temp response sent, resetting send flags.", (Object[])new Object[0]);
            }
            this.resetWrite();
        }
    }

    @Override
    public VirtualConnection sendResponseHeaders(InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendResponseHeaders(async)", (Object[])new Object[0]);
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)ioe, (String)(CLASS_NAME + ".sendResponseHeaders"), (String)"639");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to send response without a request msg", (Object[])new Object[0]);
            }
            callback.error(this.getVC(), (Throwable)ioe);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"sendReponseHeaders(async): no request");
            }
            return null;
        }
        if (this.headersSent()) {
            throw new MessageSentException("Message already sent");
        }
        this.setForceAsync(bForce);
        this.setAppWriteCallback(callback);
        VirtualConnection vc = this.sendHeaders(this.getResponseImpl(), HttpISCWriteCallback.getRef());
        if (null != vc) {
            boolean isTemporaryStatus;
            int status = this.getResponse().getStatusCodeAsInt();
            boolean bl = HttpDispatcher.useEE7Streams() && status == 101 ? false : (isTemporaryStatus = 100 <= status && 200 > status);
            if (isTemporaryStatus) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Temp response sent, resetting send flags.", (Object[])new Object[0]);
                }
                this.resetWrite();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sendResponseHeaders(async): " + vc));
        }
        return vc;
    }

    @Override
    public void sendResponseBody(WsByteBuffer[] body) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendResponseBody(body)", (Object[])new Object[0]);
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)ioe, (String)(CLASS_NAME + ".sendResponseBody"), (String)"684");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to send response without a request msg", (Object[])new Object[0]);
            }
            throw ioe;
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sendBody() setting partial body true", (Object[])new Object[0]);
            }
            this.setPartialBody(true);
        }
        if (this.getHttpConfig().useNetty()) {
            this.formatBody(body, null);
            this.sendOutgoing(body);
        } else {
            this.sendOutgoing(body, this.getResponseImpl());
        }
    }

    @Override
    public VirtualConnection sendResponseBody(WsByteBuffer[] body, InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendResponseBody(body,cb)", (Object[])new Object[0]);
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)ioe, (String)(CLASS_NAME + ".sendResponseBody"), (String)"746");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to send response without a request msg", (Object[])new Object[0]);
            }
            callback.error(this.getVC(), (Throwable)ioe);
            return null;
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sendBody(cb) setting partial body true", (Object[])new Object[0]);
            }
            this.setPartialBody(true);
        }
        this.setForceAsync(bForce);
        this.setAppWriteCallback(callback);
        return this.sendOutgoing(body, this.getResponseImpl(), HttpISCWriteCallback.getRef());
    }

    @Override
    public void sendRawResponseBody(WsByteBuffer[] body) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRawResponseBody(sync)", (Object[])new Object[0]);
        }
        this.setRawBody(true);
        this.sendResponseBody(body);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendRawResponseBody(sync)");
        }
    }

    @Override
    public VirtualConnection sendRawResponseBody(WsByteBuffer[] body, InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRawResponseBody(async)", (Object[])new Object[0]);
        }
        this.setRawBody(true);
        VirtualConnection vc = this.sendResponseBody(body, callback, bForce);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sendRawResponseBody(async): " + vc));
        }
        return vc;
    }

    protected HttpInvalidMessageException checkResponseValidity() {
        if (!MethodValues.HEAD.equals(this.getRequest().getMethodValue())) {
            long len = this.getResponse().getContentLength();
            long num = this.getNumBytesWritten();
            if (-1L != len && num != len) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Response had content-length of " + Long.toString(len) + " but sent " + Long.toString(num)), (Object[])new Object[0]);
                }
                if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.ERROR)) {
                    this.getHttpConfig().getDebugLog().log(DebugLog.Level.ERROR, "Mismatch in content-length and bytes written: " + Long.toString(len) + " but sent " + Long.toString(num), (HttpServiceContext)this);
                }
                this.setPersistent(false);
                return new HttpInvalidMessageException("Response length: " + Long.toString(len) + " " + Long.toString(num));
            }
        }
        return null;
    }

    protected void logFinalResponse(long numBytesWritten) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            HttpChannelConfig c = this.getHttpConfig();
            Tr.debug((TraceComponent)tc, (String)"logFinalResponse", (Object[])new Object[]{c, c.getAccessLog(), c.getAccessLog().isStarted(), numBytesWritten});
        }
        if (!this.getHttpConfig().getAccessLog().isStarted()) {
            return;
        }
        if (this.getRequest() == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"logFinalResponse", (Object[])new Object[]{"getRequest() is null. HTTPAccess log entry is skipped."});
            }
            return;
        }
        if (MethodValues.UNDEF.equals(this.getRequest().getMethodValue())) {
            return;
        }
        this.getHttpConfig().getAccessLog().log(this.getRequest(), this.getResponse(), this.getRequestVersion().getName(), null, this.getRemoteAddr().getHostAddress(), numBytesWritten);
    }

    @Override
    public void finishResponseMessage(WsByteBuffer[] body) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"finishResponseMessage(body)", (Object[])new Object[0]);
        }
        if (!this.getHttpConfig().useNetty() && !this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)ioe, (String)(CLASS_NAME + ".finishResponseMessage"), (String)"941");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to send response without a request msg", (Object[])new Object[0]);
            }
            throw ioe;
        }
        if (this.isMessageSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Message already sent", (Object[])new Object[0]);
            }
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            boolean shouldContentLengthBeSet = Boolean.TRUE;
            if (Objects.nonNull(this.nettyContext)) {
                if (HttpUtil.isTransferEncodingChunked((HttpMessage)this.nettyResponse)) {
                    shouldContentLengthBeSet = Boolean.FALSE;
                }
            } else if (this.getResponseImpl().isChunkedEncodingSet()) {
                shouldContentLengthBeSet = Boolean.FALSE;
            }
            if (shouldContentLengthBeSet) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"finishMessage() setting partial body false", (Object[])new Object[0]);
                }
                this.setPartialBody(false);
                if (this.getHttpConfig().useNetty()) {
                    this.nettyContext.channel().attr(NettyHttpConstants.CONTENT_LENGTH).set((Object)GenericUtils.sizeOf(body));
                }
            }
        }
        if (this.getHttpConfig().runningOnZOS()) {
            this.getVC().getStateMap().put("HTTPFinalWrite", "true");
        }
        try {
            if (Objects.nonNull(this.nettyContext)) {
                this.formatBody(body, null);
                this.sendFullOutgoing(body);
            } else {
                this.sendFullOutgoing(body, this.getResponseImpl());
            }
        }
        finally {
            this.logFinalResponse(this.getNumBytesWritten());
        }
        HttpInvalidMessageException inv = this.checkResponseValidity();
        if (null != inv) {
            if (this.getHttpConfig().useNetty()) {
                this.nettyContext.close();
            }
            throw inv;
        }
    }

    @Override
    public VirtualConnection finishResponseMessage(WsByteBuffer[] body, InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"finishResponseMessage(body,cb)", (Object[])new Object[0]);
        }
        if (this.isH2Connection()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"finishResponseMessage: This is H2, calling sync finishResponseMessage(body)", (Object[])new Object[0]);
            }
            try {
                this.finishResponseMessage(body);
                return this.getVC();
            }
            catch (IOException e) {
                return null;
            }
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)ioe, (String)(CLASS_NAME + ".finishResponseMessage"), (String)"1010");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to send response without a request msg", (Object[])new Object[0]);
            }
            callback.error(this.getVC(), (Throwable)ioe);
            return null;
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent() && !this.getResponseImpl().isChunkedEncodingSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"finishMessage(cb) setting partial body false", (Object[])new Object[0]);
            }
            this.setPartialBody(false);
        }
        if (this.getHttpConfig().runningOnZOS()) {
            this.getVC().getStateMap().put("HTTPFinalWrite", "true");
        }
        this.setForceAsync(bForce);
        this.setAppWriteCallback(callback);
        VirtualConnection vc = this.sendFullOutgoing(body, this.getResponseImpl(), HttpISCWriteCallback.getRef());
        if (null != vc) {
            this.logFinalResponse(this.getNumBytesWritten());
            HttpInvalidMessageException inv = this.checkResponseValidity();
            if (null != inv) {
                callback.error(vc, (Throwable)inv);
                return null;
            }
        }
        return vc;
    }

    @Override
    public void finishRawResponseMessage(WsByteBuffer[] body) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finishRawResponseMessage(sync)", (Object[])new Object[0]);
        }
        this.setRawBody(true);
        this.finishResponseMessage(body);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finishRawResponseMessage(sync)");
        }
    }

    @Override
    public VirtualConnection finishRawResponseMessage(WsByteBuffer[] body, InterChannelCallback cb, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finishRawResponseMessage(async)", (Object[])new Object[0]);
        }
        this.setRawBody(true);
        VirtualConnection vc = this.finishResponseMessage(body, cb, bForce);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("finishRawResponseMessage(async): " + vc));
        }
        return vc;
    }

    @Override
    public void sendError(HttpError error) throws MessageSentException {
        block14: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Called sendError with: " + error), (Object[])new Object[0]);
            }
            if (!this.headersParsed()) {
                IOException ioe = new IOException("Request not read yet");
                FFDCFilter.processException((Throwable)ioe, (String)(CLASS_NAME + ".sendError"), (String)"1116");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Attempt to send response without a request msg", (Object[])new Object[0]);
                }
                this.finishSendError(ioe);
                return;
            }
            if (this.headersSent()) {
                throw new MessageSentException("Message already sent");
            }
            if (null == error) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Reset null error to Internal Server Error", (Object[])new Object[0]);
                }
                error = StatusCodes.INTERNAL_ERROR.getHttpError();
            }
            this.getResponse().setStatusCode(error.getErrorCode());
            if (this.getResponse().getStatusCode().isErrorCode()) {
                this.setPersistent(false);
            }
            if (Objects.nonNull(this.getVC())) {
                this.getVC().getStateMap().put(HTTP_ERROR_IDENTIFIER, error);
            }
            if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.ERROR)) {
                this.getHttpConfig().getDebugLog().log(DebugLog.Level.ERROR, "Sending an error status code: " + error.getErrorCode(), (HttpServiceContext)this);
            }
            WsByteBuffer[] body = this.loadErrorBody(error, this.getRequest(), this.getResponse());
            if (Objects.isNull(this.nettyContext)) {
                VirtualConnection rc = this.finishResponseMessage(body, HttpISCWriteErrorCallback.getRef(), false);
                if (null != rc) {
                    this.finishSendError(error.getClosingException());
                }
            } else {
                try {
                    this.finishResponseMessage(body);
                }
                catch (IOException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block14;
                    Tr.debug((TraceComponent)tc, (String)("finishResponseMessage failed with: " + e), (Object[])new Object[0]);
                }
            }
        }
    }

    protected void finishSendError() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("finishSendError: " + this.getVC()), (Object[])new Object[0]);
        }
        HttpError error = (HttpError)this.getVC().getStateMap().get(HTTP_ERROR_IDENTIFIER);
        WsByteBuffer[] body = (WsByteBuffer[])this.getVC().getStateMap().remove("HttpChannel_ErrorPageService_Body");
        if (null != body) {
            for (int i = 0; i < body.length && null != body[i]; ++i) {
                body[i].release();
            }
        }
        if (null != error) {
            this.myLink.close(this.getVC(), error.getClosingException());
        } else {
            this.myLink.close(this.getVC(), null);
        }
    }

    protected void finishSendError(Exception e) {
        WsByteBuffer[] body;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("finishSendError(exception): " + this.getVC()), (Object[])new Object[0]);
        }
        if (null != (body = (WsByteBuffer[])this.getVC().getStateMap().remove("HttpChannel_ErrorPageService_Body"))) {
            for (int i = 0; i < body.length && null != body[i]; ++i) {
                body[i].release();
            }
        }
        this.myLink.close(this.getVC(), e);
    }

    protected boolean check100Continue() {
        if (!this.getRequest().isExpect100Continue()) {
            return true;
        }
        if (!this.myLink.getChannel().isRunning()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Channel " + (this.myLink.getChannel().isStopped() ? "stopped" : "stopping") + ", sending error instead of 100-continue"), (Object[])new Object[0]);
            }
            try {
                this.sendError(StatusCodes.UNAVAILABLE.getHttpError());
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".check100Continue"), (String)"1206");
            }
            return false;
        }
        if (this.getHttpConfig().isServantRegion()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"100 continue not sent on SR", (Object[])new Object[0]);
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Request contains [Expect: 100-continue]", (Object[])new Object[0]);
        }
        if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.DEBUG)) {
            this.getHttpConfig().getDebugLog().log(DebugLog.Level.DEBUG, "Request contains the Expect: 100 Continues header", (HttpServiceContext)this);
        }
        HttpResponseMessageImpl msg = this.getResponseImpl();
        msg.setStatusCode(StatusCodes.CONTINUE);
        msg.setContentLength(0L);
        VirtualConnection vc = this.sendHeaders(msg, Http100ContWriteCallback.getRef());
        if (null == vc) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Async write of 100 continue still going", (Object[])new Object[0]);
            }
            return false;
        }
        this.resetMsgSentState();
        msg.setStatusCode(StatusCodes.OK);
        msg.removeHeader(HttpHeaderKeys.HDR_CONTENT_LENGTH);
        return true;
    }

    public void purgeBodyBuffers(boolean callClose) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Discarding body buffers...", (Object[])new Object[0]);
        }
        super.clearStorage();
        super.clearTempStorage();
        if (callClose) {
            this.myLink.close(this.getVC(), null);
        }
    }

    @Override
    public WsByteBuffer[] getRequestBodyBuffers() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRequestBodyBuffers(sync)", (Object[])new Object[0]);
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)ioe, (String)(CLASS_NAME + ".getRequestBodyBuffers"), (String)"1281");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to read a body without headers", (Object[])new Object[0]);
            }
            throw ioe;
        }
        int h2ContentLength = -1;
        if (this.myLink instanceof H2HttpInboundLinkWrap) {
            h2ContentLength = ((H2HttpInboundLinkWrap)this.myLink).getH2ContentLength();
        }
        if (!this.isIncomingBodyValid() && h2ContentLength == -1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffers(sync): No body allowed");
            }
            return null;
        }
        WsByteBuffer[] buffers = null;
        this.setMultiRead(true);
        if (!this.isBodyComplete()) {
            try {
                this.readBodyBuffers(this.getRequestImpl(), false);
            }
            catch (BodyCompleteException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffers(sync): BodyCompleteException");
                }
                return null;
            }
        }
        buffers = this.getAllStorageBuffers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRequestBodyBuffers(sync): " + (null == buffers ? 0 : buffers.length)));
        }
        return buffers;
    }

    @Override
    public VirtualConnection getRequestBodyBuffers(InterChannelCallback callback, boolean bForce) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRequestBodyBuffers(async)", (Object[])new Object[0]);
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)ioe, (String)(CLASS_NAME + ".getRequestBodyBuffers"), (String)"1355");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to read a body without headers", (Object[])new Object[0]);
            }
            callback.error(this.getVC(), (Throwable)ioe);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffers(async): no hdrs yet");
            }
            return null;
        }
        if (!this.isIncomingBodyValid() || this.incomingBuffersReady()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffers(async): read not needed");
            }
            if (bForce) {
                callback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        if (this.isBodyComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffers(async): body complete");
            }
            if (bForce) {
                callback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        this.setAppReadCallback(callback);
        this.setForceAsync(bForce);
        this.setMultiRead(true);
        try {
            if (!this.readBodyBuffers(this.getRequestImpl(), true)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffers(async): read finished");
                }
                if (bForce) {
                    callback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getRequestBodyBuffers(async): exception:" + ioe));
            }
            callback.error(this.getVC(), (Throwable)ioe);
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffers(async): null");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WsByteBuffer getRequestBodyBuffer() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRequestBodyBuffer(sync)", (Object[])new Object[0]);
        }
        boolean isError = false;
        try {
            if (!this.headersParsed()) {
                IOException ioe = new IOException("Request not read yet");
                FFDCFilter.processException((Throwable)ioe, (String)(CLASS_NAME + ".getRequestBodyBuffer"), (String)"1436");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Attempt to read a body without headers", (Object[])new Object[0]);
                }
                isError = true;
                throw ioe;
            }
            if (!this.isIncomingBodyValid()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffer(sync): No body allowed");
                }
                WsByteBuffer ioe = null;
                return ioe;
            }
            this.setMultiRead(false);
            WsByteBuffer buffer = this.getNextBuffer();
            if (null == buffer && !this.isBodyComplete()) {
                try {
                    this.readBodyBuffer(this.getRequestImpl(), false);
                }
                catch (BodyCompleteException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffer(sync): BodyCompleteException");
                    }
                    isError = true;
                    WsByteBuffer wsByteBuffer = null;
                    this.countDownFirstReadLatch(isError);
                    return wsByteBuffer;
                }
                buffer = this.getNextBuffer();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getRequestBodyBuffer(sync): " + buffer));
            }
            WsByteBuffer wsByteBuffer = buffer;
            return wsByteBuffer;
        }
        finally {
            this.countDownFirstReadLatch(isError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualConnection getRequestBodyBuffer(InterChannelCallback callback, boolean bForce) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getRequestBodyBuffer(async) hc: " + this.hashCode()), (Object[])new Object[0]);
        }
        if (Objects.nonNull(this.nettyContext)) {
            callback.complete((VirtualConnection)NettyVirtualConnectionImpl.DUMMY_NETTY_VC);
            return null;
        }
        boolean isError = false;
        try {
            block27: {
                block28: {
                    if (!this.headersParsed()) {
                        IOException ioe = new IOException("Request not read yet");
                        FFDCFilter.processException((Throwable)ioe, (String)(CLASS_NAME + ".getRequestBodyBuffer"), (String)"1511");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Attempt to read a body without headers", (Object[])new Object[0]);
                        }
                        callback.error(this.getVC(), (Throwable)ioe);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffer(async): no hdrs yet");
                        }
                        isError = true;
                        VirtualConnection virtualConnection = null;
                        return virtualConnection;
                    }
                    if (!this.isIncomingBodyValid() || this.incomingBuffersReady()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffer(async): read not needed");
                        }
                        if (bForce) {
                            callback.complete(this.getVC());
                            VirtualConnection ioe = null;
                            return ioe;
                        }
                        VirtualConnection ioe = this.getVC();
                        return ioe;
                    }
                    if (this.isBodyComplete()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffer(async): body complete");
                        }
                        if (bForce) {
                            callback.complete(this.getVC());
                            VirtualConnection ioe = null;
                            return ioe;
                        }
                        VirtualConnection ioe = this.getVC();
                        return ioe;
                    }
                    this.setAppReadCallback(callback);
                    this.setForceAsync(bForce);
                    this.setMultiRead(false);
                    try {
                        if (this.readBodyBuffer(this.getRequestImpl(), true)) break block27;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffer(async): read finished");
                        }
                        if (!bForce) break block28;
                        callback.complete(this.getVC());
                        VirtualConnection ioe = null;
                        return ioe;
                    }
                    catch (IOException ioe) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)("getRequestBodyBuffer(async): exception: " + ioe));
                        }
                        isError = true;
                        callback.error(this.getVC(), (Throwable)ioe);
                        VirtualConnection virtualConnection = null;
                        return virtualConnection;
                    }
                }
                VirtualConnection ioe = this.getVC();
                return ioe;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffer(async): null");
            }
            VirtualConnection virtualConnection = null;
            return virtualConnection;
        }
        finally {
            this.countDownFirstReadLatch(isError);
        }
    }

    public void countDownFirstReadLatch(boolean force) {
        if (this.myLink instanceof H2HttpInboundLinkWrap) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("countDownFirstReadLatch. count down. force: " + force + " HISCI hc: " + this.hashCode()), (Object[])new Object[0]);
            }
            ((H2HttpInboundLinkWrap)this.myLink).countDownFirstReadLatch(force);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" can not count down countDownFirstReadLatch. HISCI hc: " + this.hashCode()), (Object[])new Object[0]);
        }
    }

    @Override
    public WsByteBuffer getRawRequestBodyBuffer() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRawRequestBodyBuffer(sync)", (Object[])new Object[0]);
        }
        this.setRawBody(true);
        WsByteBuffer buffer = this.getRequestBodyBuffer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRawRequestBodyBuffer(sync): " + buffer));
        }
        return buffer;
    }

    @Override
    public WsByteBuffer[] getRawRequestBodyBuffers() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRawRequestBodyBuffers(sync)", (Object[])new Object[0]);
        }
        this.setRawBody(true);
        WsByteBuffer[] list = this.getRequestBodyBuffers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRawRequestBodyBuffers(sync): " + list));
        }
        return list;
    }

    @Override
    public VirtualConnection getRawRequestBodyBuffer(InterChannelCallback cb, boolean bForce) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRawRequestBodyBuffer(async)", (Object[])new Object[0]);
        }
        this.setRawBody(true);
        VirtualConnection vc = this.getRequestBodyBuffer(cb, bForce);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRawRequestBodyBuffer(async): " + vc));
        }
        return vc;
    }

    @Override
    public VirtualConnection getRawRequestBodyBuffers(InterChannelCallback cb, boolean bForce) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRawRequestBodyBuffers(async)", (Object[])new Object[0]);
        }
        this.setRawBody(true);
        VirtualConnection vc = this.getRequestBodyBuffers(cb, bForce);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRawRequestBodyBuffers(async): " + vc));
        }
        return vc;
    }

    @Override
    protected HttpBaseMessageImpl getMessageBeingParsed() {
        return this.getRequestImpl();
    }

    @Override
    protected HttpBaseMessageImpl getMessageBeingSent() {
        return this.getResponseImpl();
    }

    @Override
    protected HttpBaseMessage getCurrentMessage() {
        return this.getResponse();
    }

    @Override
    protected final void parsingComplete() throws Exception {
        super.parsingComplete();
        if (super.isContentLength()) {
            this.checkIncomingMessageLimit(super.getContentLength());
        }
    }

    protected boolean containsLargeMessage() {
        return this.bContainsLargeMessage;
    }

    @Override
    protected void checkIncomingMessageLimit(long addition) throws MessageTooLargeException {
        super.addToIncomingMsgSize(addition);
        if (-1L == this.getHttpConfig().getMessageSizeLimit()) {
            return;
        }
        if (this.queryIncomingMsgSize() > this.getHttpConfig().getMessageSizeLimit()) {
            HttpInboundChannelFactory factory = this.myLink.getChannel().getFactory();
            if (factory.getConfig().areMessagesLimited() && factory.allowLargeMessage(this.queryIncomingMsgSize())) {
                this.bContainsLargeMessage = true;
            } else {
                throw new MessageTooLargeException("Size=" + this.queryIncomingMsgSize());
            }
        }
    }

    public final HttpInboundLink getLink() {
        return this.myLink;
    }

    @Override
    protected boolean reconnectAllowed() {
        return false;
    }

    @Override
    public HttpObjectFactory getObjectFactory() {
        return null == this.myLink ? null : this.myLink.getObjectFactory();
    }

    @Override
    public boolean isInboundConnection() {
        return true;
    }

    @Override
    public void logLegacyMessage() {
        HttpPlatformUtils utils2;
        if (this.getHttpConfig().isControlRegion() && this.writingHeaders() && null != (utils2 = (HttpPlatformUtils)HttpDispatcher.getFramework().lookupService(HttpPlatformUtils.class))) {
            utils2.logLegacyMessage(this);
        }
    }

    @Override
    public long getStartNanoTime() {
        return this.startTime;
    }

    @Override
    public void resetStartTime() {
        this.startTime = 0L;
    }

    @Override
    public void setStartTime() {
        if (0L == this.startTime && this.getHttpConfig().isAccessLoggingEnabled()) {
            this.startTime = System.nanoTime();
            if (Objects.nonNull(this.nettyContext)) {
                this.nettyContext.channel().attr(NettyHttpConstants.REQUEST_START_TIME).set((Object)this.startTime);
            }
        }
    }

    public boolean send101SwitchingProtocol(String protocol) {
        if (this.myLink.getChannel().isStopped()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Channel stopped, sending error instead of 100-continue", (Object[])new Object[0]);
            }
            try {
                this.sendError(StatusCodes.UNAVAILABLE.getHttpError());
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".check100Continue"), (String)"1206");
            }
            return false;
        }
        if (this.getHttpConfig().isServantRegion()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"100 continue not sent on SR", (Object[])new Object[0]);
            }
            return true;
        }
        HttpResponseMessageImpl msg = this.getResponseImpl();
        msg.setStatusCode(StatusCodes.SWITCHING_PROTOCOLS);
        msg.setHeader((HeaderKeys)HttpHeaderKeys.HDR_UPGRADE, protocol);
        msg.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_CONNECTION, "Upgrade");
        msg.setContentLength(0L);
        VirtualConnection vc = this.sendHeaders(msg, Http100ContWriteCallback.getRef());
        if (null == vc) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Async write of 100 continue still going", (Object[])new Object[0]);
            }
            return false;
        }
        this.resetMsgSentState();
        msg.setStatusCode(StatusCodes.OK);
        msg.setVersion(VersionValues.V20);
        msg.removeHeader(HttpHeaderKeys.HDR_CONTENT_LENGTH);
        msg.removeHeader(HttpHeaderKeys.HDR_UPGRADE);
        msg.removeHeader(HttpHeaderKeys.HDR_CONNECTION);
        return true;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void initForwardedValues() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initForwardedValues", (Object[])new Object[0]);
        }
        this.forwardedHeaderInitialized = Boolean.TRUE;
        if (Objects.nonNull(this.nettyRequest)) {
            this.nettyInitForwardedValues();
        } else {
            this.legacyInitForwardedValues();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initForwardedValues");
        }
    }

    private void legacyInitForwardedValues() {
        String remoteIp;
        Pattern pattern = this.getHttpConfig().getForwardedProxiesRegex();
        Matcher matcher = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Verifying connected endpoint matches proxy regex", (Object[])new Object[0]);
        }
        if ((matcher = pattern.matcher(remoteIp = this.getTSC().getRemoteAddress().getHostAddress())).matches()) {
            String[] forwardedForList;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Connected endpoint matched, verifying forwarded FOR list addresses", (Object[])new Object[0]);
            }
            if ((forwardedForList = this.getMessageBeingParsed().getForwardedForList()) == null || forwardedForList.length == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No forwarded FOR addresses provided, forwarded values will not be used", (Object[])new Object[0]);
                    Tr.exit((TraceComponent)tc, (String)"initForwardedValues");
                }
                return;
            }
            for (int i = forwardedForList.length - 1; i > 0; --i) {
                matcher = pattern.matcher(forwardedForList[i]);
                if (matcher.matches()) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found address not defined in proxy regex, forwarded values will not be used", (Object[])new Object[0]);
                    Tr.exit((TraceComponent)tc, (String)"initForwardedValues");
                }
                return;
            }
            if (forwardedForList[0] == null || "unknown".equals(forwardedForList[0]) || forwardedForList[0].startsWith("_")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Client address is unknown or obfuscated, forwarded values will not be used", (Object[])new Object[0]);
                    Tr.exit((TraceComponent)tc, (String)"initForwardedValues");
                }
                return;
            }
            if (this.getMessageBeingParsed().getForwardedPort() != null) {
                try {
                    this.forwardedRemotePort = Integer.parseInt(this.getMessageBeingParsed().getForwardedPort());
                }
                catch (NumberFormatException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Remote port provided was either obfuscated or malformed, forwarded values will not be used.", (Object[])new Object[0]);
                        Tr.exit((TraceComponent)tc, (String)"initForwardedValues");
                    }
                    return;
                }
            }
            this.forwardedRemoteAddress = forwardedForList[0];
            this.forwardedHost = this.getMessageBeingParsed().getForwardedHost();
            this.forwardedProto = this.getMessageBeingParsed().getForwardedProto();
        }
    }

    private void nettyInitForwardedValues() {
        Pattern pattern = this.getHttpConfig().getForwardedProxiesRegex();
        Matcher matcher = null;
        String remoteIp = this.nettyContext.channel().remoteAddress().toString();
        matcher = pattern.matcher(remoteIp = remoteIp.substring(1, remoteIp.indexOf(58)));
        if (matcher.matches()) {
            String[] forwardedForList;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Connected endpoint matched, verifying forwarded FOR list addresses", (Object[])new Object[0]);
            }
            if (Objects.isNull(forwardedForList = (String[])this.nettyContext.channel().attr(NettyHttpConstants.FORWARDED_FOR_KEY).get()) || forwardedForList.length == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No forwarded FOR addresses provided, forwarded values will not be used", (Object[])new Object[0]);
                    Tr.exit((TraceComponent)tc, (String)"initForwardedValues");
                }
                return;
            }
            for (int i = forwardedForList.length - 1; i > 0; --i) {
                matcher = pattern.matcher(forwardedForList[i]);
                if (matcher.matches()) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found address not defined in proxy regex, forwarded values will not be used", (Object[])new Object[0]);
                    Tr.exit((TraceComponent)tc, (String)"initForwardedValues");
                }
                return;
            }
            if (Objects.isNull(forwardedForList[0]) || "unknown".equals(forwardedForList[0]) || forwardedForList[0].startsWith("_")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Client address is unknown or obfuscated, forwarded values will not be used", (Object[])new Object[0]);
                    Tr.exit((TraceComponent)tc, (String)"initForwardedValues");
                }
                return;
            }
            String attribute = (String)this.nettyContext.channel().attr(NettyHttpConstants.FORWARDED_PORT_KEY).get();
            if (Objects.nonNull(attribute)) {
                try {
                    this.forwardedRemotePort = Integer.parseInt(attribute);
                }
                catch (NumberFormatException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Remote port provided was either obfuscated or malformed, forwarded values will not be used.", (Object[])new Object[0]);
                        Tr.exit((TraceComponent)tc, (String)"initForwardedValues");
                    }
                    return;
                }
            }
            this.forwardedRemoteAddress = forwardedForList[0];
            this.forwardedHost = (String)this.nettyContext.channel().attr(NettyHttpConstants.FORWARDED_HOST_KEY).get();
            this.forwardedProto = (String)this.nettyContext.channel().attr(NettyHttpConstants.FORWARDED_PROTO_KEY).get();
        }
    }

    public int getForwardedRemotePort() {
        if (!this.forwardedHeaderInitialized) {
            this.initForwardedValues();
        }
        return this.forwardedRemotePort;
    }

    @Override
    public String getForwardedRemoteAddress() {
        if (!this.forwardedHeaderInitialized) {
            this.initForwardedValues();
        }
        return this.forwardedRemoteAddress;
    }

    @Override
    public String getForwardedRemoteProto() {
        if (!this.forwardedHeaderInitialized) {
            this.initForwardedValues();
        }
        return this.forwardedProto;
    }

    @Override
    public String getForwardedRemoteHost() {
        if (!this.forwardedHeaderInitialized) {
            this.initForwardedValues();
        }
        return this.forwardedHost;
    }

    public boolean useRemoteIpOptions() {
        return this.getHttpConfig().useForwardingHeaders();
    }

    @Override
    public boolean useRemoteIpInAccessLog() {
        return this.getHttpConfig().useForwardingHeadersInAccessLog();
    }

    public boolean isHttp2Enabled() {
        boolean isHTTP2Enabled = false;
        Boolean defaultSetting = CHFWBundle.getHttp2DefaultSetting();
        if (defaultSetting != null) {
            Boolean configSetting = this.getHttpConfig().getUseH2ProtocolAttribute();
            if (Boolean.FALSE == defaultSetting) {
                isHTTP2Enabled = configSetting != null && configSetting != false;
            } else {
                boolean bl = isHTTP2Enabled = configSetting == null || configSetting != false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Has HTTP/2 been enabled on this port: " + isHTTP2Enabled), (Object[])new Object[0]);
        }
        return isHTTP2Enabled;
    }

    public void setSuppress0ByteChunk(boolean suppress0ByteChunk) {
        this.suppress0ByteChunk = suppress0ByteChunk;
    }

    public boolean getSuppress0ByteChunk() {
        return this.suppress0ByteChunk;
    }
}

