/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.token;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.common.jwt.JwtParsingUtils;
import io.openliberty.security.common.jwt.jws.JwsSignatureVerifier;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.config.MetadataUtils;
import io.openliberty.security.oidcclientcore.exceptions.OidcClientConfigurationException;
import io.openliberty.security.oidcclientcore.exceptions.OidcDiscoveryException;
import io.openliberty.security.oidcclientcore.jwt.JwtUtils;
import io.openliberty.security.oidcclientcore.storage.Storage;
import io.openliberty.security.oidcclientcore.storage.StorageFactory;
import io.openliberty.security.oidcclientcore.token.IdTokenValidator;
import io.openliberty.security.oidcclientcore.token.TokenResponse;
import io.openliberty.security.oidcclientcore.token.TokenValidationException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TokenResponseValidator {
    public static final TraceComponent tc = Tr.register(TokenResponseValidator.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    private final OidcClientConfig clientConfig;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private Storage storage;
    static final long serialVersionUID = -4223112646185247046L;

    public TokenResponseValidator(OidcClientConfig oidcClientConfig, HttpServletRequest request, HttpServletResponse response) {
        this.clientConfig = oidcClientConfig;
        this.request = request;
        this.response = response;
    }

    @FFDCIgnore(value={TokenValidationException.class, Exception.class})
    public JwtClaims validate(TokenResponse tokenResponse) throws TokenValidationException {
        String idtoken = null;
        if (tokenResponse != null) {
            idtoken = tokenResponse.getIdTokenString();
        }
        if (idtoken == null) {
            return new JwtClaims();
        }
        JwtContext jwtcontext = this.getJwtContextForIdToken(idtoken);
        JwtClaims jwtClaims = this.getJwtClaimsFromIdTokenContext(jwtcontext);
        String clientSecret = null;
        ProtectedString clientSecretProtectedString = this.clientConfig.getClientSecret();
        if (clientSecretProtectedString != null) {
            clientSecret = new String(clientSecretProtectedString.getChars());
        }
        try {
            String issuerconfigured = this.validateIdTokenClaimsAndGetIssuer(jwtClaims, clientSecret);
            return this.validateIdTokenFormat(jwtcontext, issuerconfigured);
        }
        catch (TokenValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TokenValidationException(this.clientConfig.getClientId(), e.toString());
        }
    }

    @FFDCIgnore(value={InvalidJwtException.class})
    JwtContext getJwtContextForIdToken(String idTokenString) throws TokenValidationException {
        JwtContext jwtContext = null;
        try {
            jwtContext = JwtParsingUtils.parseJwtWithoutValidation((String)idTokenString);
        }
        catch (InvalidJwtException e) {
            throw new TokenValidationException(this.clientConfig.getClientId(), e.toString());
        }
        return jwtContext;
    }

    JwtClaims getJwtClaimsFromIdTokenContext(JwtContext jwtContext) throws TokenValidationException {
        JwtClaims jwtClaims = null;
        if (jwtContext != null) {
            jwtClaims = jwtContext.getJwtClaims();
        }
        if (jwtClaims == null || jwtClaims.getClaimsMap().isEmpty()) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"TOKEN_MISSING_CLAIMS", (Object[])new Object[]{this.clientConfig.getClientId()});
            throw new TokenValidationException(this.clientConfig.getClientId(), msg);
        }
        return jwtClaims;
    }

    String validateIdTokenClaimsAndGetIssuer(JwtClaims jwtClaims, @Sensitive String clientSecret) throws MalformedClaimException, TokenValidationException, OidcDiscoveryException, OidcClientConfigurationException {
        if (jwtClaims.getIssuedAt() == null) {
            String nlsMsg = Tr.formatMessage((TraceComponent)tc, (String)"TOKEN_MISSING_REQUIRED_CLAIM", (Object[])new Object[]{"iat"});
            throw new TokenValidationException(this.clientConfig.getClientId(), nlsMsg);
        }
        if (jwtClaims.getExpirationTime() == null) {
            String nlsMsg = Tr.formatMessage((TraceComponent)tc, (String)"TOKEN_MISSING_REQUIRED_CLAIM", (Object[])new Object[]{"exp"});
            throw new TokenValidationException(this.clientConfig.getClientId(), nlsMsg);
        }
        IdTokenValidator tokenValidator = new IdTokenValidator(this.clientConfig);
        String issuerconfigured = MetadataUtils.getIssuer(this.clientConfig);
        tokenValidator.issuer(jwtClaims.getIssuer()).subject(jwtClaims.getSubject()).audiences(jwtClaims.getAudience()).azp((String)jwtClaims.getClaimValue("azp")).iat(jwtClaims.getIssuedAt()).exp(jwtClaims.getExpirationTime()).nbf(jwtClaims.getNotBefore()).issuerconfigured(issuerconfigured);
        tokenValidator.validate();
        if (this.clientConfig.isUseNonce()) {
            tokenValidator.nonce((String)jwtClaims.getClaimValue("nonce"));
            tokenValidator.state(this.getStateParameter());
            tokenValidator.secret(clientSecret);
            this.storage = StorageFactory.instantiateStorage(this.request, this.response, this.clientConfig.isUseSession());
            tokenValidator.storage(this.storage);
            tokenValidator.validateNonce();
        }
        return issuerconfigured;
    }

    JwtClaims validateIdTokenFormat(JwtContext jwtContext, String issuerConfigured) throws Exception {
        JwsSignatureVerifier.Builder verifierBuilder = JwtUtils.verifyJwsAlgHeaderAndCreateJwsSignatureVerifierBuilder(jwtContext, this.clientConfig, this.getSigningAlgorithmsAllowed());
        JwsSignatureVerifier signatureVerifier = verifierBuilder.build();
        JsonWebStructure jws = JwtParsingUtils.getJsonWebStructureFromJwtContext((JwtContext)jwtContext);
        JwtConsumerBuilder builder = signatureVerifier.createJwtConsumerBuilderWithConstraints(jws.getAlgorithmHeaderValue());
        builder.setRequireExpirationTime().setAllowedClockSkewInSeconds(120).setExpectedAudience(new String[]{this.clientConfig.getClientId()}).setExpectedIssuer(issuerConfigured).setRequireSubject();
        JwtConsumer jwtConsumer = builder.build();
        return JwtParsingUtils.parseJwtWithValidation((String)jwtContext.getJwt(), (JwtConsumer)jwtConsumer);
    }

    @FFDCIgnore(value={OidcClientConfigurationException.class})
    String[] getSigningAlgorithmsAllowed() {
        String[] signingAlgsAllowed = null;
        try {
            signingAlgsAllowed = MetadataUtils.getIdTokenSigningAlgorithmsSupported(this.clientConfig);
        }
        catch (OidcClientConfigurationException | OidcDiscoveryException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception getting ID token signing algorithm supported. Defaulting to RS256. Exception was: " + e.getMessage()), (Object[])new Object[0]);
            }
            signingAlgsAllowed = new String[]{"RS256"};
        }
        return signingAlgsAllowed;
    }

    public String getStateParameter() {
        return this.request.getParameter("state");
    }
}

