/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.monitor.metrics;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.http.monitor.HttpStatAttributes;
import io.openliberty.http.monitor.metrics.HTTPMetricAdapter;
import java.time.Duration;
import java.util.List;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public class MetricsManager {
    private static MetricsManager instance;
    private static final TraceComponent tc;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile List<HTTPMetricAdapter> httpMetricRuntimes;
    static final long serialVersionUID = -7783160601115248244L;

    @Activate
    public void activate() {
        instance = this;
    }

    @Deactivate
    public void deactivate() {
        instance = null;
    }

    public static MetricsManager getInstance() {
        if (instance != null) {
            return instance;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No RestMetricManager Instance available ", (Object[])new Object[0]);
        }
        return null;
    }

    public void updateHttpMetrics(HttpStatAttributes httpStatAttributes, Duration duration) {
        for (HTTPMetricAdapter adapter : this.httpMetricRuntimes) {
            adapter.updateHttpMetrics(httpStatAttributes, duration);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        tc = Tr.register(MetricsManager.class, null, null);
    }
}

