/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillClose;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.shredzone.acme4j.Identifier;

@ParametersAreNonnullByDefault
public final class CertificateUtils {
    public static final ASN1ObjectIdentifier ACME_VALIDATION = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.1.31").intern();

    private CertificateUtils() {
    }

    public static PKCS10CertificationRequest readCSR(@WillClose InputStream in) throws IOException {
        try (PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(in, StandardCharsets.US_ASCII));){
            Object parsedObj = pemParser.readObject();
            if (!(parsedObj instanceof PKCS10CertificationRequest)) {
                throw new IOException("Not a PKCS10 CSR");
            }
            PKCS10CertificationRequest pKCS10CertificationRequest = (PKCS10CertificationRequest)parsedObj;
            return pKCS10CertificationRequest;
        }
    }

    public static X509Certificate createTlsAlpn01Certificate(KeyPair keypair, Identifier id, byte[] acmeValidation) throws IOException {
        Objects.requireNonNull(keypair, "keypair");
        Objects.requireNonNull(id, "id");
        if (acmeValidation == null || acmeValidation.length != 32) {
            throw new IllegalArgumentException("Bad acmeValidation parameter");
        }
        long now = System.currentTimeMillis();
        String signatureAlg = "SHA256withRSA";
        try {
            X500Name issuer = new X500Name("CN=acme.invalid");
            BigInteger serial = BigInteger.valueOf(now);
            Instant notBefore = Instant.ofEpochMilli(now);
            Instant notAfter = notBefore.plus(Duration.ofDays(7L));
            JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(issuer, serial, Date.from(notBefore), Date.from(notAfter), issuer, keypair.getPublic());
            GeneralName[] gns = new GeneralName[1];
            switch (id.getType()) {
                case "dns": {
                    gns[0] = new GeneralName(2, id.getDomain());
                    break;
                }
                case "ip": {
                    gns[0] = new GeneralName(7, id.getIP().getHostAddress());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported Identifier type " + id.getType());
                }
            }
            certBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(gns));
            certBuilder.addExtension(ACME_VALIDATION, true, (ASN1Encodable)new DEROctetString(acmeValidation));
            JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder("SHA256withRSA");
            byte[] cert = certBuilder.build(signerBuilder.build(keypair.getPrivate())).getEncoded();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(cert));
        }
        catch (CertificateException | OperatorCreationException ex) {
            throw new IOException(ex);
        }
    }
}

