/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility;

import com.ibm.ws.jbatch.utility.JBatchUtilityTask;
import com.ibm.ws.jbatch.utility.tasks.GetJobLogTask;
import com.ibm.ws.jbatch.utility.tasks.HelpTask;
import com.ibm.ws.jbatch.utility.tasks.ListJobsTask;
import com.ibm.ws.jbatch.utility.tasks.PurgeTask;
import com.ibm.ws.jbatch.utility.tasks.RestartTask;
import com.ibm.ws.jbatch.utility.tasks.StatusTask;
import com.ibm.ws.jbatch.utility.tasks.StopTask;
import com.ibm.ws.jbatch.utility.tasks.SubmitTask;
import com.ibm.ws.jbatch.utility.utils.ArgumentRequiredException;
import com.ibm.ws.jbatch.utility.utils.ConsoleWrapper;
import com.ibm.ws.jbatch.utility.utils.InvalidArgumentValueException;
import com.ibm.ws.jbatch.utility.utils.ObjectUtils;
import com.ibm.ws.jbatch.utility.utils.ResourceBundleUtils;
import com.ibm.ws.jbatch.utility.utils.StringUtils;
import com.ibm.ws.jbatch.utility.utils.TaskIO;
import com.ibm.ws.jbatch.utility.utils.TaskList;
import com.ibm.ws.jbatch.utility.utils.UnrecognizedArgumentException;
import java.io.IOException;
import java.io.PrintStream;

public class JBatchUtility {
    static final String SCRIPT_NAME = "batchManager";
    private final ConsoleWrapper stdin;
    private final PrintStream stdout;
    private final PrintStream stderr;
    private TaskList tasks = new TaskList();

    protected JBatchUtility() {
        this(new ConsoleWrapper(System.console(), System.err), System.out, System.err);
    }

    private JBatchUtility(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr) {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        this.registerTask(new HelpTask(SCRIPT_NAME, this.tasks));
    }

    private boolean registerTask(JBatchUtilityTask task) {
        return this.tasks.add(task);
    }

    private JBatchUtilityTask getTask(String name) {
        return this.tasks.forName(name);
    }

    private HelpTask getHelpTask() {
        return (HelpTask)this.getTask("help");
    }

    protected int runProgram(String[] args) {
        JBatchUtilityTask task;
        if (this.stdin == null) {
            this.stderr.println(ResourceBundleUtils.getMessage("error.missingIO", "stdin"));
            return 254;
        }
        if (this.stdout == null) {
            this.stderr.println(ResourceBundleUtils.getMessage("error.missingIO", "stdout"));
            return 253;
        }
        if (this.stderr == null) {
            this.stdout.println(ResourceBundleUtils.getMessage("error.missingIO", "stderr"));
            return 252;
        }
        if (args.length == 0) {
            this.stdout.println(this.getHelpTask().getScriptUsage());
            return 0;
        }
        if (this.looksLikeHelp(args[0])) {
            args[0] = this.getHelpTask().getTaskName();
        }
        if ((task = this.getTask(args[0])) == null) {
            this.stderr.println(ResourceBundleUtils.getMessage("task.unknown", args[0]));
            this.stderr.println(this.getHelpTask().getScriptUsage());
            return 0;
        }
        try {
            return task.handleTask(this.stdin, this.stdout, this.stderr, args);
        }
        catch (ArgumentRequiredException are) {
            return this.handleArgumentRequiredException(task, are);
        }
        catch (UnrecognizedArgumentException ure) {
            return this.handleUnrecognizedArgumentException(task, ure);
        }
        catch (InvalidArgumentValueException iave) {
            return this.handleInvalidArgumentValueException(task, iave);
        }
        catch (IOException ioe) {
            return this.handleIOException(ioe);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    private int handleException(Exception e) {
        this.stderr.println();
        this.stderr.println(TaskIO.getTimestamp() + " " + ResourceBundleUtils.getMessage("error", ObjectUtils.firstNonNull(e.getMessage(), "")));
        e.printStackTrace(this.stderr);
        return 255;
    }

    private int handleInvalidArgumentValueException(JBatchUtilityTask task, InvalidArgumentValueException iave) {
        this.stderr.println();
        this.stderr.println(ResourceBundleUtils.getMessage("argument.invalid.value", iave.getArgName(), iave.getInvalidValue(), iave.getPermittedValues()));
        this.stderr.println(ResourceBundleUtils.getMessage("for.task.usage", SCRIPT_NAME, "help", task.getTaskName()));
        return 22;
    }

    protected int handleArgumentRequiredException(JBatchUtilityTask task, ArgumentRequiredException are) {
        this.stderr.println();
        this.stderr.println(ResourceBundleUtils.getMessage("argument.required", are.getArgName()));
        this.stderr.println(ResourceBundleUtils.getMessage("for.task.usage", SCRIPT_NAME, "help", task.getTaskName()));
        return 20;
    }

    protected int handleUnrecognizedArgumentException(JBatchUtilityTask task, UnrecognizedArgumentException ure) {
        this.stderr.println();
        if (StringUtils.isEmpty(ure.getExpectedArg())) {
            this.stderr.println(ResourceBundleUtils.getMessage("argument.unrecognized", ure.getUnrecognizedArg()));
        } else {
            this.stderr.println(ResourceBundleUtils.getMessage("argument.unrecognized.expected", ure.getUnrecognizedArg(), ure.getExpectedArg()));
        }
        this.stderr.println(ResourceBundleUtils.getMessage("for.task.usage", SCRIPT_NAME, "help", task.getTaskName()));
        return 21;
    }

    protected int handleIOException(IOException ioe) {
        if (ioe.getMessage().contains("CWWKY0151E")) {
            this.stderr.println();
            this.stderr.println(ioe.getMessage());
            return 23;
        }
        return this.handleException(ioe);
    }

    protected boolean looksLikeHelp(String taskname) {
        return this.getHelpTask().getTaskName().equalsIgnoreCase(this.stripLeadingNonLetters(taskname));
    }

    protected String stripLeadingNonLetters(String str) {
        int start;
        if (str == null) {
            return "";
        }
        int len = str.length();
        for (start = 0; start < len && !Character.isLetter(str.charAt(start)); ++start) {
        }
        return str.substring(start);
    }

    public static void main(String[] args) {
        JBatchUtility util = new JBatchUtility();
        util.registerTask(new SubmitTask(SCRIPT_NAME));
        util.registerTask(new StopTask(SCRIPT_NAME));
        util.registerTask(new RestartTask(SCRIPT_NAME));
        util.registerTask(new StatusTask(SCRIPT_NAME));
        util.registerTask(new GetJobLogTask(SCRIPT_NAME));
        util.registerTask(new ListJobsTask(SCRIPT_NAME));
        util.registerTask(new PurgeTask(SCRIPT_NAME));
        int rc = util.runProgram(args);
        System.exit(rc);
    }
}

