/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.config.internal.serverxml;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.config.internal.common.InternalConfigSource;
import io.openliberty.microprofile.config.internal.serverxml.AppPropertiesTrackingComponent;
import io.openliberty.microprofile.config.internal.serverxml.OSGiConfigUtils;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AppPropertyConfigSource
extends InternalConfigSource {
    private static final TraceComponent tc = Tr.register(AppPropertyConfigSource.class, (String)"APPCONFIG", (String)"io.openliberty.microprofile.config.internal.serverxml");
    private final PrivilegedAction<String> getApplicationPidAction = new GetApplicationPidAction();
    private final String name = Tr.formatMessage((TraceComponent)tc, (String)"server.xml.appproperties.config.source", (Object[])new Object[0]);
    private BundleContext bundleContext;
    private String applicationName;
    private String applicationPID;
    static final long serialVersionUID = 5048244165446569754L;

    @Trivial
    public AppPropertyConfigSource() {
    }

    @Trivial
    public String getName() {
        return this.name;
    }

    @Trivial
    protected int getDefaultOrdinal() {
        return 600;
    }

    public Set<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    public String getValue(String key) {
        return this.getProperties().get(key);
    }

    public Map<String, String> getProperties() {
        String appPid = System.getSecurityManager() == null ? this.getApplicationPID() : AccessController.doPrivileged(this.getApplicationPidAction);
        if (appPid != null) {
            return AppPropertiesTrackingComponent.getAppProperties(appPid);
        }
        return Collections.emptyMap();
    }

    private BundleContext getBundleContext() {
        if (this.bundleContext == null) {
            this.bundleContext = OSGiConfigUtils.getBundleContext(((Object)((Object)this)).getClass());
        }
        return this.bundleContext;
    }

    private String getApplicationName() {
        BundleContext bundleContext;
        if (this.applicationName == null && (bundleContext = this.getBundleContext()) != null) {
            this.applicationName = OSGiConfigUtils.getApplicationName(bundleContext);
        }
        return this.applicationName;
    }

    private String getApplicationPID() {
        BundleContext bundleContext;
        if (this.applicationPID == null && (bundleContext = this.getBundleContext()) != null) {
            this.applicationPID = OSGiConfigUtils.getApplicationPID(bundleContext, this.getApplicationName());
        }
        return this.applicationPID;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class GetApplicationPidAction
    implements PrivilegedAction<String> {
        static final long serialVersionUID = -3819088941937147951L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private GetApplicationPidAction() {
        }

        @Override
        public String run() {
            return AppPropertyConfigSource.this.getApplicationPID();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.config.internal.serverxml.AppPropertyConfigSource$GetApplicationPidAction", GetApplicationPidAction.class, (String)"APPCONFIG", (String)"io.openliberty.microprofile.config.internal.serverxml");
        }
    }
}

