/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.acs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.internal.utils.SignatureMethods;
import java.util.List;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.security.impl.BaseSAMLXMLSignatureSecurityHandler;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoCriterion;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.opensaml.xmlsec.signature.support.impl.BaseSignatureTrustEngine;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SAMLMessageXMLSignatureSecurityPolicyRule
extends BaseSAMLXMLSignatureSecurityHandler {
    private static TraceComponent tc = Tr.register(SAMLMessageXMLSignatureSecurityPolicyRule.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    private SignaturePrevalidator signaturePrevalidator;
    String processType = "";
    static final long serialVersionUID = -1096247527616695321L;

    public SAMLMessageXMLSignatureSecurityPolicyRule() {
        this.setSignaturePrevalidator((SignaturePrevalidator)new SAMLSignatureProfileValidator());
    }

    public void setSignaturePrevalidator(SignaturePrevalidator validator) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.signaturePrevalidator = validator;
    }

    public void doInvoke(MessageContext messageContext) throws MessageHandlerException {
        Object samlMsg = messageContext.getMessage();
        if (!(samlMsg instanceof SignableSAMLObject)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"{} Extracted SAML message was not a SignableSAMLObject, cannot process signature", (Object[])new Object[0]);
            }
            return;
        }
        SignableSAMLObject signableObject = (SignableSAMLObject)samlMsg;
        if (!signableObject.isSigned()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"{} SAML protocol message was not signed, skipping XML signature processing", (Object[])new Object[0]);
            }
            return;
        }
    }

    public void evaluateProfile(BasicMessageContext<?, ?> samlMsgCtx) throws MessageHandlerException {
        this.processType = "Profile";
        SAMLObject samlMsg = (SAMLObject)samlMsgCtx.getMessageContext().getMessage();
        if (!(samlMsg instanceof SignableSAMLObject)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Extracted SAML message was not a SignableSAMLObject, can not process signature", (Object[])new Object[0]);
            }
            return;
        }
        if (samlMsg instanceof Response) {
            Response samlResponse = (Response)samlMsg;
            List assertions = samlResponse.getAssertions();
            for (Assertion assertion : assertions) {
                if (!(assertion instanceof SignableSAMLObject)) continue;
                if (!assertion.isSigned() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"A SAML assertion is not signed. We do not allow this kind of situation", (Object[])new Object[0]);
                }
                this.evaluate(samlMsgCtx, (SignableSAMLObject)assertion);
            }
        }
    }

    public void evaluateAssertion(BasicMessageContext<?, ?> samlMsgCtx, Assertion assertion) throws MessageHandlerException {
        this.processType = "Profile";
        if (!assertion.isSigned()) {
            return;
        }
        this.evaluate(samlMsgCtx, (SignableSAMLObject)assertion);
    }

    public void evaluateProtocol(BasicMessageContext<?, ?> samlMsgCtx) throws MessageHandlerException {
        this.processType = "Protocol";
        SAMLObject samlMsg = (SAMLObject)samlMsgCtx.getMessageContext().getMessage();
        if (!(samlMsg instanceof SignableSAMLObject)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Extracted SAML message was not a SignableSAMLObject, can not process signature", (Object[])new Object[0]);
            }
            return;
        }
        SignableSAMLObject signableObject = (SignableSAMLObject)samlMsg;
        if (!signableObject.isSigned()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SAML protocol message was not signed, skipping XML signature processing", (Object[])new Object[0]);
            }
            return;
        }
        this.evaluate(samlMsgCtx, signableObject);
    }

    public void evaluateResponse(BasicMessageContext<?, ?> samlMsgCtx) throws MessageHandlerException {
        this.processType = "Protocol";
        SAMLObject samlMsg = (SAMLObject)samlMsgCtx.getMessageContext().getMessage();
        if (!(samlMsg instanceof SignableSAMLObject)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Extracted SAML message was not a SignableSAMLObject, can not process signature", (Object[])new Object[0]);
            }
            return;
        }
        SignableSAMLObject signableObject = (SignableSAMLObject)samlMsg;
        if (!signableObject.isSigned()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SAML protocol message was not signed, skipping XML signature processing", (Object[])new Object[0]);
            }
            return;
        }
        this.evaluate(samlMsgCtx, signableObject);
    }

    public void evaluate(BasicMessageContext<?, ?> samlMsgCtx, SignableSAMLObject assertion) throws MessageHandlerException {
        Signature signature = assertion.getSignature();
        this.evaluateSignatureMethod(samlMsgCtx, signature);
        this.performPreValidation(signature);
        this.doEvaluate(signature, assertion, samlMsgCtx);
    }

    protected void evaluateSignatureMethod(BasicMessageContext<?, ?> samlMsgCtx, Signature signature) throws MessageHandlerException {
        String configMethod = samlMsgCtx.getSsoConfig().getSignatureMethodAlgorithm();
        String messageMethod = signature.getSignatureAlgorithm();
        if (CryptoUtils.isFips140_3EnabledWithBetaGuard() && "http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(messageMethod)) {
            throw new MessageHandlerException("The server is configured with FIPS 140-3 enabled mode, but the received SAML assertion is signed with RSA-SHA1, which is not allowed in FIPS 140-3 mode");
        }
        if (SignatureMethods.isInboundSignatureMethodWeakerThanConfigured(messageMethod, configMethod)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Required signature method from configuration is " + configMethod), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Received signature method is " + messageMethod), (Object[])new Object[0]);
            }
            throw new MessageHandlerException("The server is configured with the signature method " + configMethod + " but the received SAML assertion is signed with the signature method " + messageMethod + ", the signature method provided is weaker than the required.");
        }
    }

    protected SAMLPeerEntityContext getPeerContext() {
        return this.getSAMLPeerEntityContext();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doEvaluate(Signature signature, SignableSAMLObject signableObject, BasicMessageContext<?, ?> samlMsgCtx) throws MessageHandlerException {
        String contextIssuer = samlMsgCtx.getInboundSamlMessageIssuer();
        MessageContext messageContext = samlMsgCtx.getMessageContext();
        SAMLPeerEntityContext peerContext = this.getSAMLPeerEntityContext();
        if (contextIssuer != null) {
            String msgType = signableObject.getElementQName().toString();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Attempting to verify signature on signed SAML " + this.processType + " message using context issuer message type: " + msgType), (Object[])new Object[0]);
            }
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(SignatureValidator.class.getClassLoader());
                if (this.evaluate(signature, contextIssuer, messageContext)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Validation of " + this.processType + " message signature succeeded, message type: " + msgType), (Object[])new Object[0]);
                    }
                    if (peerContext.isAuthenticated()) return;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Authentication via " + this.processType + " message signature succeeded for context issuer entity ID " + contextIssuer), (Object[])new Object[0]);
                    }
                    peerContext.setAuthenticated(true);
                    return;
                }
                if (!tc.isDebugEnabled()) throw new MessageHandlerException("Validation of " + this.processType + " message signature failed");
                Tr.debug((TraceComponent)tc, (String)("Validation of " + this.processType + " message signature failed for context issuer '" + contextIssuer + "', message type: " + msgType), (Object[])new Object[0]);
                throw new MessageHandlerException("Validation of " + this.processType + " message signature failed");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.acs.SAMLMessageXMLSignatureSecurityPolicyRule", (String)"279", (Object)((Object)this), (Object[])new Object[]{signature, signableObject, samlMsgCtx});
                throw new MessageHandlerException("Validation of " + this.processType + " message signature failed");
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        } else {
            if (!tc.isDebugEnabled()) throw new MessageHandlerException("Context issuer unavailable, can not validate signature");
            Tr.debug((TraceComponent)tc, (String)("Context issuer unavailable, can not attempt SAML " + this.processType + " message signature validation"), (Object[])new Object[0]);
            throw new MessageHandlerException("Context issuer unavailable, can not validate signature");
        }
    }

    private boolean mevaluate(Signature signature, String entityID, MessageContext messageContext) {
        try {
            CriteriaSet criteriaSet = this.buildCriteriaSet(entityID, messageContext);
            try {
                KeyInfoCriterion keyInfoCriteria = new KeyInfoCriterion(signature.getKeyInfo());
                CriteriaSet keyInfoCriteriaSet = new CriteriaSet(new Criterion[]{keyInfoCriteria});
                Iterable kiCredIter = ((BaseSignatureTrustEngine)this.getTrustEngine()).getKeyInfoResolver().resolve((Object)keyInfoCriteriaSet);
                Credential kiCred = (Credential)kiCredIter.iterator().next();
                return this.getTrustEngine().validate((Object)signature, criteriaSet);
            }
            catch (ResolverException resolverException) {
                FFDCFilter.processException((Throwable)resolverException, (String)"com.ibm.ws.security.saml.sso20.acs.SAMLMessageXMLSignatureSecurityPolicyRule", (String)"311", (Object)((Object)this), (Object[])new Object[]{signature, entityID, messageContext});
            }
            catch (SecurityException securityException) {
                FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.ws.security.saml.sso20.acs.SAMLMessageXMLSignatureSecurityPolicyRule", (String)"313", (Object)((Object)this), (Object[])new Object[]{signature, entityID, messageContext});
            }
        }
        catch (MessageHandlerException messageHandlerException) {
            FFDCFilter.processException((Throwable)messageHandlerException, (String)"com.ibm.ws.security.saml.sso20.acs.SAMLMessageXMLSignatureSecurityPolicyRule", (String)"316", (Object)((Object)this), (Object[])new Object[]{signature, entityID, messageContext});
        }
        return false;
    }

    protected SignaturePrevalidator getSignaturePrevalidator() {
        return this.signaturePrevalidator;
    }

    /*
     * WARNING - void declaration
     */
    protected void performPreValidation(Signature signature) throws MessageHandlerException {
        if (this.getSignaturePrevalidator() != null) {
            try {
                this.getSignaturePrevalidator().validate(signature);
            }
            catch (SignatureException signatureException) {
                void e;
                FFDCFilter.processException((Throwable)signatureException, (String)"com.ibm.ws.security.saml.sso20.acs.SAMLMessageXMLSignatureSecurityPolicyRule", (String)"342", (Object)((Object)this), (Object[])new Object[]{signature});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(this.processType + " message signature failed signature pre-validation"), (Object[])new Object[]{e});
                }
                throw new MessageHandlerException(this.processType + " message signature failed signature pre-validation", (Exception)e);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.processType + " message signature failed without pre-validation"), (Object[])new Object[0]);
            }
            throw new MessageHandlerException(this.processType + " message signature failed signature pre-validation");
        }
    }
}

