/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.servlet.filter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.openapi.servlet.filter.HtmlResponseWrapper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi.internal.common.services.OpenAPIEndpointProvider;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIEndpointFilter
implements Filter {
    private static final TraceComponent tc = Tr.register(OpenAPIEndpointFilter.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private ServiceTracker<OpenAPIEndpointProvider, OpenAPIEndpointProvider> openAPIEndpointTracker;
    static final long serialVersionUID = -5223321703693961199L;

    public void init(FilterConfig config) throws ServletException {
        this.initializeTracker(config.getServletContext());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        this.initializeTracker(req.getServletContext());
        if (!(resp instanceof HttpServletResponse)) return;
        HttpServletResponse httpServletResp = (HttpServletResponse)resp;
        httpServletResp.setHeader("cache-control", "no-store");
        HtmlResponseWrapper wrapper = new HtmlResponseWrapper(httpServletResp);
        chain.doFilter(req, (ServletResponse)wrapper);
        if (httpServletResp.getContentType() == null || !httpServletResp.getContentType().contains("text/html")) return;
        String content = new String(wrapper.getContentAsBytes(), StandardCharsets.UTF_8);
        if (this.openAPIEndpointTracker != null) {
            content = content.replaceAll("/openapi", ((OpenAPIEndpointProvider)this.openAPIEndpointTracker.getService()).getOpenAPIDocUrl());
        }
        httpServletResp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        byte[] cbytes = content.getBytes(StandardCharsets.UTF_8);
        httpServletResp.setContentLength(cbytes.length);
        ServletOutputStream sos = httpServletResp.getOutputStream();
        try {
            sos.write(cbytes);
            if (sos == null) return;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.openapi.servlet.filter.OpenAPIEndpointFilter", (String)"67", (Object)this, (Object[])new Object[]{req, resp, chain});
            if (sos == null) throw throwable;
            try {
                sos.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.microprofile.openapi.servlet.filter.OpenAPIEndpointFilter", (String)"67", (Object)this, (Object[])new Object[]{req, resp, chain});
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        sos.close();
    }

    public void destroy() {
        if (this.openAPIEndpointTracker != null) {
            this.openAPIEndpointTracker.close();
        }
    }

    private void initializeTracker(ServletContext context) {
        BundleContext bundleContext;
        if (this.openAPIEndpointTracker == null && (bundleContext = (BundleContext)context.getAttribute("osgi-bundlecontext")) != null) {
            this.openAPIEndpointTracker = new ServiceTracker(bundleContext, OpenAPIEndpointProvider.class, null);
            this.openAPIEndpointTracker.open();
        }
    }
}

