/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.error;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.ErrorHandler;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ErrorHandlerImpl
implements ErrorHandler {
    private static final TraceComponent tc = Tr.register(ErrorHandlerImpl.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    protected static final ErrorHandler instance = new ErrorHandlerImpl();
    static final long serialVersionUID = 5220185128811006558L;

    public static ErrorHandler getInstance() {
        return instance;
    }

    @Override
    public void handleException(HttpServletRequest request, HttpServletResponse response, SamlException e) throws ServletException, IOException {
        int httpErrorCode;
        ErrorHandler errorHandler = e.getErrorHanlder();
        if (errorHandler != null) {
            errorHandler.handleException(request, response, e);
            return;
        }
        if (!e.ffdcAlready()) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml20.sso20.util.ErrorHandlerImpl", (String)"78758", (Object)this);
            e.setFfdcAlready(true);
        }
        if ((httpErrorCode = e.getHttpErrorCode()) == 200) {
            httpErrorCode = 403;
        }
        response.setStatus(httpErrorCode);
        Throwable cause = e.getCause();
        if (cause instanceof ServletException) {
            throw (ServletException)cause;
        }
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        this.handleErrorResponse(request, response);
    }

    public void handleErrorResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String errorPageUrl = this.getErrorPageUrl(request);
        if (errorPageUrl == null) {
            SsoRequest samlRequest = (SsoRequest)request.getAttribute("Saml20Request");
            SsoConfig samlConfig = samlRequest == null ? null : samlRequest.getSsoConfig();
            errorPageUrl = RequestUtil.getCtxRootUrl(request, "/ibm/saml20/", samlConfig) + "errorMsg.jsp";
        }
        response.sendRedirect(errorPageUrl);
    }

    private String getErrorPageUrl(HttpServletRequest request) {
        SsoConfig samlConfig;
        SsoSamlService samlService;
        String result = null;
        SsoRequest samlRequest = (SsoRequest)request.getAttribute("Saml20Request");
        if (samlRequest != null && (samlService = samlRequest.getSsoSamlService()) != null && (samlConfig = samlService.getConfig()) != null) {
            String errorPageUrl = samlConfig.getErrorPageURL();
            result = errorPageUrl == null ? null : (errorPageUrl.isEmpty() ? null : errorPageUrl);
        }
        return result;
    }
}

