/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.error.oauth20;

import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20ExceptionUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.security.oauth20.web.WebUtils;
import java.text.MessageFormat;
import java.util.Locale;

public class OAuth20InternalException
extends OAuth20Exception {
    private static final TraceComponent tc = Tr.register(OAuth20InternalException.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final long serialVersionUID = 1L;
    String _clientId;
    private String[] unencodedTraceArguments;

    public OAuth20InternalException(Throwable cause) {
        super("server_error", "In internal error has occurred processing an OAuth 2.0 request.", cause);
    }

    public OAuth20InternalException(String msgKey, Throwable cause, String ... unencodedTraceArguments) {
        super("server_error", Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])unencodedTraceArguments), cause);
        this._msgKey = msgKey;
        this.unencodedTraceArguments = unencodedTraceArguments;
    }

    @Override
    public String formatSelf(Locale locale, String encoding) {
        String message = OAuth20ExceptionUtil.getResourceBundle(locale).getString(this._msgKey);
        if (this.unencodedTraceArguments != null) {
            Object[] encodedTraceArguments = this.getEncodedTraceArguments(locale, encoding);
            return MessageFormat.format(message, encodedTraceArguments);
        }
        return MessageFormat.format(message, new Object[0]);
    }

    private Object[] getEncodedTraceArguments(Locale locale, String encoding) {
        Object[] encodedTraceArguments = new Object[this.unencodedTraceArguments.length];
        for (int i = 0; i < this.unencodedTraceArguments.length; ++i) {
            encodedTraceArguments[i] = WebUtils.encode((String)this.unencodedTraceArguments[i], (Locale)locale, (String)encoding);
        }
        return encodedTraceArguments;
    }
}

