/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import org.eclipse.microprofile.openapi.models.info.Info;

public class InfoValidator
extends TypeValidator<Info> {
    private static final TraceComponent tc = Tr.register(InfoValidator.class);
    private static final InfoValidator INSTANCE = new InfoValidator();

    public static InfoValidator getInstance() {
        return INSTANCE;
    }

    private InfoValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Info t) {
        if (t != null) {
            ValidatorUtils.validateRequiredField(t.getVersion(), context, "version").ifPresent(helper::addValidationEvent);
            ValidatorUtils.validateRequiredField(t.getTitle(), context, "title").ifPresent(helper::addValidationEvent);
            if (t.getTermsOfService() != null && !ValidatorUtils.isValidURI(t.getTermsOfService())) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"infoTermsOfServiceInvalidURL", (Object[])new Object[]{t.getTermsOfService()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("termsOfService"), message));
            }
        }
    }
}

